<!-- Rental Price Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3><?php echo e(__('messages.our_rental_price')); ?></h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th><?php echo e(__('messages.days')); ?></th>
                                <th><?php echo e(__('messages.price')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $dailyPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__('messages.day_label', ['number' => $index + 1])); ?></td>
                                    <td><?php echo e(number_format($price, 2, ',', '.')); ?> €</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.not_bookable_title')); ?></h5>
                <p><?php echo e(__('messages.not_bookable_message')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier"><?php echo e(__('messages.carrier_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.carrier_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn"><?php echo e(__('messages.rent_carrier')); ?></button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn"><?php echo e(__('messages.bring_own_carrier')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance"><?php echo e(__('messages.insurance_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.insurance_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn"><?php echo e(__('messages.yes_insure_me')); ?></button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn"><?php echo e(__('messages.no_insurance')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest"><?php echo e(__('messages.login_modal_title')); ?></h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirect('/login')">
                    <?php echo e(__('messages.login')); ?>

                </a>
                <div class="">
                    <div class="dont-acount">
                        <p><?php echo e(__('messages.dont_have_account')); ?></p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirect('/registration')">
                        <?php echo e(__('messages.create_account')); ?>

                    </a>
                </div>
                <div class="dont-acount">
                    <p><?php echo e(__('messages.or')); ?></p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    <?php echo e(__('messages.continue_with_guest')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2"><?php echo e(__('messages.guest_title')); ?></h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label"><?php echo e(__('messages.surname')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_surname')); ?>" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label"><?php echo e(__('messages.phone_number')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_phone_number')); ?>" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" placeholder="<?php echo e(__('messages.enter_email')); ?>" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn primary-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        <?php echo e(__('messages.back')); ?>

                    </button>
                    <button class="btn primary-outline-btn" id="continueAsGuest">
                        <?php echo e(__('messages.continue')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/pages/product/partials/modals.blade.php ENDPATH**/ ?>