<?php $__env->startSection('content'); ?>

<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1><?php echo e(__('messages.change_password')); ?></h1>
                </div>
            </div>
        </div>
    </section>
    <div class="prof-main">
        <section class="comn-padd">
            <div class="container">
                <div class="inner-acount">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="inner-left-tabs">
                                <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <section id="my_booking_page">
                                <div class="comm_border_box_outer">
                                    <div class="comm_border_box">
                                        <h3 class="main-head-pro"><?php echo e(__('messages.change_password')); ?></h3>

                                        <?php if(session('success')): ?>
                                            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                                        <?php endif; ?>

                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger">
                                                <ul class="mb-0">
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($error); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <div class="upper-form-main">
                                            <div class="form-main-name-detal">
                                              <form class="form-clas-login" method="POST" action="<?php echo e(route('user.update.password')); ?>" id="changePasswordForm">
                                                <?php echo csrf_field(); ?>
                                                <div class="row">
                                                  <div class="col-md-6">
                                                    <div class="inner-main-input inner-main-input2">
                                                        <label class="form-label"><?php echo e(__('messages.current_password')); ?>*:</label>
                                                        <div class="input-pass-show">
                                                        <input type="password" class="form-control" name="current_password" id="current_password">
                                                        <i data-target="#current_password"
                                                          class="toggle-password fa-regular fa-eye"></i>
                                                        <div class="invalid-feedback"></div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <div class="col-md-6">
                                                    <div class="inner-main-input inner-main-input2">
                                                        <label class="form-label"><?php echo e(__('messages.new_password')); ?>*:</label>
                                                        <div class="input-pass-show">
                                                        <input type="password" class="form-control" name="new_password" id="new_password">
                                                        <i data-target="#new_password"
                                                          class="toggle-password fa-regular fa-eye"></i>
                                                        <div class="invalid-feedback"></div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                  <div class="col-md-6">
                                                    <div class="inner-main-input inner-main-input2">
                                                        <label class="form-label"><?php echo e(__('messages.confirm_new_password')); ?>*:</label>
                                                        <div class="input-pass-show">
                                                        <input type="password" class="form-control" name="new_password_confirmation" id="confirm_password">
                                                        <i data-target="#confirm_password"
                                                          class="toggle-password fa-regular fa-eye"></i>
                                                        <div class="invalid-feedback"></div>
                                                      </div>
                                                    </div>
                                                  </div>
                                                </div>
                                                <div class="comm_profile_two_btns">
                                                    <button type="submit" class="primary-btn"><?php echo e(__('messages.update_password')); ?></button>
                                                    <a href="<?php echo e(route('user.index')); ?>" class="secondary-btn"><?php echo e(__('messages.cancel')); ?></a>
                                                </div>
                                              </form>
                                            </div>
                                          </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('changePasswordForm');

    const currentPasswordInput = document.getElementById('current_password');
    const newPasswordInput = document.getElementById('new_password');
    const confirmPasswordInput = document.getElementById('confirm_password');

    function validatePassword(password) {
        return /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_])(?!.*\s).{8,}$/.test(password);
    }

    function showInvalid(input, message) {
        input.classList.add('is-invalid');
        const feedback = input.closest('.input-pass-show').querySelector('.invalid-feedback');
        if (feedback) feedback.textContent = message;
    }

    function clearInvalids() {
        document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    }

    form.addEventListener('submit', function (e) {
        e.preventDefault();
        clearInvalids();
        let isValid = true;

        const currentPassword = currentPasswordInput.value.trim();
        const newPassword = newPasswordInput.value.trim();
        const confirmPassword = confirmPasswordInput.value.trim();

        if (!currentPassword) {
            showInvalid(currentPasswordInput, '<?php echo e(__("messages.current_password_required")); ?>');
            isValid = false;
        }

        if (!newPassword) {
            showInvalid(newPasswordInput, '<?php echo e(__("messages.new_password_required")); ?>');
            isValid = false;
        } else if (!validatePassword(newPassword)) {
            showInvalid(newPasswordInput, '<?php echo e(__("messages.new_password_invalid")); ?>');
            isValid = false;
        }

        if (!confirmPassword) {
            showInvalid(confirmPasswordInput, '<?php echo e(__("messages.confirm_password_required")); ?>');
            isValid = false;
        } else if (newPassword !== confirmPassword) {
            showInvalid(confirmPasswordInput, '<?php echo e(__("messages.password_mismatch")); ?>');
            isValid = false;
        }

        if (isValid) {
            form.submit();
        } else {
            const firstInvalid = document.querySelector('.is-invalid');
            if (firstInvalid) {
                firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
                firstInvalid.focus();
            }
        }
    });

    // Live toggle password visibility
    document.querySelectorAll('.toggle-password').forEach(button => {
        button.addEventListener('click', () => {
            const input = document.querySelector(button.dataset.target);
            const icon = button;
            input.type = input.type === 'password' ? 'text' : 'password';
            icon.classList.toggle('fa-eye');
            icon.classList.toggle('fa-eye-slash');
        });
    });
});
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/user/password/change-password.blade.php ENDPATH**/ ?>