<?php $__env->startSection('content'); ?>
<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1>Edit Car Details</h1>
                </div>
            </div>
        </div>
    </section>
    <div class="prof-main">
        <section class="comn-padd">
          <div class="container">
            <div class="inner-acount">
              <div class="row">
                <div class="col-lg-3">
                    <div class="inner-left-tabs">
                        <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-9">              
                  <section id="edit-car-detail">
                    <div class="comm_border_box">
                      <h3 class="main-head-pro">Edit Car Details</h3>
                      <div class="upper-form-main">
                        <div class="dash_form_outer">
                            <form method="POST" action="<?php echo e(route('user.car.update')); ?>" class="row comm_form">
                                <?php echo csrf_field(); ?>
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">Manufacturer</label>
                                    <select id="manufacturer" name="manufacturer" class="form-select" >
                                        <option value="">Select Manufacturer</option>
                                        <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($manufacturer); ?>" <?php echo e($car->manufacturer == $manufacturer ? 'selected' : ''); ?>><?php echo e($manufacturer); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">Model</label>
                                    <select id="model" name="model" class="form-select" >
                                        <option value="">Select Model</option>
                                        <?php if($car->model): ?>
                                            <option value="<?php echo e($car->model); ?>" selected><?php echo e($car->model); ?></option>
                                        <?php endif; ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">Year of Make</label>
                                    <select id="year" name="year" class="form-select" >
                                        <option value="">Select Year</option>
                                        <?php if($car->year): ?>
                                            <option value="<?php echo e($car->year); ?>" selected><?php echo e($car->year); ?></option>
                                        <?php endif; ?>
                                    </select>
                                  </div>
                                </div>
                              
                          
                              
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">Trailer Hitch</label>
                                    <select class="form-select" name="trailer_hitch" >
                                      <option value="Yes" <?php echo e(isset($car) && $car->trailer_hitch ? 'selected' : ''); ?>>Yes</option>
                                      <option value="No" <?php echo e(isset($car) && !$car->trailer_hitch ? 'selected' : ''); ?>>No</option>
                                    </select>
                                  </div>
                                </div>
                              
                                <div class="comm_profile_two_btns">
                                  <button type="submit" class="primary-btn">Update Car details</button>
                                  <a href="<?php echo e(route('user.carDetails')); ?>" class="secondary-btn">Cancel</a>
                                </div>
                            </form>
                        </div>
                      </div>
                    </div>
                  </section>     
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
</main>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    var baseUrl = '/dachboxmiete/public';
    
    $('#manufacturer').change(function() {
        $('#model').prop('disabled', true).html('<option value="">Loading...</option>');
        $('#year').prop('disabled', true).html('<option value="">Select Year</option>');
        
        let manufacturer = $(this).val();
        
        if (manufacturer) {
            $.get(`${baseUrl}/car/models`, {manufacturer: manufacturer}, function(data) {
                $('#model').prop('disabled', false).html('<option value="">Select Model</option>');
                $.each(data, function(key, value) {
                    $('#model').append(`<option value="${value}" ${value == "<?php echo e($car->model ?? ''); ?>" ? 'selected' : ''}>${value}</option>`);
                });
            });
        } else {
            $('#model').prop('disabled', false).html('<option value="">Select Model</option>');
            $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
        }
    });

    $('#model').change(function() {
        $('#year').prop('disabled', true).html('<option value="">Loading...</option>');
        
        let manufacturer = $('#manufacturer').val();
        let model = $(this).val();

        if (manufacturer && model) {
            $.get(`${baseUrl}/car/years`, {
                manufacturer: manufacturer, 
                model: model
            }, function(data) {
                $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
                $.each(data, function(key, value) {
                    $('#year').append(`<option value="${value}" ${value == "<?php echo e($car->year ?? ''); ?>" ? 'selected' : ''}>${value}</option>`);
                });
            });
        } else {
            $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
        }
    });

    // Trigger change event if manufacturer is already selected
    <?php if($car->manufacturer): ?>
        $('#manufacturer').trigger('change');
    <?php endif; ?>
    
    // Trigger model change if model is already selected
    <?php if($car->model): ?>
        // Wait for models to load then select the correct one
        setTimeout(function() {
            $('#model').val("<?php echo e($car->model); ?>").trigger('change');
        }, 500);
    <?php endif; ?>
});
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/user/car-details/edit.blade.php ENDPATH**/ ?>