<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2><?php echo e(__('messages.payment_analytics')); ?></h2>
            <div class="d-flex comm_head_top_right">
                <div class="sownload-cv-pdf">
                    <a href="<?php echo e(route('vendor.payments.export.pdf', request()->query())); ?>" class="download-pdf"><?php echo e(__('messages.download_pdf')); ?></a>
                    <a href="<?php echo e(route('vendor.payments.export.csv', request()->query())); ?>" class="download-pdf"><?php echo e(__('messages.download_csv')); ?></a>
                </div>
            <select class="form-select select-main-head" aria-label="<?php echo e(__('messages.time_period_filter')); ?>">
                <option value="year" <?php echo e(request('time_period') == 'year' ? 'selected' : ''); ?>><?php echo e(__('messages.year')); ?></option>
                <option value="month" <?php echo e(request('time_period') == 'month' ? 'selected' : ''); ?>><?php echo e(__('messages.month')); ?></option>
                <option value="week" <?php echo e(request('time_period') == 'week' ? 'selected' : ''); ?>><?php echo e(__('messages.week')); ?></option>
                <option value="day" <?php echo e(request('time_period') == 'day' ? 'selected' : ''); ?>><?php echo e(__('messages.today')); ?></option>
            </select>
            </div>
        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/total.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p><?php echo e(__('messages.paypal_share')); ?></p>
                                    <h4><?php echo e($paypalPercentage); ?>%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/green-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt="">
                            </figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p><?php echo e(__('messages.credit_card_share')); ?></p>
                                    <h4><?php echo e($creditCardPercentage); ?>%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/top.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p><?php echo e(__('messages.total_refunds')); ?></p>
                                    <h4><?php echo e(number_format($totalRefunds, 2, ',', '.')); ?> €</h4>
                                    </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/lost.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p><?php echo e(__('messages.number_of_reconciliation')); ?></p>
                                    <h4><?php echo e(number_format($totalReconciliations, 2, ',', '.')); ?> €</h4>
                                    </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/parot-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6><?php echo e(__('messages.payment_management')); ?></h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main white_bg">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="<?php echo e(__('messages.search_for_user')); ?>"
                                type="text" id="payment_user" class="form-control" value="">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt"><?php echo e(__('messages.filter')); ?>:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="paymentFilterDropdown" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> <?php echo e(__('messages.filter')); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="paymentFilterDropdown">
                                <li><a class="dropdown-item filter-payment active" href="#" data-status="all"><?php echo e(__('messages.all_payments')); ?></a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="paid"><?php echo e(__('messages.completed')); ?></a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="unpaid"><?php echo e(__('messages.cancelled')); ?></a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="refund"><?php echo e(__('messages.refund')); ?></a></li>
                                <li><a class="dropdown-item filter-payment" href="#" data-status="reconciliation"><?php echo e(__('messages.reconciliation')); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th><?php echo e(__('messages.booking_id')); ?></th>
                            <th><?php echo e(__('messages.payment_id')); ?></th>
                            <th><?php echo e(__('messages.customer_name')); ?></th>
                            <th><?php echo e(__('messages.date')); ?></th>
                            <th><?php echo e(__('messages.payment_method')); ?></th>
                            <th><?php echo e(__('messages.amount')); ?></th>
                            <th><?php echo e(__('messages.refund_amount')); ?></th>
                            <th><?php echo e(__('messages.delay_fees')); ?></th>
                            <th><?php echo e(__('messages.status')); ?></th>
                            <th><?php echo e(__('messages.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody id="searchPaymentUser">
                        <?php if(count($bookings) > 0): ?>
                        <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-status="<?php echo e($booking->payment_status); ?>">
                            <td>#<?php echo e($booking->id); ?></td>
                            <td>#<?php echo e($booking->stripe_payment_intent); ?></td>
                            <td><?php echo e($booking->userDetails->first_name." ".$booking->userDetails->last_name); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($booking->created_at)->format('d.m.Y')); ?></td>
                            <td><?php echo e($booking->payment_method); ?></td>
                            <td><?php echo e($booking->total); ?> €</td>
                            <td><?php echo e($booking->refund_amount ? $booking->refund_amount : '0,00'); ?> €</td>
                            <td><?php echo e(number_format($booking->delay_fees,2,',','.')); ?> €</td>
                            <td>
                                <select class="form-select select-active-block payment_status_select"
                                    aria-label="<?php echo e(__('messages.payment_status_select')); ?>"
                                    data-current-status="<?php echo e($booking->payment_status); ?>"  <?php echo e($booking->payment_status == 'refund' ? 'disabled' : ''); ?>>
                                    <option value="paid" class="confirmed-op" <?php echo e($booking->payment_status == "paid" ? "selected" : ""); ?>><?php echo e(__('messages.completed')); ?></option>
                                    <option value="unpaid" class="cancel-op" <?php echo e($booking->payment_status == "unpaid" ? "selected" : ""); ?>><?php echo e(__('messages.cancelled')); ?></option>
                                    <option value="refund" class="refund-op" <?php echo e($booking->payment_status == "refund" ? "selected" : ""); ?> class="text-danger">Refund</option>
                                    <option value="reconciliation" class="completed-op" <?php echo e($booking->payment_status == "reconciliation" ? "selected" : ""); ?> class="text-warning">Reconciliation</option>
                                </select>   
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="<?php echo e(route('vendor.view.payment.history',[$booking->id])); ?>">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text"><?php echo e(__('messages.change_status_confirmation')); ?></h4>
                    <div id="refund-amount-group" class="mb-3" style="display:none;">
                        <p style = "margin-top : -28px ; margin-bottom : 1rem; font-size: 12px"><strong> <?php echo e(__('messages.attention')); ?> : </strong> <?php echo e(__('messages.refund_one_time_warning')); ?> </p>
                        <label for="refund-amount" class="form-label"><?php echo e(__('messages.enter_refund_amount')); ?></label>
                        <input type="number" class="form-control" id="refund-amount" name="refund_amount" min="0" step="0.01" required>
                    </div>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary"><?php echo e(__('messages.no')); ?></button>
                        <form id="status-change-form" method="POST" action="">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="payment_status" id="new-status">
                            <input type="hidden" name="refund_amount" id="new_refund_amount">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary"><?php echo e(__('messages.yes')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";

    $(document).ready(function () {
        $('#bookingTable').DataTable({
            paging: true,
            searching: true, 
            info: true,
            lengthChange: true,
            pageLength: 10,
            ordering: false, 
            language: {
                lengthMenu: '<?php echo e(__("messages.show_entries")); ?>',
                paginate: {
                    previous: '&laquo;',
                    next: '&raquo;'
                }
            },
            dom: '<"top"lf>rt<"bottom"ip><"clear">'
        });
    });

    $('#payment_user').on('keyup', function() {
        activeSearch = $(this).val().trim().toLowerCase();
        $('#bookingTable').DataTable().search(this.value).draw();
        updateDownloadLinks();
        filterPaymentTable();
    });

    $(document).ready(function() {
        let activeStatus = 'all';
        let activeSearch = '';
        let activeTimePeriod = $('.select-main-head').val();

        function updateDownloadLinks() {
            const timePeriod = $('.select-main-head').val();
            const status = $('.filter-payment.active').data('status');
            const search = $('#payment_user').val();
            
            $('.download-pdf').each(function(index) {
                let baseUrl = $(this).attr('href').split('?')[0];
                $(this).attr('href', 
                    `${baseUrl}?time_period=${timePeriod}&status=${status}&search=${encodeURIComponent(search)}`
                );
            });
        }

        function filterPaymentTable() {
            const rows = $('#searchPaymentUser tr');
            let hasVisibleRows = false;
            
            rows.each(function() {
                if ($(this).text().trim() === '<?php echo e(__("messages.no_payments_found")); ?>') {
                    return true;
                }
                
                const statusMatch = activeStatus === 'all' || 
                                  $(this).data('status') === activeStatus;
                const searchMatch = activeSearch === '' || 
                                  $(this).text().toLowerCase().includes(activeSearch);
                
                if (statusMatch && searchMatch) {
                    $(this).show();
                    hasVisibleRows = true;
                } else {
                    $(this).hide();
                }
            });
            
            const noResultsRow = $('#searchPaymentUser tr.text-center');
            if (noResultsRow.length) {
                noResultsRow.toggle(!hasVisibleRows);
            }
        }

        updateDownloadLinks();
        filterPaymentTable();

        $('.filter-payment').on('click', function(e) {
            e.preventDefault();
            
            $('.filter-payment').removeClass('active');
            $(this).addClass('active');
            activeStatus = $(this).data('status');
            
            $('#paymentFilterDropdown').html(`<i class="fa-solid fa-filter"></i> ${$(this).text().trim()}`);
            
            updateDownloadLinks();
            filterPaymentTable();
        });
        
        $('.select-main-head').on('change', function() {
            activeTimePeriod = $(this).val();
            updateDownloadLinks();
            
            const url = new URL(window.location.href);
            url.searchParams.set('time_period', activeTimePeriod);
            window.history.pushState({}, '', url);
            location.reload();
        });

        $('.payment_status_select').on('change', function() {
            const $select = $(this);
            const selectedValue = $select.val();
            const bookingId = $select.closest('tr').find('td:first').text().replace('#', '');
            const currentStatus = $select.data('current-status') || "";

            if (selectedValue === currentStatus) {
                return;
            }

            const formAction = `${baseUrl}/vendor/bookings/${bookingId}/update-payment-status`;
            $('#status-change-form').attr('action', formAction);
            
            $('#new-status').val(selectedValue);
            
            let message = '';
            switch (selectedValue) {
                case 'paid':
                    message = '<?php echo e(__("messages.confirm_mark_completed")); ?>';
                    $('#refund-amount-group').hide();
                    break;
                case 'unpaid':
                    message = '<?php echo e(__("messages.confirm_mark_cancelled")); ?>';
                    $('#refund-amount-group').hide();
                    break;
                case 'refund':
                    message = '<?php echo e(__("messages.confirm_mark_refunded")); ?>';
                    $('#refund-amount-group').show();
                    break;
                case 'reconciliation':
                    message = '<?php echo e(__("messages.confirm_mark_reconciliation")); ?>';
                    $('#refund-amount-group').hide();
                    break;
                default:
                    $('#refund-amount-group').hide();
            }
            
            $('#status-text').text(message);
            $('#changestatus').modal('show');
            $('#changestatus').data('select', $select);
            $('#changestatus').data('current-status', currentStatus);
        });

        $('#status-change-form').on('submit', function(e) {
            e.preventDefault();
            
            const form = $(this);
            const url = form.attr('action');
            const $select = $('#changestatus').data('select');
            const currentStatus = $('#changestatus').data('current-status');
            const newStatus = $('#new-status').val();
            

            if (newStatus === 'refund') {
                const refundAmount = $('#refund-amount').val();
                if (!refundAmount || parseFloat(refundAmount) <= 0) {
                    alert('<?php echo e(__("messages.enter_valid_refund_amount")); ?>');
                    return;
                }
                $('#new_refund_amount').val(refundAmount);
            }
            
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: form.serialize(),
                success: function(data) {
                    if(data.success) {
                        $select.data('current-status', $('#new-status').val());
                        $('#changestatus').modal('hide');
                        Swal.fire({
                            icon: 'success',
                            title: '<?php echo e(__("messages.payment_status")); ?>',
                            text: '<?php echo e(__("messages.payment_status_updated_successfully")); ?>',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.reload();
                            }
                        });
                    }
                },
                error: function(xhr) {
                    let msg = '<?php echo e(__("messages.error_updating_payment_status")); ?>';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        msg = xhr.responseJSON.message;
                    }

                    Swal.fire({
                        icon: 'error',
                        title: '<?php echo e(__("messages.payment_status")); ?>',
                        text: msg,
                    });

                    $select.val(currentStatus);
                    $('#changestatus').modal('hide');
                }
            });
        });

        $('#changestatus').on('hidden.bs.modal', function() {
            const $select = $(this).data('select');
            const currentStatus = $(this).data('current-status');
            if ($select && currentStatus) {
                $select.val(currentStatus);
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/payment/index.blade.php ENDPATH**/ ?>