<?php $__env->startSection('content'); ?>
<main>
<section class="banner-back-img-howto">
    <div class="inner-main-img">
        <div class="container">
            <div class="inner-banner-comn">
                <h1><?php echo e(__('messages.get_a_quote')); ?></h1>
            </div>
        </div>
    </div>
</section>

<section class="detail-show-all comn-padd-100 roof-box-main">
    <div class="container">
        <div class="select-product">
            <div class="heading-select-prod">
                <h3><?php echo e(__('messages.select_the_product')); ?></h3>
                <p><?php echo e(__('messages.select_product_description')); ?></p>
            </div>
            
            <div class="cards-select-product">
                <div class="row">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 
                        <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2">
                                <div class="first-check-box">
                                    <input class="form-check-input product-radio" 
                                           type="radio" 
                                           name="product" 
                                           id="product-<?php echo e($product->id); ?>" 
                                           value="<?php echo e($product->id); ?>"
                                           <?php echo e($loop->first && $loop->parent->first ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="product-<?php echo e($product->id); ?>">
                                        <div class="inner-img-select-heading">
                                            <div class="inner-image-roof">
                                                <figure>
                                                   
                                                    <?php if($product->images->where('type', 'home')->first()): ?>
                                                        <img src="<?php echo e(asset('storage/' . $product->images->where('type', 'home')->first()->image_path)); ?>" alt="<?php echo e($product->name); ?>">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('frontend/images/placeholder.png')); ?>" alt="No image">
                                                    <?php endif; ?>
                                                </figure>
                                            </div>
                                            <h4> <?php echo e($product->name); ?></h4>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>



        

        <div id="product-details-container">
            <?php echo $__env->make('frontend.pages.product.partials.dynamic_product', [
                'product' => $firstProduct,
                'productType' => $productType,
                'manufacturers' => $manufacturers,
               
                'colors' => $colors,
                'sizes' => $sizes,
                'variations' => $variations,
                'roofTypes' => $roofTypes,
                'dailyPrices' => $dailyPrices,
                'roofRackPrices' => $roofRackPrices,
                'nonworkingDays' => $nonworkingDays,
                'holidays' => $holidays,
            
                
                
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</section>
<input type="hidden" id="selectedRecommendation">
<?php echo $__env->make('frontend.include.subscribe_news', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</main>

<div id="modal-container">
    <?php echo $__env->make('frontend.pages.product.partials.modals', ['dailyPrices' => $dailyPrices], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<script>


</script>

<script>

let user = <?php echo json_encode(auth()->user(), 15, 512) ?>;

if(user) {
    $('#title').val(user.title);
    $('#first_name').val(user.first_name);
    $('#last_name').val(user.last_name);
    $('#requestEmail').val(user.email);
    $('#country_code').val(user.country_code);
    $('#requestPhone').val(user.number);
    $('#street').val(user.street);
    $('#zipcode').val(user.zip_code);
    $('#city').val(user.city);
    $('#state').val(user.region);
}
function parseDMY(dateStr) {
    const [day, month, year] = dateStr.split('.');
    const fullYear = parseInt(year) < 100 ? 2000 + parseInt(year) : parseInt(year);
    return new Date(fullYear, parseInt(month) - 1, parseInt(day));
}

function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });


    $(document).on('click', '#okayBtn', function() {
        location.reload();
    });



var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";
$(document).ready(function() {
    let product_id = $('.product-radio').val();
    $('.product-radio').change(function() {
        const productId = $(this).val();
        product_id = productId;
        
        $.ajax({
            url: "<?php echo e(route('product.get-details')); ?>",
            method: 'GET',
            data: { product_id: productId },
            success: function(response) {
                
                window.currentSizes = response.sizes;
                window.currentVariations = response.variations;
                window.dailyPrices = response.dailyPrices;
                window.roofRackPrices = response.roofRackPrices;
                window.holidays = response.holidays;
                window.nonworkingDays = response.nonworkingDays;

               
               $('#modal-container').html(response.modalHtml); 
               $('#product-details-container').html(response.view);
               initializeProductJS(response.productType , product_id);


            },
            error: function(xhr) {
                console.error('Error loading product details');
            }
        });
    });
    initStandardProduct(product_id);
});

function initializeProductJS(productType, product_id) {
    switch(productType) {
        case 'roof_rack':
            initRoofRack(product_id);
            break;
        case 'carrier_foot':
            initCarrierFoot(product_id);
            break;
        default:
            initStandardProduct(product_id);
    }
}

function saveFormDataAndRedirect(redirectUrl) {

    let rentalFromStr = $('#rental_from').val();
    let rentalToStr = $('#rental_to').val();
    let selectedRecommendation = $('#selectedRecommendation').val();
    selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;

    console.log(selectedRecommendation)

   
    let rentalFrom = parseDMY(rentalFromStr);
    let rentalTo = parseDMY(rentalToStr);

    let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
    let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;

    let formData = {
        product_id: $('#product_id').val(),
        product_name: $('#product_name').val(),
        manufacturer: $('#manufacturer').val(),
        car_year: $('#year').val(),
        model: $('#model').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: selectedRecommendation?.rooftype_ger || '',
        carrier_length: selectedRecommendation?.carrier_length || '',
        foot_sku: selectedRecommendation?.foot_sku || '',
        footkit_sku: selectedRecommendation?.footkit_sku || '',
        bundle_name: selectedRecommendation?.bundle_name || '',
        color_id: $('#color-select').val(),
        color_name: $('#color-select option:selected').data('color-name'),
        size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
        size_name: $('.inner-size-card.selected').data('size-name'),
        booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
        booking_item_ids: $('#booking_item_ids').val() || '',

        rental_from: $('#rental_from').val(),
        rental_to: $('#rental_to').val(),
        days: days,
        calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
        is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
        is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
        vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
    };
  
    formData._token = $('meta[name="csrf-token"]').attr('content');


    $.post(`${baseUrl}/store-rental-form`, formData, function() {
        window.location.href = redirectUrl; 
    });
}


function saveFormDataAndRedirectRoofRack(redirectUrl) {

let rentalFromStr = $('#rental_from').val();
let rentalToStr = $('#rental_to').val();
let selectedRecommendation = $('#selectedRecommendation').val();
selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;


let rentalFrom = parseDMY(rentalFromStr);
let rentalTo = parseDMY(rentalToStr);

let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
let formData = {
    product_id: $('#product_id').val(),
    product_name: $('#product_name').val(),
    manufacturer: $('#manufacturer').val(),
    car_year: $('#year').val(),
    model: $('#model').val(),
    trailer_hitch: $('#trailer_hitch').val(),
    roof_type: selectedRecommendation?.rooftype_ger || '',
    carrier_length: selectedRecommendation?.carrier_length || '',
    foot_sku: selectedRecommendation?.foot_sku || '',
    footkit_sku: selectedRecommendation?.footkit_sku || '',
    bundle_name: selectedRecommendation?.bundle_name || '',
    booking_item_ids: $('#booking_item_ids').val() || '',

    rental_from: $('#rental_from').val(),
    rental_to: $('#rental_to').val(),
    days: days,
    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
};
formData._token = $('meta[name="csrf-token"]').attr('content');


$.post(`${baseUrl}/store-rental-form`, formData, function() {
    window.location.href = redirectUrl; 
});
}


function saveFormDataAndRedirectCarrier(redirectUrl) {

let rentalFromStr = $('#rental_from').val();
let rentalToStr = $('#rental_to').val();
let selectedRecommendation = $('#selectedRecommendation').val();
selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;


let rentalFrom = parseDMY(rentalFromStr);
let rentalTo = parseDMY(rentalToStr);

let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
let formData = {
    product_id: $('#product_id').val(),
    product_name: $('#product_name').val(),
    manufacturer: $('#manufacturer').val(),
    car_year: $('#year').val(),
    model: $('#model').val(),
    trailer_hitch: $('#trailer_hitch').val(),
    roof_type: selectedRecommendation?.rooftype_ger || '',
    carrier_length: selectedRecommendation?.carrier_length || '',
    foot_sku: selectedRecommendation?.foot_sku || '',
    footkit_sku: selectedRecommendation?.footkit_sku || '',
    bundle_name: selectedRecommendation?.bundle_name || '',
    color_id: $('#color-select').val(),
    color_name: $('#color-select option:selected').data('color-name'),
    size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
    size_name: $('.inner-size-card.selected').data('size-name'),
    booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
    booking_item_ids: $('#booking_item_ids').val() || '',

    rental_from: $('#rental_from').val(),
    rental_to: $('#rental_to').val(),
    days: days,
    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
    is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
};
formData._token = $('meta[name="csrf-token"]').attr('content');


$.post(`${baseUrl}/store-rental-form`, formData, function() {
    window.location.href = redirectUrl; 
});
}


    function toggleRentButtonStandard(isAvailable) {
        if (isAvailable) {
            $('#rentNowButton').removeClass('d-none');
            $('#requestButton').addClass('d-none');
        } else {
            $('#rentNowButton').addClass('d-none');
            $('#requestButton').removeClass('d-none');
        }
    }

    function populateRequestFormStandard() {

        let selectedRecommendation = $('#selectedRecommendation').val();
        selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;


        console.log(selectedRecommendation)
        // Get all relevant product information
        const productId = $('#product_id').val();
        const productName = $('#product_name').val();
        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        const selectedSize = $('.inner-size-card.selected');
        const sizeId = selectedSize.data('size-id');
        const sizeName = selectedSize.data('size-name');
        const variationId = selectedSize.data('variation-id');
        const variationName = selectedSize.data('variation-name') || sizeName;
        const rentalFrom = $('#rental_from').val();
        const rentalTo = $('#rental_to').val();
        const manufacturer = $('#manufacturer').val();
        const model = $('#model').val();
        const year = $('#year').val();
        const trailerHitch = $('#trailer_hitch').val();
        const roofType = selectedRecommendation ? selectedRecommendation.rooftype_ger : '';
        
        // Set hidden field values
        $('#requestProductId').val(productId);
        $('#requestProductName').val(productName);
        $('#requestColorId').val(colorId);
        $('#requestColorName').val(colorName);
        $('#requestSizeId').val(sizeId);
        $('#requestSizeName').val(sizeName);
        $('#requestVariationId').val(variationId);
        $('#requestVariationName').val(variationName);
        $('#requestRentalFrom').val(rentalFrom);
        $('#requestRentalTo').val(rentalTo);
        $('#requestCarrierLength').val(selectedRecommendation ? selectedRecommendation.carrier_length : '');
        $('#requestFootSku').val(selectedRecommendation ? selectedRecommendation.foot_sku : '');
        $('#requestFootkitSku').val(selectedRecommendation ? selectedRecommendation.footkit_sku : '');
        $('#requestRoofType').val(roofType);
        
        // Build product details display
       

        let detailsHtml = `
            <p><strong><?php echo e(__('messages.product')); ?>:</strong> ${productName}</p>
            <p><strong><?php echo e(__('messages.color')); ?>:</strong> ${colorName}</p>
            <p><strong><?php echo e(__('messages.size_or_variant')); ?>:</strong> ${sizeName || variationName}</p>
            <p><strong><?php echo e(__('messages.rental_period')); ?>:</strong> ${rentalFrom} <?php echo e(__('messages.to')); ?> ${rentalTo}</p>
        `;
        
        if (manufacturer) {
            detailsHtml += `<p><strong><?php echo e(__('messages.vehicle')); ?>:</strong> ${manufacturer} ${model} (${year})</p>`;
        }
        
         if (trailerHitch) {
            detailsHtml += `<p><strong><?php echo e(__('messages.trailer_hitch')); ?>:</strong> 
                ${trailerHitch == 'yes' ? "<?php echo e(__('messages.yes')); ?>" : "<?php echo e(__('messages.no')); ?>"}
            </p>`;
        }
        
 if (roofType) {
            detailsHtml += `<p><strong><?php echo e(__('messages.roof_type')); ?>: </strong>${roofType}</p>`;
        }
        
        // Add unavailable components if any
      if (window.unavailableComponents && window.unavailableComponents.length > 0) {
           const unique = [...new Set(window.unavailableComponents)];

            const capitalized = unique.map(
                item => item.charAt(0).toUpperCase() + item.slice(1)
            );

            detailsHtml += `<p><strong><?php echo e(__('messages.unavailable_components')); ?>:</strong> ${capitalized.join(', ')}</p>`;
            $('#requestUnavailableComponents').val(capitalized.join(', '));
        }
        
        $('#requestProductDetails').html(detailsHtml);
    }




function initStandardProduct(product_id) {

    let selectedRecommendation = null;
    let carrier_length = null;
    let foot_sku = null;
    let footkit_sku = null;
    let notAvailable = 1;
    window.unavailableComponents = [];
    let availabilityRoofBox = null;


    $(document).on('click', '.clickable-roof', function () {
        $('.clickable-roof').removeClass('selected');
        $(this).addClass('selected');

        const slug = $(this).data('rooftype-slug');
        selectedRecommendation = window.currentRecommendationMap[slug];
       
        $('#selectedRecommendation').val(JSON.stringify(selectedRecommendation));

        carrier_length = selectedRecommendation.carrier_length;
        foot_sku = selectedRecommendation.foot_sku;
        footkit_sku = selectedRecommendation.footkit_sku;

        $('#roof-types-container .invalid-feedback').remove();
    });

    let bookingData = {};
    $(document).ready(function() {
            $.get(`${baseUrl}/userCarDetail`, function(data) {
                if (data) {

                    bookingData = data.data;
                    if (bookingData && Object.keys(bookingData).length > 0) {
                        console.log(bookingData)
                        fillBookingData(bookingData);
                    }
                    
                    
                }

        });
        const waitForOption = (selector, value) => {
            return new Promise(resolve => {
                const interval = setInterval(() => {
                    const $option = $(`${selector} option`).filter(function () {
                        return $(this).val().trim() === value.trim();
                    });
                    if ($option.length) {
                        console.log($option.val(),selector)

                        $(selector).val($option.val()).trigger('change');
                        clearInterval(interval);
                        resolve();
                    }
                }, 200);
            });
        };

        async function fillBookingData(data) {
            if (data.manufacturer) {
                await waitForOption("#manufacturer", data.manufacturer);
            }
            
            if (data.car_model) {
                await waitForOption("#model", data.car_model);
            }
            if (data.car_year) {
                await waitForOption("#year", data.car_year);
            }
            if (data) {
            if(data.trailer_hitch == 1){
                data.trailer_hitch = 'yes';
            }else{
                data.trailer_hitch = 'no'
            }
            await waitForOption("#trailer_hitch", data.trailer_hitch.toLowerCase());
        }
        }

        $('#manufacturer').change(function() {
            $('#model').prop('disabled', true).html('<option>Loading...</option>');
            $('#year').prop('disabled', true).html('<option><?php echo e(__('messages.select')); ?></option>');
            
            let manufacturer = $(this).val();

            $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
                $('#model').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(model => {
                    $('#model').append(`<option value="${model}">${model}</option>`);
                });
            });
        });

        $('#model').change(function() {
            $('#year').prop('disabled', true).html('<option>Loading...</option>');
            
            let manufacturer = $('#manufacturer').val();
            let model = $(this).val();

            $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
                $('#year').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(year => {
                    $('#year').append(`<option value="${year}">${year}</option>`);
                });
            });
        });
    });



    




    function checkAvailability(colorId,colorName) {
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    const vendor_id = $('#vendor_select').val();
    
    const params = {
        color_id: colorId,
        from_date: fromDate,
        to_date: toDate,
        color_name: colorName,
        vendor_id: vendor_id,
        carrier_length : carrier_length,
        foot_sku : foot_sku,
        footkit_sku : footkit_sku
        
        };

    if(!fromDate || !toDate ||  !colorId || !vendor_id){
        return; 
    }
    
    $.get(`${baseUrl}/product/${product_id}/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            // const isAvailable = availability[sizeId] > 0;
            const sizeData = availability[sizeId] || { available_units: 0, booking_item_ids: [] };
            const isAvailable = availability[sizeId].available_units > 0;
            if (isAvailable && sizeData.booking_item_ids.length > 0) {
                $card.attr(
                    'data-booking-item-ids',
                    sizeData.booking_item_ids && sizeData.booking_item_ids.length > 0
                        ? sizeData.booking_item_ids[0] // only the first ID
                        : ''
                );
            } else {
                $card.removeAttr('data-booking-item-ids');
            }

            availabilityRoofBox = availability;
            
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });

        if($('#roof_rack_checkbox').is(':checked')){
        const bookingItemIds = {};
        
        if (availability.roof_rack.carrier && availability.roof_rack.carrier.booking_item_ids.length > 0) {
            bookingItemIds.carrier = availability.roof_rack.carrier.booking_item_ids[0];
        }
        
        if (availability.roof_rack.foot && availability.roof_rack.foot.booking_item_ids.length > 0) {
            bookingItemIds.foot = availability.roof_rack.foot.booking_item_ids[0];
        }
        
        if (availability.roof_rack.footkit && availability.roof_rack.footkit.booking_item_ids.length > 0) {
            bookingItemIds.footkit = availability.roof_rack.footkit.booking_item_ids[0];
        }
        
        window.bookingItemIds = JSON.stringify(bookingItemIds);
        
        
        const isCarrierAvailable = availability.roof_rack.carrier && availability.roof_rack.carrier.available_units > 0;
        const isFootAvailable = availability.roof_rack.foot && availability.roof_rack.foot.available_units > 0;
        const isFootkitAvailable = availability.roof_rack.footkit && availability.roof_rack.footkit.available_units > 0;

        console.log(availability.roof_rack)
        notAvailable = isCarrierAvailable && isFootAvailable && isFootkitAvailable;

        $('#booking_item_ids').val(window.bookingItemIds);
        if (!notAvailable) {
            let errorMessage = '';
            const unavailableComponents = [];
            
            // if (!isCarrierAvailable) unavailableComponents.push('carrier');
            // if (!isFootAvailable) unavailableComponents.push('foot');
            // if (!isFootkitAvailable) unavailableComponents.push('footkit');


            // if (!isCarrierAvailable) window.unavailableComponents.push('carrier');
            // if (!isFootAvailable) window.unavailableComponents.push('foot');
            // if (!isFootkitAvailable) window.unavailableComponents.push('footkit');


            if (!isCarrierAvailable) window.unavailableComponents.push('traverse');
            if (!isFootAvailable) window.unavailableComponents.push('fuß');
            if (!isFootkitAvailable) window.unavailableComponents.push('fußkit');


            if (!isCarrierAvailable) unavailableComponents.push('traverse');
            if (!isFootAvailable) unavailableComponents.push('fuß');
            if (!isFootkitAvailable) unavailableComponents.push('fußkit');
            
            const formattedComponents = unavailableComponents.map(item => {
                return item.charAt(0).toUpperCase() + item.slice(1);
            });

            errorMessage += formattedComponents.join(', ');
            
            $('#errorMessage').html(`
                
                <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.size_unavailable_message', ['errorMessage' => '${errorMessage}'])); ?>

                </div>
            `);

            toggleRentButtonStandard(notAvailable);
        } else {
            $('#errorMessage').empty();
        }
}
        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
    });
    }

    $('#roof_rack_checkbox').on('change', function () {
if($('#roof_rack_checkbox').is(':checked')){
        const bookingItemIds = {};
        
        if (availabilityRoofBox.roof_rack.carrier && availabilityRoofBox.roof_rack.carrier.booking_item_ids.length > 0) {
            bookingItemIds.carrier = availabilityRoofBox.roof_rack.carrier.booking_item_ids[0];
        }
        
        if (availabilityRoofBox.roof_rack.foot && availabilityRoofBox.roof_rack.foot.booking_item_ids.length > 0) {
            bookingItemIds.foot = availabilityRoofBox.roof_rack.foot.booking_item_ids[0];
        }
        
        if (availabilityRoofBox.roof_rack.footkit && availabilityRoofBox.roof_rack.footkit.booking_item_ids.length > 0) {
            bookingItemIds.footkit = availabilityRoofBox.roof_rack.footkit.booking_item_ids[0];
        }
        
        window.bookingItemIds = JSON.stringify(bookingItemIds);
        
        
        const isCarrierAvailable = availabilityRoofBox.roof_rack.carrier && availabilityRoofBox.roof_rack.carrier.available_units > 0;
        const isFootAvailable = availabilityRoofBox.roof_rack.foot && availabilityRoofBox.roof_rack.foot.available_units > 0;
        const isFootkitAvailable = availabilityRoofBox.roof_rack.footkit && availabilityRoofBox.roof_rack.footkit.available_units > 0;

        console.log(availabilityRoofBox.roof_rack)
        notAvailable = isCarrierAvailable && isFootAvailable && isFootkitAvailable;

        $('#booking_item_ids').val(window.bookingItemIds);
        if (!notAvailable) {
            let errorMessage = '';
            const unavailableComponents = [];

           
            
            // if (!isCarrierAvailable) unavailableComponents.push('carrier');
            // if (!isFootAvailable) unavailableComponents.push('foot');
            // if (!isFootkitAvailable) unavailableComponents.push('footkit');

            
            // if (!isCarrierAvailable) window.unavailableComponents.push('carrier');
            // if (!isFootAvailable) window.unavailableComponents.push('foot');
            // if (!isFootkitAvailable) window.unavailableComponents.push('footkit');

            if (!isCarrierAvailable) window.unavailableComponents.push('traverse');
            if (!isFootAvailable) window.unavailableComponents.push('fuß');
            if (!isFootkitAvailable) window.unavailableComponents.push('fußkit');


            if (!isCarrierAvailable) unavailableComponents.push('traverse');
            if (!isFootAvailable) unavailableComponents.push('fuß');
            if (!isFootkitAvailable) unavailableComponents.push('fußkit');
            
            const formattedComponents = unavailableComponents.map(item => {
                return item.charAt(0).toUpperCase() + item.slice(1);
            });

            errorMessage += formattedComponents.join(', ');
            
            $('#errorMessage').html(`
                
                <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.size_unavailable_message', ['errorMessage' => '${errorMessage}'])); ?>

                </div>
            `);

            toggleRentButtonStandard(notAvailable);
        } else {
            $('#errorMessage').empty();
        }
}else {
        notAvailable = 1; // not available when unchecked
        window.unavailableComponents = window.unavailableComponents.filter(
            item => !['carrier', 'foot', 'footkit','traverse','fuß','fußkit'].includes(item)
        );
    }
});



    $('#vendor_select').on('change',function(){
        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        if (colorId && colorId !== 'Select' && fromDate && toDate) {
            checkAvailability(colorId,colorName);
        }
    })

    $('#rental_from, #rental_to').on('change', function() {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        console.log(colorId)
        if (colorId && colorId !== 'Select') {
            checkAvailability(colorId,colorName);
        }
    });

    $('#color-select').on('change', function() {
        const colorId = $(this).val();
        const colorName = $('#color-select option:selected').data('color-name');
        console.log(colorName)
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        $('#errorMessage').empty();
        if (colorId && colorId !== 'Select' && fromDate && toDate) {
            checkAvailability(colorId,colorName);
        }
    });






    function highlightRecommendedSizes(recommendation) {
            $('.inner-size-card').removeClass('recommended-size');
            $('.recommended').addClass('d-none')
        recommendation.forEach(item => {
            const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
            $card.addClass('recommended-size');
            console.log(item)
            $card.find('.recommended').removeClass('d-none');
                $card.find('.recommended').text('EMPFOHLEN');
        });
    }
    var railing_type = $('#railing_type').val();
        $('#year, #trailer_hitch').change(function() {
            let manufacturer = $('#manufacturer').val();
            let year = $('#year').val();
            let model = $('#model').val();
            let trailer_hitch = $('#trailer_hitch').val();


            const productName = $('#trailer_hitch').data('product-name');
            const selectedValue = $('#trailer_hitch').val();
            const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
            if (selectedValue === 'no' && hitchRequired) {
                $('#trailer_hitch').val('');

                const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
                modal.show();
                return ;
            }


            if (manufacturer && year && model && trailer_hitch) {
                $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
                    window.currentRecommendation = data;
                    window.currentRecommendationMap = {};

                    if (data.length === 0) {
                        $('#result').html('<p><?php echo e(__('messages.no_recommendations_found')); ?></p>');
                        return;
                    }

                    $('.roof-name-detail').hide();
                    $('#roof-types-container').show();

                    

                    data.forEach((item, index) => {
                        const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

                    
                        if(railing_type){
                        $(`#roof-type-${roofTypeSlug}`).show();

                        window.currentRecommendationMap[roofTypeSlug] = item;
                        $(`#roof-type-${roofTypeSlug}`)
                            .addClass('clickable-roof')
                            .attr('data-rooftype-slug', roofTypeSlug);
                        }
                    });

                   
                    highlightRecommendedSizes(data);
                });
            }
        });




    $(document).on('click', '.inner-size-card', function () {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select').find('option:selected').data('color-name');
        if (!colorName) {
            $('#errorMessage').html(`
                <div class="text-danger mt-2">
                     <?php echo e(__('messages.select_color_first')); ?>

                </div>
            `);
            return;
        }


        const $card = $(this);
        const isAvailable = $card.hasClass('available');
        const isUnavailable = $card.hasClass('unavailable');
        var size = $card.data('size-name');

        $('.inner-size-card').removeClass('selected');
        $('#errorMessage').empty();

        $card.addClass('selected');

        if (isUnavailable || !notAvailable) {
            const message = `
            <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.product_not_available_message')); ?>

            </div>
            `;
            if(isUnavailable){
                if (!window.unavailableComponents.includes(size)) {
                    window.unavailableComponents.push(size);
                }
            }
            $('#errorMessage').html(message);
            toggleRentButtonStandard(false);
        }else{
            toggleRentButtonStandard(true);
        }
    });

    $('.roof-name-detail').hide();
    $('#roof-types-container').hide();

    const dailyPrices = window.dailyPrices || <?php echo json_encode($dailyPrices, 15, 512) ?>;
    const roofRackPrices = window.roofRackPrices || <?php echo json_encode($roofRackPrices, 15, 512) ?>; 
    console.log(roofRackPrices, dailyPrices);
    const insuranceFlatFee = 25.00;

    function calculateRent() {


        const from = parseDMY($('#rental_from').val());
        const to = parseDMY($('#rental_to').val());

        if (isNaN(from) || isNaN(to) || to < from) return;

        const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

        let totalRent = 0;

        for (let i = 0; i < days && i < dailyPrices.length; i++) {
            totalRent += dailyPrices[i];

            if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                console.log('totalRent', totalRent)
                totalRent += roofRackPrices[i];
            }
        }

        if ($('#insurance_checkbox').is(':checked')) {
            totalRent += insuranceFlatFee;
            $('#withinsurance').removeClass('d-none');
            $('#withoutinsurance').addClass('d-none');
        }else{
            $('#withoutinsurance').removeClass('d-none');
            $('#withinsurance').addClass('d-none');
        }

        $('.inner-number-days span:first').text(days);
        $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
    }

    $('#rental_from, #rental_to').on('change', calculateRent);



    $('#insurance_checkbox').on('change', function () {
        $('#insurance_selected').val(this.checked ? 1 : 0);
    });

    $('#roof_rack_checkbox').on('change', function () {
        $('#roof_rack_selected').val(this.checked ? 1 : 0);
    });



    $(document).ready(function() {
        $('#roof_rack_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#insurance_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#rentCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', true).trigger('change');
            $('#notCarrier').modal('hide');
        });

        $('#bringOwnCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', false);
            $('#notCarrier').modal('hide');
            calculateRent(); 
        });

        $('#wantInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', true).trigger('change');
            $('#notInsurance').modal('hide');
        });

        $('#noInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', false);
            $('#notInsurance').modal('hide');
            calculateRent(); 
        });
    function validateForm() {
        let isValid = true;

        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), "<?php echo e(__('messages.enter_manufacturer')); ?>");
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), "<?php echo e(__('messages.enter_year')); ?>");
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), "<?php echo e(__('messages.enter_model')); ?>");
            isValid = false;
        }
        
        const productName = $('#trailer_hitch').data('product-name');
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
        if (hitchRequired && !$('#trailer_hitch').val()) {
            showError($('#trailer_hitch'), "<?php echo e(__('messages.select_trailer_hitch')); ?>");
            isValid = false;
        }
        
        // Color validation
        if (!$('#color-select').val()) {
            showError($('#color-select'), '<?php echo e(__("messages.enter_color")); ?>');
            isValid = false;
        }
        
        // Size validation
        if (!$('.inner-size-card.selected').length) {
            $('#size-container').after('<div class="invalid-feedback d-block"><?php echo e(__('messages.enter_size')); ?></div>');
            isValid = false;
        }
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), "<?php echo e(__('messages.enter_start_date')); ?>");
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), "<?php echo e(__('messages.enter_end_date')); ?>");
            isValid = false;
        } 
        
        if ($('#rental_from').val() && $('#rental_to').val()) {

            // const from = new Date($('#rental_from').val());
            // const to = new Date($('#rental_to').val());

            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());
            if (to < from) {
                showError($('#rental_to'), "<?php echo e(__('messages.end_date_after_start')); ?>");

                isValid = false;
            }
        }
        if($('#errorMessage').text()){
                isValid = false;
            }
        
        return isValid;
    }

    function showError(element, message) {
        element.addClass('is-invalid');
        if (element.is('select')) {
            element.parent().append(`<div class="invalid-feedback">${message}</div>`);
        } else {
            element.after(`<div class="invalid-feedback">${message}</div>`);
        }
    }

    $('#manufacturer, #year, #model, #trailer_hitch, #color-select, #rental_from, #rental_to').on('input change', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.invalid-feedback').remove();
        $(this).parent().find('.invalid-feedback').remove();
    });
    $('.inner-size-card').on('click', function() {
        $('.invalid-feedback.d-block').remove();
    });

    $('#requestButton').click(function() {
        populateRequestFormStandard();
    });

    $('#submitRequest').click(function() {
        const $btn = $(this); // reference to the button

        $btn.prop('disabled', true).text('Submitting...');
        let isValid = true;
        $('#requestForm .is-invalid').removeClass('is-invalid');

        function showError(id) {
            $(`#${id}`).addClass('is-invalid');
            isValid = false;
        }
    const formData = {
        title : $('#title').val(),
        first_name : $('#first_name').val(),
        last_name : $('#last_name').val(),
        street : $('#street').val(),
        zipcode : $('#zipcode').val(),
        city : $('#city').val(),
        state : $('#state').val(),
        country_code :$('#country_code').val(),
        phone: $('#requestPhone').val(),
        message: $('#requestMessage').val(),
        email: $('#requestEmail').val(),
        message: $('#requestMessage').val(),
        product_id: $('#requestProductId').val(),
        product_name: $('#requestProductName').val(),
        color_id: $('#requestColorId').val(),
        color_name: $('#requestColorName').val(),
        size_id: $('#requestSizeId').val(),
        size_name: $('#requestSizeName').val(),
        variation_id: $('#requestVariationId').val(),
        variation_name: $('#requestVariationName').val(),
        rental_from: $('#requestRentalFrom').val(),
        rental_to: $('#requestRentalTo').val(),
        manufacturer: $('#manufacturer').val(),
        car_model: $('#model').val(),
        car_year: $('#year').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: $('#requestRoofType').val(),
        carrier_length: $('#requestCarrierLength').val(),
        foot_sku: $('#requestFootSku').val(),
        footkit_sku: $('#requestFootkitSku').val(),
        unavailable_components: $('#requestUnavailableComponents').val(),
        pickup_location : $('#vendor_select option:selected').text(),
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    if (!formData.title) showError('title');
        if (!formData.first_name) showError('first_name');
        if (!formData.last_name) showError('last_name');
        if (!formData.email) showError('requestEmail');
        if (!formData.phone) showError('requestPhone');
        if (!formData.street) showError('street');
        if (!formData.zipcode) showError('zipcode');
        if (!formData.city) showError('city');
        if (!formData.state) showError('state');
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (formData.email && !emailPattern.test(formData.email)) showError('requestEmail');
        if (!isValid) {
            $btn.prop('disabled', false).text('Submit');
            return;
        }
    
    $.post(`${baseUrl}/product/request`, formData, function(response) {
        if (response.success) {
            $('#requestModal').modal('hide');
            
            $('#requestForm')[0].reset();
            $('#requestSuccessful').modal('show');
        } else {
            alert('There was an error submitting your request. Please try again.');
        }
    }).fail(function() {
        alert('There was an error submitting your request. Please try again.');
    }).always(function() {
        $btn.prop('disabled', false).text('Submit');
    });
});

    $('#bookingForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        <?php if(auth()->guard()->check()): ?>
        if (validateForm()) {
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_ger || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            showError($(`#${field}`), errors[field][0]);
                        }
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        }
        <?php else: ?>
            if(validateForm()){
                e.preventDefault();
                $('#guestOptionsModal').modal('show');

            }
        <?php endif; ?>
    });

    $('#continueAsGuest').click(function() {
        const name = $('#firstname').val().trim();
        const surname = $('#surname').val().trim();
        const email = $('#firstemail').val().trim();
        const number = $('#number').val();

      let isValid = true;

      $('#name, #surname, #email').removeClass('is-invalid');

      if (name === '') {
        $('#firstname').addClass('is-invalid');
        isValid = false;
      }

      
      if (surname === '') {
        $('#surname').addClass('is-invalid');
        isValid = false;
      }

      if(number === ''){
        $('#number').addClass('is-invalid');
        isValid = false;
      }

      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === '' || !emailPattern.test(email)) {
        $('#firstemail').addClass('is-invalid');
        isValid = false;
      }

      if (isValid) {
      
        // $('#guestModal').modal('hide');

      }
        // $('#guestModal').modal('hide');
        let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
        let formData = {
                is_guest: 1,
                name: $('#firstname').val(),
                surname: $('#surname').val(),
                email: $('#firstemail').val(),
                number : $('#number').val(),
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_ger || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };
        $.ajax({
            url: "<?php echo e(route('cart.add')); ?>",
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.status ==  false){
                    $('#guestError')
                .removeClass('d-none')
                .text(response.message || 'Something went wrong. Please try again.');
                }else{
                    $('#guestModal').modal('hide');
                    $('#guestError').addClass('d-none');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                }
             
                // window.location.href = '<?php echo e(route("cart.guest_time-selection")); ?>';
            }
        });
    });
});


$(function () {
     $.datepicker.regional['de'] = {
            closeText: 'Schließen',
            prevText: 'Zurück',
            nextText: 'Weiter',
            currentText: 'Heute',
            monthNames: ['Januar','Februar','März','April','Mai','Juni',
                'Juli','August','September','Oktober','November','Dezember'],
            monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
                'Jul','Aug','Sep','Okt','Nov','Dez'],
            dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
            dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            weekHeader: 'KW',
            dateFormat: 'dd.mm.yy',
            firstDay: 1,
            isRTL: false,
        };
        $.datepicker.setDefaults($.datepicker.regional['de']);
                let holidaysRaw = <?php echo json_encode($holidays, 15, 512) ?>;
        let holidays = Array.isArray(holidaysRaw) ? holidaysRaw : Object.values(holidaysRaw);        console.log(holidays);
        let nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        let dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

        let closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            let day = date.getDay();
            let formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            let isWeekend = closedDays.includes(day);
            let isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        function initDatePickers() {
            $("#rental_from, #rental_to").datepicker("destroy"); // reset old pickers

            $("#rental_from").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    const productName = $('#trailer_hitch').data('product-name');
                    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
                    if (!selectedRecommendation && !hitchRequired) {
                            const modal = new bootstrap.Modal(document.getElementById('railingType'));
                            modal.show();
                       
                        $(this).val(''); 
                        return ;
                    } 
                    const startDate = $(this).datepicker('getDate');
                    $("#rental_to").datepicker("option", "minDate", startDate);

                    let colorId = $('#color-select').val();
                    let colorName = $('#color-select option:selected').data('color-name');
                    if (colorId && colorId !== 'Select') {
                        checkAvailability(colorId, colorName);
                    }
                    calculateRent();
                }
            });

            $("#rental_to").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    let colorId = $('#color-select').val();
                    let colorName = $('#color-select option:selected').data('color-name');
                    if (colorId && colorId !== 'Select') {
                        checkAvailability(colorId, colorName);
                    }
                    calculateRent();
                }
            });
        }

    
        initDatePickers();

   
   


        $('#vendor_select').on('change', function () {


            let vendorId = $(this).val();
            $.ajax({
                url: "<?php echo e(route('vendor.calendar.data')); ?>",
                type: 'GET',
                data: { vendor_id: vendorId },
                success: function (response) {
                    holidays = response.holidays;
                    nonworkingDays = response.nonworkingDays;
                    closedDays = nonworkingDays.map(day => dayMap[day]);
                    initDatePickers();
                }
            });
        });
    });
}

function toggleRentButtonRoofRack(isAvailable) {
        if (isAvailable) {
            $('#rentNowButton').removeClass('d-none');
            $('#requestButton').addClass('d-none');
        } else {
            $('#rentNowButton').addClass('d-none');
            $('#requestButton').removeClass('d-none');
        }
    }

    function populateRequestFormRoofRack() {
        let selectedRecommendation = $('#selectedRecommendation').val();

        selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;

        // Get all relevant product information
        const productId = $('#product_id').val();
        const productName = $('#product_name').val();
       
        const rentalFrom = $('#rental_from').val();
        const rentalTo = $('#rental_to').val();
        const manufacturer = $('#manufacturer').val();
        const model = $('#model').val();
        const year = $('#year').val();
        const trailerHitch = $('#trailer_hitch').val();
        const roofType = selectedRecommendation ? selectedRecommendation.rooftype_ger : '';
        
        // Set hidden field values
        $('#requestProductId').val(productId);
        $('#requestProductName').val(productName);
      
        $('#requestRentalFrom').val(rentalFrom);
        $('#requestRentalTo').val(rentalTo);
        $('#requestCarrierLength').val(selectedRecommendation ? selectedRecommendation.carrier_length : '');
        $('#requestFootSku').val(selectedRecommendation ? selectedRecommendation.foot_sku : '');
        $('#requestFootkitSku').val(selectedRecommendation ? selectedRecommendation.footkit_sku : '');
        $('#requestRoofType').val(roofType);
        
        // Build product details display
      

        let detailsHtml = `
            <p><strong><?php echo e(__('messages.product')); ?>:</strong> ${productName}</p>
            <p><strong><?php echo e(__('messages.rental_period')); ?>:</strong> ${rentalFrom} <?php echo e(__('messages.to')); ?> ${rentalTo}</p>
        `;
        
        if (manufacturer) {
            detailsHtml += `<p><strong><?php echo e(__('messages.vehicle')); ?>:</strong> ${manufacturer} ${model} (${year})</p>`;
        }
        
        if (trailerHitch) {
            detailsHtml += `<p><strong><?php echo e(__('messages.trailer_hitch')); ?>:</strong> 
                ${trailerHitch == 'yes' ? "<?php echo e(__('messages.yes')); ?>" : "<?php echo e(__('messages.no')); ?>"}
            </p>`;
        }
        
 if (roofType) {
            detailsHtml += `<p><strong><?php echo e(__('messages.roof_type')); ?>: </strong>${roofType}</p>`;
        }
        
        // Add unavailable components if any
      if (window.unavailableComponents && window.unavailableComponents.length > 0) {
            const unique = [...new Set(window.unavailableComponents)];

            const capitalized = unique.map(
                item => item.charAt(0).toUpperCase() + item.slice(1)
            );

            detailsHtml += `<p><strong><?php echo e(__('messages.unavailable_components')); ?>:</strong> ${capitalized.join(', ')}</p>`;
            $('#requestUnavailableComponents').val(capitalized.join(', '));
        }
        
        $('#requestProductDetails').html(detailsHtml);
    }




function initRoofRack(product_id){
    let carrier_length = null;
    let foot_sku = null;
    let footkit_sku = null;
    let notAvailable = 1;

    window.unavailableComponents = [];


    let bookingData = {};
    $(document).ready(function() {
            $.get(`${baseUrl}/userCarDetail`, function(data) {
                if (data) {

                    bookingData = data.data;
                    if (bookingData && Object.keys(bookingData).length > 0) {
                        console.log(bookingData)
                        fillBookingData(bookingData);
                    }
                    
                    
                }

        });
        const waitForOption = (selector, value) => {
            return new Promise(resolve => {
                const interval = setInterval(() => {
                    const $option = $(`${selector} option`).filter(function () {
                        return $(this).val().trim() === value.trim();
                    });
                    if ($option.length) {
                        console.log($option.val(),selector)

                        $(selector).val($option.val()).trigger('change');
                        clearInterval(interval);
                        resolve();
                    }
                }, 200);
            });
        };

        async function fillBookingData(data) {
            if (data.manufacturer) {
                await waitForOption("#manufacturer", data.manufacturer);
            }
            
            if (data.car_model) {
                await waitForOption("#model", data.car_model);
            }
            if (data.car_year) {
                await waitForOption("#year", data.car_year);
            }
            if (data) {
            if(data.trailer_hitch == 1){
                data.trailer_hitch = 'yes';
            }else{
                data.trailer_hitch = 'no'
            }
            await waitForOption("#trailer_hitch", data.trailer_hitch.toLowerCase());
        }
        }

        $('#manufacturer').change(function() {
            $('#model').prop('disabled', true).html('<option>Loading...</option>');
            $('#year').prop('disabled', true).html('<option><?php echo e(__('messages.select')); ?></option>');
            
            let manufacturer = $(this).val();

            $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
                $('#model').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(model => {
                    $('#model').append(`<option value="${model}">${model}</option>`);
                });
            });
        });

        $('#model').change(function() {
            $('#year').prop('disabled', true).html('<option>Loading...</option>');
            
            let manufacturer = $('#manufacturer').val();
            let model = $(this).val();

            $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
                $('#year').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(year => {
                    $('#year').append(`<option value="${year}">${year}</option>`);
                });
            });
        });
    });



    function checkAvailabilityRoofRack() {
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        const vendor_id = $('#vendor_select').val();

    
        
        const params = {
            from_date: fromDate,
            to_date: toDate,
            vendor_id : vendor_id,
            carrier_length : carrier_length,
            foot_sku : foot_sku,
            footkit_sku : footkit_sku

        };

        if(!fromDate || !toDate || !vendor_id){
            return; 
        }
        
        $.get(`${baseUrl}/product/${product_id}/roofRack/availability`, params, function(availability) {
            $('.inner-size-card').each(function() {
                const $card = $(this);
                const sizeName = $card.data('size-name');
                const sizeId = $card.data('size-id') || $card.data('variation-id');
                const isAvailable = availability[sizeId] > 0;
                
                $card.toggleClass('available', isAvailable)
                    .toggleClass('unavailable', !isAvailable);
                    
                const $badge = $card.find('.badge');
                $badge.removeClass('bg-secondary bg-success bg-danger')
                    .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                    .text(isAvailable ? '' : 'Unavailable');
            });
            const bookingItemIds = {};
        
        if (availability.carrier && availability.carrier.booking_item_ids.length > 0) {
            bookingItemIds.carrier = availability.carrier.booking_item_ids[0];
        }
        
        if (availability.foot && availability.foot.booking_item_ids.length > 0) {
            bookingItemIds.foot = availability.foot.booking_item_ids[0];
        }
        
        if (availability.footkit && availability.footkit.booking_item_ids.length > 0) {
            bookingItemIds.footkit = availability.footkit.booking_item_ids[0];
        }
        
        // Store the dictionary as JSON string
        window.bookingItemIds = JSON.stringify(bookingItemIds);
        
        // Check availability
        const isCarrierAvailable = availability.carrier && availability.carrier.available_units > 0;
        const isFootAvailable = availability.foot && availability.foot.available_units > 0;
        const isFootkitAvailable = availability.footkit && availability.footkit.available_units > 0;
        const isAvailable = isCarrierAvailable && isFootAvailable && isFootkitAvailable;

        $('#booking_item_ids').val(window.bookingItemIds);
        if (!isAvailable) {
            let errorMessage = '';
            const unavailableComponents = [];
            
            // if (!isCarrierAvailable) unavailableComponents.push('carrier');
            // if (!isFootAvailable) unavailableComponents.push('foot');
            // if (!isFootkitAvailable) unavailableComponents.push('footkit');

            // if (!isCarrierAvailable) window.unavailableComponents.push('carrier');
            // if (!isFootAvailable) window.unavailableComponents.push('foot');
            // if (!isFootkitAvailable) window.unavailableComponents.push('footkit');



            if (!isCarrierAvailable) window.unavailableComponents.push('traverse');
            if (!isFootAvailable) window.unavailableComponents.push('fuß');
            if (!isFootkitAvailable) window.unavailableComponents.push('fußkit');


            if (!isCarrierAvailable) unavailableComponents.push('traverse');
            if (!isFootAvailable) unavailableComponents.push('fuß');
            if (!isFootkitAvailable) unavailableComponents.push('fußkit');

            
            const formattedComponents = unavailableComponents.map(item => {
                return item.charAt(0).toUpperCase() + item.slice(1);
            });

            errorMessage += formattedComponents.join(', ');
            
            $('#errorMessage').html(`
                
                <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.size_unavailable_message', ['errorMessage' => '${errorMessage}'])); ?>

                </div>
            `);

            toggleRentButtonRoofRack(isAvailable);
        } else {
            $('#errorMessage').empty();
        }
            
            if (window.currentRecommendation) {
                highlightRecommendedSizesRoofRack(window.currentRecommendation);
            }
        });
    }

    $('#vendor_select').on('change',function(){
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        if ( fromDate && toDate) {
            checkAvailabilityRoofRack();
        }
    })


    $('#rental_from, #rental_to').on('change', function() {

        checkAvailabilityRoofRack();
    
    });



    // function highlightRecommendedSizes(recommendation) {
    //     $('.inner-size-card').removeClass('recommended-size');
        
    //     recommendation.forEach(item => {
    //         $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
    //             .addClass('recommended-size');
    //     });
    // }



    function highlightRecommendedSizesRoofRack(recommendation) {
            $('.inner-size-card').removeClass('recommended-size');
            $('.recommended').addClass('d-none')
        recommendation.forEach(item => {
            const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
            $card.addClass('recommended-size');
            console.log(item)
            $card.find('.recommended').removeClass('d-none');
                $card.find('.recommended').text('EMPFOHLEN');
        });
    }

    var railing_type = $('#railing_type').val();
    console.log('railing_type',railing_type)
    $('#year, #trailer_hitch').change(function() {
        let manufacturer = $('#manufacturer').val();
        let year = $('#year').val();
        let model = $('#model').val();
        let trailer_hitch = $('#trailer_hitch').val();


        const productName = $('#trailer_hitch').data('product-name');
        const selectedValue = $('#trailer_hitch').val();
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
        if (selectedValue === 'no' && hitchRequired) {
            $('#trailer_hitch').val('');

            const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
            modal.show();
            return ;
        }


        if (manufacturer && year && model && trailer_hitch) {
            $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
                window.currentRecommendation = data;
                window.currentRecommendationMap = {};

                if (data.length === 0) {
                    $('#result').html('<p><?php echo e(__('messages.no_recommendations_found')); ?></p>');
                    return;
                }

                $('.roof-name-detail').hide();
                $('#roof-types-container').show();

                

                data.forEach((item, index) => {
                    const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

                console.log('roofTypeSlug',roofTypeSlug)
                    if(railing_type){
                        $(`#roof-type-${roofTypeSlug}`).show();
        
                        window.currentRecommendationMap[roofTypeSlug] = item;
                        $(`#roof-type-${roofTypeSlug}`)
                            .addClass('clickable-roof')
                            .attr('data-rooftype-slug', roofTypeSlug);
                    }
                });

            
                highlightRecommendedSizesRoofRack(data);
            });
        }
    });

    let selectedRecommendation = null;


    $(document).on('click', '.clickable-roof', function () {
        $('.clickable-roof').removeClass('selected');
        $(this).addClass('selected');

        const slug = $(this).data('rooftype-slug');
        selectedRecommendation = window.currentRecommendationMap[slug];
       

        $('#selectedRecommendation').val(JSON.stringify(selectedRecommendation));



        console.log(selectedRecommendation);

        $('#roof-types-container .invalid-feedback').remove();

        if (selectedRecommendation) {
            const html = `
            <div class="roof-info-card" style="padding: 15px; border: 1px solid #ccc; border-radius: 8px; background: #f9f9f9;">
                 <h4><?php echo e(__('messages.bundle_name')); ?> : ${selectedRecommendation.bundle_name}</h4>
                <ul style="list-style: none; padding-left: 0;">
                    <li><strong><?php echo e(__('messages.carrier_length')); ?>:</strong> ${selectedRecommendation.carrier_length || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.foot_sku')); ?>:</strong> ${selectedRecommendation.foot_sku || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.footkit_sku')); ?>:</strong> ${selectedRecommendation.footkit_sku || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.recommended_roofbox_size')); ?>:</strong> ${selectedRecommendation.recommended_roofbox_size || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.roof_type')); ?>:</strong> ${selectedRecommendation.rooftype_ger || 'N/A'}</li>
                </ul>
            </div>
        `;
            carrier_length = selectedRecommendation.carrier_length;
            foot_sku = selectedRecommendation.foot_sku;
            footkit_sku = selectedRecommendation.footkit_sku;
            $('#roof-details-box').html(html).fadeIn();
        } else {
            $('#roof-details-box').hide();
        }
    });



    $(document).on('click', '.inner-size-card', function () {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select').find('option:selected').data('color-name');
        if (!colorName) {
            $('#errorMessage').html(`
                <div class="text-danger mt-2">
                     <?php echo e(__('messages.select_color_first')); ?>

                </div>
            `);
            return;
        }


        const $card = $(this);
        const isAvailable = $card.hasClass('available');
        const isUnavailable = $card.hasClass('unavailable');

        $('.inner-size-card').removeClass('selected');
        $('#errorMessage').empty();

        $card.addClass('selected');

        if (isUnavailable) {
            const message = `
                            <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.product_not_available_message')); ?>

            </div>
            `;
            $('#errorMessage').html(message);
        }

        const sizeId = $(this).data('size-id');
        const variationId = $(this).data('variation-id');
        const sizeName = $(this).data('size-name');

        $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/size-details`, {
            size_id: sizeId,
            variation_id: variationId
        }, function(data) {
            if (data) {
                if (data.length && data.width && data.height) {
                    $('#dimensionsText').hide();
                    $('#dimensionsList').show();
                    $('#dimensionLength').text(data.length);
                    $('#dimensionWidth').text(data.width);
                    $('#dimensionHeight').text(data.height);
                } else {
                    $('#dimensionsText').show().text('Dimensions not available for this size');
                    $('#dimensionsList').hide();
                }

                if (data.weight) {
                    $('#weightText').hide();
                    $('#weightList').show();
                    $('#weightValue').text(data.weight);
                } else {
                    $('#weightText').show().text('Weight not available for this size');
                    $('#weightList').hide();
                }

                if (data.volume) {
                    $('#volumeText').hide();
                    $('#volumeList').show();
                    $('#volumeValue').text(data.volume);
                } else {
                    $('#volumeText').show().text('Volume not available for this size');
                    $('#volumeList').hide();
                }

                if (data.max_load) {
                    $('#maxLoadText').hide();
                    $('#maxLoadList').show();
                    $('#maxLoadValue').text(data.max_load);
                } else {
                    $('#maxLoadText').show().text('Max load not available for this size');
                    $('#maxLoadList').hide();
                }
            } else {
                $('#dimensionsText').show().text('Product details not available for this size');
                $('#dimensionsList').hide();
                $('#weightText').show().text('Product details not available for this size');
                $('#weightList').hide();
                $('#volumeText').show().text('Product details not available for this size');
                $('#volumeList').hide();
                $('#maxLoadText').show().text('Product details not available for this size');
                $('#maxLoadList').hide();
            }
        }).fail(function() {
            $('#dimensionsText').show().text('Error loading product details');
            $('#weightText').show().text('Error loading product details');
            $('#volumeText').show().text('Error loading product details');
            $('#maxLoadText').show().text('Error loading product details');
        });

    });

    $('.roof-name-detail').hide();
    $('#roof-types-container').hide();
        const dailyPrices = window.dailyPrices ;
        const roofRackPrices = window.roofRackPrices; 
        const insuranceFlatFee = 25.00;
    

        function calculateRentRoofRack() {
            // const from = new Date($('#rental_from').val());
            // const to = new Date($('#rental_to').val());


            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());

            if (isNaN(from) || isNaN(to) || to < from) return;

            const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

            let totalRent = 0;

            for (let i = 0; i < days && i < dailyPrices.length; i++) {
                totalRent += dailyPrices[i];

                if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                    console.log('totalRent', totalRent)
                    totalRent += roofRackPrices[i];
                }
            }

            if ($('#insurance_checkbox').is(':checked')) {
                totalRent += insuranceFlatFee;
                $('#withinsurance').removeClass('d-none');
                $('#withoutinsurance').addClass('d-none');
            }else{
                $('#withoutinsurance').removeClass('d-none');
                $('#withinsurance').addClass('d-none');
            }

            $('.inner-number-days span:first').text(days);
            $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
        }

        $('#rental_from, #rental_to').on('change', calculateRentRoofRack);



        $('#insurance_checkbox').on('change', function () {
            $('#insurance_selected').val(this.checked ? 1 : 0);
        });

        $('#roof_rack_checkbox').on('change', function () {
            $('#roof_rack_selected').val(this.checked ? 1 : 0);
        });



        $(document).ready(function() {

            $('#roof_rack_checkbox').change(function() {
                if (!this.checked) {
                    const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                    modal.show();
                }else{
                    calculateRentRoofRack();
                }
            });

            $('#insurance_checkbox').change(function() {
                if (!this.checked) {
                    const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                    modal.show();
                }else{
                    calculateRentRoofRack();
                }
            });

            $('#rentCarrierBtn').click(function() {
                $('#roof_rack_checkbox').prop('checked', true).trigger('change');
                $('#notCarrier').modal('hide');
            });

            $('#bringOwnCarrierBtn').click(function() {
                $('#roof_rack_checkbox').prop('checked', false);
                $('#notCarrier').modal('hide');
                calculateRentRoofRack(); 
            });

            $('#wantInsuranceBtn').click(function() {
                $('#insurance_checkbox').prop('checked', true).trigger('change');
                $('#notInsurance').modal('hide');
            });

            $('#noInsuranceBtn').click(function() {
                $('#insurance_checkbox').prop('checked', false);
                $('#notInsurance').modal('hide');
                calculateRentRoofRack(); 
            });
        function validateForm() {
            let isValid = true;

            // Reset all error states
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').remove();

            // Validate required fields
            if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), "<?php echo e(__('messages.enter_manufacturer')); ?>");
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), "<?php echo e(__('messages.enter_year')); ?>");
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), "<?php echo e(__('messages.enter_model')); ?>");
            isValid = false;
        }
            
            // Trailer hitch validation
            const productName = $('#trailer_hitch').data('product-name');
            const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
            if (hitchRequired && !$('#trailer_hitch').val()) {
                showError($('#trailer_hitch'), "<?php echo e(__('messages.select_trailer_hitch')); ?>");
                isValid = false;
            }
            
        
          
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), "<?php echo e(__('messages.enter_start_date')); ?>");
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), "<?php echo e(__('messages.enter_end_date')); ?>");
            isValid = false;
        } 
        
            
            // Rental dates validation
           
            if ($('#rental_from').val() && $('#rental_to').val()) {
                

                const from = parseDMY($('#rental_from').val());
                const to = parseDMY($('#rental_to').val());
                if (to < from) {
                    showError($('#rental_to'), "<?php echo e(__('messages.end_date_after_start')); ?>");

                    isValid = false;
                }
            }

            if($('#errorMessage').text()){
                isValid = false;
            }
            
            return isValid;
        }

        function showError(element, message) {
            element.addClass('is-invalid');
            if (element.is('select')) {
                element.parent().append(`<div class="invalid-feedback">${message}</div>`);
            } else {
                element.after(`<div class="invalid-feedback">${message}</div>`);
            }
        }

        $('#manufacturer, #year, #model, #trailer_hitch, #rental_from, #rental_to').on('input change', function() {
            $(this).removeClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
            $(this).parent().find('.invalid-feedback').remove();
        });
        $('.inner-size-card').on('click', function() {
            $('.invalid-feedback.d-block').remove();
        });

        $('#requestButton').click(function() {
            populateRequestFormRoofRack();
        });

    $('#submitRequest').click(function() {
        const $btn = $(this); // reference to the button

        $btn.prop('disabled', true).text('Submitting...');
        let isValid = true;
        $('#requestForm .is-invalid').removeClass('is-invalid');

        function showError(id) {
            $(`#${id}`).addClass('is-invalid');
            isValid = false;
        }
    const formData = {
        title : $('#title').val(),
        first_name : $('#first_name').val(),
        last_name : $('#last_name').val(),
        street : $('#street').val(),
        zipcode : $('#zipcode').val(),
        city : $('#city').val(),
        email: $('#requestEmail').val(),
        state : $('#state').val(),
        country_code :$('#country_code').val(),
        phone: $('#requestPhone').val(),
        message: $('#requestMessage').val(),
        product_id: $('#requestProductId').val(),
        product_name: $('#requestProductName').val(),
        rental_from: $('#requestRentalFrom').val(),
        rental_to: $('#requestRentalTo').val(),
        manufacturer: $('#manufacturer').val(),
        car_model: $('#model').val(),
        car_year: $('#year').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: $('#requestRoofType').val(),
        carrier_length: $('#requestCarrierLength').val(),
        foot_sku: $('#requestFootSku').val(),
        footkit_sku: $('#requestFootkitSku').val(),
        pickup_location : $('#vendor_select option:selected').text(),
        unavailable_components: $('#requestUnavailableComponents').val(),
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    if (!formData.title) showError('title');
        if (!formData.first_name) showError('first_name');
        if (!formData.last_name) showError('last_name');
        if (!formData.email) showError('requestEmail');
        if (!formData.phone) showError('requestPhone');
        if (!formData.street) showError('street');
        if (!formData.zipcode) showError('zipcode');
        if (!formData.city) showError('city');
        if (!formData.state) showError('state');
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (formData.email && !emailPattern.test(formData.email)) showError('requestEmail');
        if (!isValid) {
            $btn.prop('disabled', false).text('Submit');
            return;
        }
    
    $.post(`${baseUrl}/product/request`, formData, function(response) {
        if (response.success) {
            $('#requestModal').modal('hide');
            
            $('#requestForm')[0].reset();
            $('#requestSuccessful').modal('show');
        } else {
            alert('There was an error submitting your request. Please try again.');
        }
    }).fail(function() {
        alert('There was an error submitting your request. Please try again.');
    }).always(function() {
        $btn.prop('disabled', false).text('Submit');
    });
});

        $('#bookingForm').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission
            <?php if(auth()->guard()->check()): ?>
            if (validateForm()) {
                let rentalFromStr = $('#rental_from').val();
                let rentalToStr = $('#rental_to').val();

                let rentalFrom = parseDMY(rentalFromStr);
                let rentalTo = parseDMY(rentalToStr);

                let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
                let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
                let formData = {
                    product_id: $('#product_id').val(),
                    product_name: $('#product_name').val(),
                    manufacturer: $('#manufacturer').val(),
                    car_year: $('#year').val(),
                    model: $('#model').val(),
                    trailer_hitch: $('#trailer_hitch').val(),
                    roof_type: selectedRecommendation?.rooftype_ger || '',
                    carrier_length: selectedRecommendation?.carrier_length || '',
                    foot_sku: selectedRecommendation?.foot_sku || '',
                    footkit_sku: selectedRecommendation?.footkit_sku || '',
                    bundle_name: selectedRecommendation?.bundle_name || '',
                    booking_item_ids: $('#booking_item_ids').val() || '',

                    rental_from: $('#rental_from').val(),
                    rental_to: $('#rental_to').val(),
                    days: days,
                    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                    
                    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
                };

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.redirect) {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            const errors = xhr.responseJSON.errors;
                            for (const field in errors) {
                                showError($(`#${field}`), errors[field][0]);
                            }
                        } else {
                            alert('An error occurred. Please try again.');
                        }
                    }
                });
            } else {
                $('html, body').animate({
                    scrollTop: $('.is-invalid').first().offset().top - 100
                }, 500);
            }
            <?php else: ?>
                if(validateForm()){
                    e.preventDefault();
                    $('#guestOptionsModal').modal('show');

                }
            <?php endif; ?>
        });

        $('#continueAsGuest').click(function() {
            const name = $('#firstname').val().trim();
            const surname = $('#surname').val().trim();
            const email = $('#firstemail').val().trim();
            const number = $('#number').val();

        let isValid = true;

        $('#firstname, #surname, #firstemail,#number').removeClass('is-invalid');

        if (name === '') {
            $('#firstname').addClass('is-invalid');
            isValid = false;
        }

        
        if (surname === '') {
            $('#surname').addClass('is-invalid');
            isValid = false;
        }

        if(number === ''){
            $('#number').addClass('is-invalid');
            isValid = false;
        }

        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (email === '' || !emailPattern.test(email)) {
            $('#firstemail').addClass('is-invalid');
            isValid = false;
        }

        if (isValid) {
        
            // $('#guestModal').modal('hide');

        }
            // $('#guestModal').modal('hide');
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                    is_guest: 1,
                    name: $('#firstname').val(),
                    surname: $('#surname').val(),
                    email: $('#firstemail').val(),
                    number : $('#number').val(),
                    product_id: $('#product_id').val(),
                    product_name: $('#product_name').val(),
                    manufacturer: $('#manufacturer').val(),
                    car_year: $('#year').val(),
                    model: $('#model').val(),
                    trailer_hitch: $('#trailer_hitch').val(),
                    roof_type: selectedRecommendation?.rooftype_ger || '',
                    carrier_length: selectedRecommendation?.carrier_length || '',
                    foot_sku: selectedRecommendation?.foot_sku || '',
                    footkit_sku: selectedRecommendation?.footkit_sku || '',
                    bundle_name: selectedRecommendation?.bundle_name || '',          
                    booking_item_ids: $('#booking_item_ids').val() || '',
      
                    rental_from: $('#rental_from').val(),
                    rental_to: $('#rental_to').val(),
                    days: days,
                    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
                };
            $.ajax({
                url: "<?php echo e(route('cart.add')); ?>",
                method: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if(response.status ==  false){
                        $('#guestError')
                    .removeClass('d-none')
                    .text(response.message || 'Something went wrong. Please try again.');
                    }else{
                        $('#guestModal').modal('hide');
                        $('#guestError').addClass('d-none');
                        if (response.redirect) {
                            window.location.href = response.redirect;
                        }
                    }
                
                }
            });
        });
    });

    $(function () {
         $.datepicker.regional['de'] = {
            closeText: 'Schließen',
            prevText: 'Zurück',
            nextText: 'Weiter',
            currentText: 'Heute',
            monthNames: ['Januar','Februar','März','April','Mai','Juni',
                'Juli','August','September','Oktober','November','Dezember'],
            monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
                'Jul','Aug','Sep','Okt','Nov','Dez'],
            dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
            dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            weekHeader: 'KW',
            dateFormat: 'dd.mm.yy',
            firstDay: 1,
            isRTL: false,
        };
        $.datepicker.setDefaults($.datepicker.regional['de']);
             let holidaysRaw = <?php echo json_encode($holidays, 15, 512) ?>;
        let holidays = Array.isArray(holidaysRaw) ? holidaysRaw : Object.values(holidaysRaw);        console.log(holidays);
        let nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        let dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

        let closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            let day = date.getDay();
            let formattedDate = $.datepicker.formatDate('yy-mm-dd', date);
            console.log(formattedDate)

            let isWeekend = closedDays.includes(day);
            let isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        function initDatePickers() {
            $("#rental_from, #rental_to").datepicker("destroy"); // reset old pickers

            $("#rental_from").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    const productName = $('#trailer_hitch').data('product-name');
                    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
                    if (!selectedRecommendation && !hitchRequired) {
                            const modal = new bootstrap.Modal(document.getElementById('railingType'));
                            modal.show();
                       
                        $(this).val(''); 
                        return ;
                    } 
                   
                    checkAvailabilityRoofRack();
                    
                    calculateRentRoofRack();
                }
            });

            $("#rental_to").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                   
                    checkAvailabilityRoofRack();
                   
                    calculateRentRoofRack();
                }
            });
        }

    
        initDatePickers();

   
   


        $('#vendor_select').on('change', function () {


            let vendorId = $(this).val();
            $.ajax({
                url: "<?php echo e(route('vendor.calendar.data')); ?>",
                type: 'GET',
                data: { vendor_id: vendorId },
                success: function (response) {
                    holidays = response.holidays;
                    nonworkingDays = response.nonworkingDays;
                    closedDays = nonworkingDays.map(day => dayMap[day]);
                    initDatePickers();
                }
            });
        });
    });

}

function toggleRentButtonCarrier(isAvailable) {
        if (isAvailable) {
            $('#rentNowButton').removeClass('d-none');
            $('#requestButton').addClass('d-none');
        } else {
            $('#rentNowButton').addClass('d-none');
            $('#requestButton').removeClass('d-none');
        }
    }

    function populateRequestFormCarrier() {
        let selectedRecommendation = $('#selectedRecommendation').val();
        selectedRecommendation = selectedRecommendation ? JSON.parse(selectedRecommendation) : null;


        // Get all relevant product information
        const productId = $('#product_id').val();
        const productName = $('#product_name').val();
        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        const selectedSize = $('.inner-size-card.selected');
        const sizeId = selectedSize.data('size-id');
        const sizeName = selectedSize.data('size-name');
        const variationId = selectedSize.data('variation-id');
        const variationName = selectedSize.data('variation-name') || sizeName;
        const rentalFrom = $('#rental_from').val();
        const rentalTo = $('#rental_to').val();
        const manufacturer = $('#manufacturer').val();
        const model = $('#model').val();
        const year = $('#year').val();
        const trailerHitch = $('#trailer_hitch').val();
        const roofType = selectedRecommendation ? selectedRecommendation.rooftype_ger : '';
        
        // Set hidden field values
        $('#requestProductId').val(productId);
        $('#requestProductName').val(productName);
        $('#requestColorId').val(colorId);
        $('#requestColorName').val(colorName);
        $('#requestSizeId').val(sizeId);
        $('#requestSizeName').val(sizeName);
        $('#requestVariationId').val(variationId);
        $('#requestVariationName').val(variationName);
        $('#requestRentalFrom').val(rentalFrom);
        $('#requestRentalTo').val(rentalTo);
        $('#requestCarrierLength').val(selectedRecommendation ? selectedRecommendation.carrier_length : '');
        $('#requestFootSku').val(selectedRecommendation ? selectedRecommendation.foot_sku : '');
        $('#requestFootkitSku').val(selectedRecommendation ? selectedRecommendation.footkit_sku : '');
        $('#requestRoofType').val(roofType);
        
        // Build product details display
        let detailsHtml = `
            <p><strong><?php echo e(__('messages.product')); ?>:</strong> ${productName}</p>
            <p><strong><?php echo e(__('messages.color')); ?>:</strong> ${colorName}</p>
            <p><strong><?php echo e(__('messages.size_or_variant')); ?>:</strong> ${sizeName || variationName}</p>
            <p><strong><?php echo e(__('messages.rental_period')); ?>:</strong> ${rentalFrom} <?php echo e(__('messages.to')); ?> ${rentalTo}</p>
        `;
        
        if (manufacturer) {
            detailsHtml += `<p><strong><?php echo e(__('messages.vehicle')); ?>:</strong> ${manufacturer} ${model} (${year})</p>`;
        }
        
         if (trailerHitch) {
            detailsHtml += `<p><strong><?php echo e(__('messages.trailer_hitch')); ?>:</strong> 
                ${trailerHitch == 'yes' ? "<?php echo e(__('messages.yes')); ?>" : "<?php echo e(__('messages.no')); ?>"}
            </p>`;
        }
        
 if (roofType) {
            detailsHtml += `<p><strong><?php echo e(__('messages.roof_type')); ?>: </strong>${roofType}</p>`;
        }
        
        // Add unavailable components if any
      if (window.unavailableComponents && window.unavailableComponents.length > 0) {
            const unique = [...new Set(window.unavailableComponents)];

            const capitalized = unique.map(
                item => item.charAt(0).toUpperCase() + item.slice(1)
            );

            detailsHtml += `<p><strong><?php echo e(__('messages.unavailable_components')); ?>:</strong> ${capitalized.join(', ')}</p>`;
            $('#requestUnavailableComponents').val(capitalized.join(', '));
        }
        
        $('#requestProductDetails').html(detailsHtml);
    }


function initCarrierFoot(product_id){
    let notAvailable = 1;
    window.unavailableComponents = [];

    let bookingData = {};
    $(document).ready(function() {
            $.get(`${baseUrl}/userCarDetail`, function(data) {
                if (data) {

                    bookingData = data.data;
                    if (bookingData && Object.keys(bookingData).length > 0) {
                        console.log(bookingData)
                        fillBookingData(bookingData);
                    }
                    
                    
                }

        });
        const waitForOption = (selector, value) => {
            return new Promise(resolve => {
                const interval = setInterval(() => {
                    const $option = $(`${selector} option`).filter(function () {
                        return $(this).val().trim() === value.trim();
                    });
                    if ($option.length) {
                        console.log($option.val(),selector)

                        $(selector).val($option.val()).trigger('change');
                        clearInterval(interval);
                        resolve();
                    }
                }, 200);
            });
        };

        async function fillBookingData(data) {
            if (data.manufacturer) {
                await waitForOption("#manufacturer", data.manufacturer);
            }
            
            if (data.car_model) {
                await waitForOption("#model", data.car_model);
            }
            if (data.car_year) {
                await waitForOption("#year", data.car_year);
            }
            if (data) {
            if(data.trailer_hitch == 1){
                data.trailer_hitch = 'yes';
            }else{
                data.trailer_hitch = 'no'
            }
            await waitForOption("#trailer_hitch", data.trailer_hitch.toLowerCase());
        }
        }

        $('#manufacturer').change(function() {
            $('#model').prop('disabled', true).html('<option>Loading...</option>');
            $('#year').prop('disabled', true).html('<option><?php echo e(__('messages.select')); ?></option>');
            
            let manufacturer = $(this).val();

            $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
                $('#model').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(model => {
                    $('#model').append(`<option value="${model}">${model}</option>`);
                });
            });
        });

        $('#model').change(function() {
            $('#year').prop('disabled', true).html('<option>Loading...</option>');
            
            let manufacturer = $('#manufacturer').val();
            let model = $(this).val();

            $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
                $('#year').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
                data.forEach(year => {
                    $('#year').append(`<option value="${year}">${year}</option>`);
                });
            });
        });
    });



    function checkAvailability(colorId,colorName) {
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        const vendor_id = $('#vendor_select').val();

    
        
        const params = {
            color_id: colorId,
            from_date: fromDate,
            to_date: toDate,
            color_name : colorName,
            vendor_id : vendor_id,
        };

    if(!fromDate || !toDate ||  !colorId || !vendor_id){
        return; 
    }
    
    $.get(`${baseUrl}/product/${product_id}/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            // const isAvailable = availability[sizeId] > 0;
            const sizeData = availability[sizeId] || { available_units: 0, booking_item_ids: [] };
            const isAvailable = availability[sizeId].available_units > 0;
            if (isAvailable && sizeData.booking_item_ids.length > 0) {
                $card.attr(
                    'data-booking-item-ids',
                    sizeData.booking_item_ids && sizeData.booking_item_ids.length > 0
                        ? sizeData.booking_item_ids[0] // only the first ID
                        : ''
                );
            } else {
                $card.removeAttr('data-booking-item-ids');
            }
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });

        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
        });
    }

    $('#vendor_select').on('change',function(){
        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        if (colorId && colorId !== 'Select' && fromDate && toDate) {
            checkAvailability(colorId,colorName);
        }
    })


    $('#rental_from, #rental_to').on('change', function() {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        console.log(colorId)
        if (colorId && colorId !== 'Select') {
            checkAvailability(colorId,colorName);
        }
    });

    // Update color select change handler
    $('#color-select').on('change', function() {
        const colorId = $(this).val();
        const colorName = $('#color-select option:selected').data('color-name');
        console.log(colorName)
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        $('#errorMessage').empty();
        if (colorId && colorId !== 'Select' && fromDate && toDate) {
            checkAvailability(colorId,colorName);
        }
    });





    function highlightRecommendedSizes(recommendation) {
            $('.inner-size-card').removeClass('recommended-size');
            $('.recommended').addClass('d-none')
        recommendation.forEach(item => {
            const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
            $card.addClass('recommended-size');
            console.log(item)
            $card.find('.recommended').removeClass('d-none');
                $card.find('.recommended').text('EMPFOHLEN');
        });
    }

    var railing_type = $('#railing_type').val();
    console.log('railing_type',railing_type)
    $('#year, #trailer_hitch').change(function() {
        let manufacturer = $('#manufacturer').val();
        let year = $('#year').val();
        let model = $('#model').val();
        let trailer_hitch = $('#trailer_hitch').val();


        const productName = $('#trailer_hitch').data('product-name');
        const selectedValue = $('#trailer_hitch').val();
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
        if (selectedValue === 'no' && hitchRequired) {
            $('#trailer_hitch').val('');

            const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
            modal.show();
            return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
            $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
                window.currentRecommendation = data;
                window.currentRecommendationMap = {};

                if (data.length === 0) {
                    $('#result').html('<p><?php echo e(__('messages.no_recommendations_found')); ?></p>');
                    return;
                }

                $('.roof-name-detail').hide();
                $('#roof-types-container').show();

                

                data.forEach((item, index) => {
                    const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

                console.log('roofTypeSlug',roofTypeSlug)
                    if(railing_type){
                        $(`#roof-type-${roofTypeSlug}`).show();
        
                        window.currentRecommendationMap[roofTypeSlug] = item;
                        $(`#roof-type-${roofTypeSlug}`)
                            .addClass('clickable-roof')
                            .attr('data-rooftype-slug', roofTypeSlug);
                    }
                });

                updateSizeCards(data);
            });
        }
    });

    let selectedRecommendation = null;

    $(document).on('click', '.clickable-roof', function () {
        $('.clickable-roof').removeClass('selected');
        $(this).addClass('selected');

        const slug = $(this).data('rooftype-slug');
        selectedRecommendation = window.currentRecommendationMap[slug];
        $('#selectedRecommendation').val(JSON.stringify(selectedRecommendation));


        if (window.currentRecommendation) {
            updateSizeCards(selectedRecommendation);
        }



        $('#roof-types-container .invalid-feedback').remove();
    });



    $(document).on('click', '.inner-size-card', function () {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select').find('option:selected').data('color-name');
        if (!colorName) {
            $('#errorMessage').html(`
                <div class="text-danger mt-2">
                     <?php echo e(__('messages.select_color_first')); ?>

                </div>
            `);
            return;
        }


        const $card = $(this);
        const isAvailable = $card.hasClass('available');
        const isUnavailable = $card.hasClass('unavailable');
        var size = $card.data('size-name');

        $('.inner-size-card').removeClass('selected');
        $('#errorMessage').empty();

        $card.addClass('selected');

        if (isUnavailable) {
            const message = `
                            <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.product_not_available_message')); ?>

            </div>
            `;
            if (!window.unavailableComponents.includes(size)) {
                window.unavailableComponents.push(size);
            }
            $('#errorMessage').html(message);
            toggleRentButtonCarrier(false);
        }else{
            toggleRentButtonCarrier(true);
        }

        const sizeId = $(this).data('size-id');
        const variationId = $(this).data('variation-id');
        const sizeName = $(this).data('size-name');

        $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/size-details`, {
            size_id: sizeId,
            variation_id: variationId
        }, function(data) {
            if (data) {
                if (data.length && data.width && data.height) {
                    $('#dimensionsText').hide();
                    $('#dimensionsList').show();
                    $('#dimensionLength').text(data.length);
                    $('#dimensionWidth').text(data.width);
                    $('#dimensionHeight').text(data.height);
                } else {
                    $('#dimensionsText').show().text('Dimensions not available for this size');
                    $('#dimensionsList').hide();
                }

                if (data.weight) {
                    $('#weightText').hide();
                    $('#weightList').show();
                    $('#weightValue').text(data.weight);
                } else {
                    $('#weightText').show().text('Weight not available for this size');
                    $('#weightList').hide();
                }

                if (data.volume) {
                    $('#volumeText').hide();
                    $('#volumeList').show();
                    $('#volumeValue').text(data.volume);
                } else {
                    $('#volumeText').show().text('Volume not available for this size');
                    $('#volumeList').hide();
                }

                if (data.max_load) {
                    $('#maxLoadText').hide();
                    $('#maxLoadList').show();
                    $('#maxLoadValue').text(data.max_load);
                } else {
                    $('#maxLoadText').show().text('Max load not available for this size');
                    $('#maxLoadList').hide();
                }
            } else {
                $('#dimensionsText').show().text('Product details not available for this size');
                $('#dimensionsList').hide();
                $('#weightText').show().text('Product details not available for this size');
                $('#weightList').hide();
                $('#volumeText').show().text('Product details not available for this size');
                $('#volumeList').hide();
                $('#maxLoadText').show().text('Product details not available for this size');
                $('#maxLoadList').hide();
            }
        }).fail(function() {
            $('#dimensionsText').show().text('Error loading product details');
            $('#weightText').show().text('Error loading product details');
            $('#volumeText').show().text('Error loading product details');
            $('#maxLoadText').show().text('Error loading product details');
        });

    });

    $('.roof-name-detail').hide();
    $('#roof-types-container').hide();
        const dailyPrices =window.dailyPrices;
        const roofRackPrices = window.roofRackPrices; 
        const insuranceFlatFee = 25.00;
    

        function calculateRent() {
            // const from = new Date($('#rental_from').val());
            // const to = new Date($('#rental_to').val());


            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());

            if (isNaN(from) || isNaN(to) || to < from) return;

            const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

            let totalRent = 0;

            for (let i = 0; i < days && i < dailyPrices.length; i++) {
                totalRent += dailyPrices[i];

                if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                    console.log('totalRent', totalRent)
                    totalRent += roofRackPrices[i];
                }
            }

            if ($('#insurance_checkbox').is(':checked')) {
                totalRent += insuranceFlatFee;
                $('#withinsurance').removeClass('d-none');
                $('#withoutinsurance').addClass('d-none');
            }else{
                $('#withoutinsurance').removeClass('d-none');
                $('#withinsurance').addClass('d-none');
            }

            $('.inner-number-days span:first').text(days);
            $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
        }

        $('#rental_from, #rental_to').on('change', calculateRent);



        $('#insurance_checkbox').on('change', function () {
            $('#insurance_selected').val(this.checked ? 1 : 0);
        });

        $('#roof_rack_checkbox').on('change', function () {
            $('#roof_rack_selected').val(this.checked ? 1 : 0);
        });



        $(document).ready(function() {
            $('#size-container').html(`<p><?php echo e(__('messages.select_vehicle_first')); ?></p>`);


            $('#roof_rack_checkbox').change(function() {
                if (!this.checked) {
                    const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                    modal.show();
                }else{
                    calculateRent();
                }
            });

            $('#insurance_checkbox').change(function() {
                if (!this.checked) {
                    const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                    modal.show();
                }else{
                    calculateRent();
                }
            });

            $('#rentCarrierBtn').click(function() {
                $('#roof_rack_checkbox').prop('checked', true).trigger('change');
                $('#notCarrier').modal('hide');
            });

            $('#bringOwnCarrierBtn').click(function() {
                $('#roof_rack_checkbox').prop('checked', false);
                $('#notCarrier').modal('hide');
                calculateRent(); 
            });

            $('#wantInsuranceBtn').click(function() {
                $('#insurance_checkbox').prop('checked', true).trigger('change');
                $('#notInsurance').modal('hide');
            });

            $('#noInsuranceBtn').click(function() {
                $('#insurance_checkbox').prop('checked', false);
                $('#notInsurance').modal('hide');
                calculateRent(); 
            });
        function validateForm() {
            let isValid = true;

            // Reset all error states
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').remove();

            // Validate required fields
            if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), "<?php echo e(__('messages.enter_manufacturer')); ?>");
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), "<?php echo e(__('messages.enter_year')); ?>");
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), "<?php echo e(__('messages.enter_model')); ?>");
            isValid = false;
        }
            
            // Trailer hitch validation
            const productName = $('#trailer_hitch').data('product-name');
            const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
            if (hitchRequired && !$('#trailer_hitch').val()) {
                showError($('#trailer_hitch'), "<?php echo e(__('messages.select_trailer_hitch')); ?>");
                isValid = false;
            }
            
            // Color validation
            if (!$('#color-select').val()) {
            showError($('#color-select'), '<?php echo e(__("messages.enter_color")); ?>');
            isValid = false;
        }
        
        // Size validation
        if (!$('.inner-size-card.selected').length) {
            $('#size-container').after('<div class="invalid-feedback d-block"><?php echo e(__('messages.enter_size')); ?></div>');
            isValid = false;
        }
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), "<?php echo e(__('messages.enter_start_date')); ?>");
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), "<?php echo e(__('messages.enter_end_date')); ?>");
            isValid = false;
        } 
            
            if ($('#rental_from').val() && $('#rental_to').val()) {
                // const from = new Date($('#rental_from').val());
                // const to = new Date($('#rental_to').val());

                const from = parseDMY($('#rental_from').val());
                const to = parseDMY($('#rental_to').val());
                if (to < from) {
                    showError($('#rental_to'), "<?php echo e(__('messages.end_date_after_start')); ?>");

                    isValid = false;
                }
            }

            if($('#errorMessage').text()){
                isValid = false;
            }
            
            return isValid;
        }

        function showError(element, message) {
            element.addClass('is-invalid');
            if (element.is('select')) {
                element.parent().append(`<div class="invalid-feedback">${message}</div>`);
            } else {
                element.after(`<div class="invalid-feedback">${message}</div>`);
            }
        }

        $('#manufacturer, #year, #model, #trailer_hitch, #color-select, #rental_from, #rental_to').on('input change', function() {
            $(this).removeClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
            $(this).parent().find('.invalid-feedback').remove();
        });
        $('.inner-size-card').on('click', function() {
            $('.invalid-feedback.d-block').remove();
        });

        $('#requestButton').click(function() {
        populateRequestFormCarrier();
    });

    $('#submitRequest').click(function() {
        const $btn = $(this); // reference to the button

$btn.prop('disabled', true).text('Submitting...');
let isValid = true;
$('#requestForm .is-invalid').removeClass('is-invalid');

function showError(id) {
    $(`#${id}`).addClass('is-invalid');
    isValid = false;
}
        const formData = {
        title : $('#title').val(),
        first_name : $('#first_name').val(),
        last_name : $('#last_name').val(),
        street : $('#street').val(),
        zipcode : $('#zipcode').val(),
        city : $('#city').val(),
        state : $('#state').val(),
        country_code :$('#country_code').val(),
        phone: $('#requestPhone').val(),
        message: $('#requestMessage').val(),
        email: $('#requestEmail').val(),
        message: $('#requestMessage').val(),
        product_id: $('#requestProductId').val(),
        product_name: $('#requestProductName').val(),
        color_id: $('#requestColorId').val(),
        color_name: $('#requestColorName').val(),
        size_id: $('#requestSizeId').val(),
        size_name: $('#requestSizeName').val(),
        variation_id: $('#requestVariationId').val(),
        variation_name: $('#requestVariationName').val(),
        rental_from: $('#requestRentalFrom').val(),
        rental_to: $('#requestRentalTo').val(),
        manufacturer: $('#manufacturer').val(),
        car_model: $('#model').val(),
        car_year: $('#year').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: $('#requestRoofType').val(),
        carrier_length: $('#requestCarrierLength').val(),
        foot_sku: $('#requestFootSku').val(),
        footkit_sku: $('#requestFootkitSku').val(),
        unavailable_components: $('#requestUnavailableComponents').val(),
        pickup_location : $('#vendor_select option:selected').text(),
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    if (!formData.title) showError('title');
        if (!formData.first_name) showError('first_name');
        if (!formData.last_name) showError('last_name');
        if (!formData.email) showError('requestEmail');
        if (!formData.phone) showError('requestPhone');
        if (!formData.street) showError('street');
        if (!formData.zipcode) showError('zipcode');
        if (!formData.city) showError('city');
        if (!formData.state) showError('state');
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (formData.email && !emailPattern.test(formData.email)) showError('requestEmail');
        if (!isValid) {
            $btn.prop('disabled', false).text('Submit');
            return;
        }
    
    $.post(`${baseUrl}/product/request`, formData, function(response) {
        if (response.success) {
            $('#requestModal').modal('hide');
            
            $('#requestForm')[0].reset();
            $('#requestSuccessful').modal('show');
        }  else {
            alert('There was an error submitting your request. Please try again.');
        }
    }).fail(function() {
        alert('There was an error submitting your request. Please try again.');
    }).always(function() {
        $btn.prop('disabled', false).text('Submit');
    });
});


        $('#bookingForm').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission
            <?php if(auth()->guard()->check()): ?>
            if (validateForm()) {
                let rentalFromStr = $('#rental_from').val();
                let rentalToStr = $('#rental_to').val();

                let rentalFrom = parseDMY(rentalFromStr);
                let rentalTo = parseDMY(rentalToStr);

                let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
                let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
                let formData = {
                    product_id: $('#product_id').val(),
                    product_name: $('#product_name').val(),
                    manufacturer: $('#manufacturer').val(),
                    car_year: $('#year').val(),
                    model: $('#model').val(),
                    trailer_hitch: $('#trailer_hitch').val(),
                    roof_type: selectedRecommendation?.rooftype_ger || '',
                    carrier_length: selectedRecommendation?.carrier_length || '',
                    foot_sku: selectedRecommendation?.foot_sku || '',
                    footkit_sku: selectedRecommendation?.footkit_sku || '',
                    bundle_name: selectedRecommendation?.bundle_name || '',
                    color_id: $('#color-select').val(),
                    color_name: $('#color-select option:selected').data('color-name'),
                    size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                    booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
                    booking_item_ids: $('#booking_item_ids').val() || '',

                    
                    size_name: $('.inner-size-card.selected').data('size-name'),
                    rental_from: $('#rental_from').val(),
                    rental_to: $('#rental_to').val(),
                    days: days,
                    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                    is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
                };

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.redirect) {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            const errors = xhr.responseJSON.errors;
                            for (const field in errors) {
                                showError($(`#${field}`), errors[field][0]);
                            }
                        } else {
                            alert('An error occurred. Please try again.');
                        }
                    }
                });
            } else {
                $('html, body').animate({
                    scrollTop: $('.is-invalid').first().offset().top - 100
                }, 500);
            }
            <?php else: ?>
                if(validateForm()){
                    e.preventDefault();
                    $('#guestOptionsModal').modal('show');

                }
            <?php endif; ?>
        });

        $('#continueAsGuest').click(function() {
            const name = $('#firstname').val().trim();
            const surname = $('#surname').val().trim();
            const email = $('#firstemail').val().trim();
            const number = $('#number').val();

        let isValid = true;

        $('#firstname, #surname, #firstemail,#number').removeClass('is-invalid');

        if (name === '') {
            $('#firstname').addClass('is-invalid');
            isValid = false;
        }

        
        if (surname === '') {
            $('#surname').addClass('is-invalid');
            isValid = false;
        }

        if(number === ''){
            $('#number').addClass('is-invalid');
            isValid = false;
        }

        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (email === '' || !emailPattern.test(email)) {
            $('#firstemail').addClass('is-invalid');
            isValid = false;
        }

        if (isValid) {
        
            // $('#guestModal').modal('hide');

        }
            // $('#guestModal').modal('hide');
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                    is_guest: 1,
                    name: $('#firstname').val(),
                    surname: $('#surname').val(),
                    email: $('#firstemail').val(),
                    number : $('#number').val(),
                    product_id: $('#product_id').val(),
                    product_name: $('#product_name').val(),
                    manufacturer: $('#manufacturer').val(),
                    car_year: $('#year').val(),
                    model: $('#model').val(),
                    trailer_hitch: $('#trailer_hitch').val(),
                    roof_type: selectedRecommendation?.rooftype_ger || '',
                    carrier_length: selectedRecommendation?.carrier_length || '',
                    foot_sku: selectedRecommendation?.foot_sku || '',
                    footkit_sku: selectedRecommendation?.footkit_sku || '',
                    bundle_name: selectedRecommendation?.bundle_name || '',
                    color_id: $('#color-select').val(),
                    color_name: $('#color-select option:selected').data('color-name'),
                    size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                    booking_item_id: $('.inner-size-card.selected').data('booking-item-ids') || '',
                    booking_item_ids: $('#booking_item_ids').val() || '',

                    size_name: $('.inner-size-card.selected').data('size-name'),
                    rental_from: $('#rental_from').val(),
                    rental_to: $('#rental_to').val(),
                    days: days,
                    calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                    is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                    vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
                };
            $.ajax({
                url: "<?php echo e(route('cart.add')); ?>",
                method: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if(response.status ==  false){
                        $('#guestError')
                    .removeClass('d-none')
                    .text(response.message || 'Something went wrong. Please try again.');
                    }else{
                        $('#guestModal').modal('hide');
                        $('#guestError').addClass('d-none');
                        if (response.redirect) {
                            window.location.href = response.redirect;
                        }
                    }
                
                    // window.location.href = '<?php echo e(route("cart.guest_time-selection")); ?>';
                }
            });
        });
    });

    
      

    $(function () {
         $.datepicker.regional['de'] = {
            closeText: 'Schließen',
            prevText: 'Zurück',
            nextText: 'Weiter',
            currentText: 'Heute',
            monthNames: ['Januar','Februar','März','April','Mai','Juni',
                'Juli','August','September','Oktober','November','Dezember'],
            monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
                'Jul','Aug','Sep','Okt','Nov','Dez'],
            dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
            dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            weekHeader: 'KW',
            dateFormat: 'dd.mm.yy',
            firstDay: 1,
            isRTL: false,
        };
        $.datepicker.setDefaults($.datepicker.regional['de']);
              let holidaysRaw = <?php echo json_encode($holidays, 15, 512) ?>;
        let holidays = Array.isArray(holidaysRaw) ? holidaysRaw : Object.values(holidaysRaw);        console.log(holidays);
        let nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        let dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

        let closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            let day = date.getDay();
            let formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            let isWeekend = closedDays.includes(day);
            let isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        function initDatePickers() {
            $("#rental_from, #rental_to").datepicker("destroy"); // reset old pickers

            $("#rental_from").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    const productName = $('#trailer_hitch').data('product-name');
                    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
                    if (!selectedRecommendation && !hitchRequired) {
                            const modal = new bootstrap.Modal(document.getElementById('railingType'));
                            modal.show();
                       
                        $(this).val(''); 
                        return ;
                    } 
                    const startDate = $(this).datepicker('getDate');
                    $("#rental_to").datepicker("option", "minDate", startDate);

                    let colorId = $('#color-select').val();
                    let colorName = $('#color-select option:selected').data('color-name');
                    if (colorId && colorId !== 'Select') {
                        checkAvailability(colorId, colorName);
                    }
                    calculateRent();
                }
            });

            $("#rental_to").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    let colorId = $('#color-select').val();
                    let colorName = $('#color-select option:selected').data('color-name');
                    if (colorId && colorId !== 'Select') {
                        checkAvailability(colorId, colorName);
                    }
                    calculateRent();
                }
            });
        }

    
        initDatePickers();

   
   


        $('#vendor_select').on('change', function () {


            let vendorId = $(this).val();
            $.ajax({
                url: "<?php echo e(route('vendor.calendar.data')); ?>",
                type: 'GET',
                data: { vendor_id: vendorId },
                success: function (response) {
                    holidays = response.holidays;
                    nonworkingDays = response.nonworkingDays;
                    closedDays = nonworkingDays.map(day => dayMap[day]);
                    initDatePickers();
                }
            });
        });
    });
        function updateSizeCards(recommendation) {
        const $sizeContainer = $('#size-container');
        $sizeContainer.empty(); 
        recommendation = Array.isArray(recommendation) ? recommendation : [recommendation];

        if (!recommendation || recommendation.length === 0) {
            $sizeContainer.append('<p><?php echo e(__("messages.no_matching_sizes")); ?></p>');
            return;
        }

        const productName = $('#product_name').val();
        
        let matchingSizes = [];
        let matchingVariations = [];
        console.log(productName,recommendation)
        recommendation.forEach(item => {
            if (productName.includes('Carrier')  ||   productName.includes('Traverse')) {
               
                matchingSizes = matchingSizes.concat(
                    window.currentSizes.filter(size => 
                    parseInt(size.name) * 10 === parseInt(item.carrier_length)
                        
                    )
                );
                matchingVariations = matchingVariations.concat(
                    window.currentVariations.filter(variation => 
                        variation.name === item.carrier_length
                    )
                );
            } 
            else if (productName.includes('Foot Kit') || productName.includes('Footkit')  || productName.includes('Fußkit')) {
                matchingVariations = matchingVariations.concat(
                    window.currentVariations.filter(variation => 
                        variation.name === item.footkit_sku
                    )
                );
            }
            else if (productName.includes('Foot')  || productName.includes('Fuß')) {
                matchingVariations = matchingVariations.concat(
                    window.currentVariations.filter(variation => 
                        variation.name === item.foot_sku
                    )
                );
            }
        
            else {
                matchingSizes = matchingSizes.concat(
                    window.currentSizes.filter(size => 
                        size.name === item.recommended_roofbox_size
                    )
                );
                matchingVariations = matchingVariations.concat(
                    window.currentVariations.filter(variation => 
                        variation.name === item.recommended_roofbox_size
                    )
                );
            }
        });

        // Remove duplicates
        matchingSizes = [...new Map(matchingSizes.map(item => [item.id, item]))].map(([_, item]) => item);
        matchingVariations = [...new Map(matchingVariations.map(item => [item.id, item]))].map(([_, item]) => item);

        if (matchingSizes.length === 0 && matchingVariations.length === 0) {
            $sizeContainer.append('<p><?php echo e(__("messages.no_matching_sizes")); ?></p>');
            return;
        }

        // Generate HTML for matching sizes
        matchingSizes.forEach(size => {
            const text = getSizeText(size.name);
            $sizeContainer.append(`
                <div class="col-md-4">
                    <div class="inner-size-card" 
                        data-size-id="${size.id}"
                        data-size-name="${size.name}"
                        data-carrier-length="${size.carrier_length || ''}">
                        <div class="upper-img-sunroof">
                            <?php if($product->name == 'Roof Box' || $product->name =='Dachbox'): ?>
                            <figure>
                                <img src="<?php echo e(asset('frontend/images/${size.name}.png')); ?>" alt="">
                            </figure>
                            <?php elseif($product->name == 'Rear Box' || $product->name == 'Heckbox'): ?>
                            <figure>
                                <img src="<?php echo e(asset('frontend/images/rear-box.png')); ?>" alt="">
                            </figure>
                            <?php endif; ?>
                        </div>
                        <div class="size-sunreef">
                            <p>${text}</p>
                            ${size.carrier_length ? `<p>Carrier Length: ${size.carrier_length} mm</p>` : ''}
                            <span class="badge bg-secondary"><?php echo e(__('messages.select_color_first')); ?></span>
                            <span class="recommended bg-secondary d-none"></span>
                        </div>
                    </div>
                </div>
            `);
        });

        // Generate HTML for matching variations
        matchingVariations.forEach(variation => {
            $sizeContainer.append(`
                <div class="col-md-4">
                    <div class="inner-size-card" 
                        data-variation-id="${variation.id}"
                        data-size-name="${variation.name}"
                        data-sku="${variation.sku || ''}">
                        <div class="upper-img-sunroof">
                            <?php if($product->name == 'Roof Bike Carrier' || $product->name == 'Dachfahrradträger'): ?>
                            <figure>
                                <img src="<?php echo e(asset('frontend/images/roof-bike.png')); ?>" alt="">
                            </figure>
                            <?php elseif($product->name == 'Clutch Bike Carrier'  || $product->name == 'Kupplungsfahrradträger'): ?>
                            <figure>
                                <img src="<?php echo e(asset('frontend/images/${variation.name}.png')); ?>" alt="">
                            </figure>
                            <?php endif; ?>
                        </div>
                        <div class="size-sunreef">
                            <p>${variation.name}</p>
                            ${variation.sku ? `<p>SKU: ${variation.sku}</p>` : ''}
                            <span class="badge bg-secondary"><?php echo e(__('messages.select_color_first')); ?></span>
                            <span class="recommended bg-secondary d-none"></span>
                        </div>
                    </div>
                </div>
            `);
        });

        // Highlight recommended sizes
        highlightRecommendedSizes(recommendation);
        
        // If color is already selected, check availability
        const colorId = $('#color-select').val();
        const colorName = $('#color-select option:selected').data('color-name');
        const fromDate = $('#rental_from').val();
        const toDate = $('#rental_to').val();
        
        if (colorId && colorId !== 'Select' && fromDate && toDate) {
            checkAvailability(colorId, colorName);
        }
    }
    // Helper function to get size text
    function getSizeText(sizeName) {
        if (sizeName === 'S') return ' >400l';
        if (sizeName === 'M') return ' 400l - 420l';
        if (sizeName === 'L') return ' 450l - 480l';
        if (sizeName === 'XL') return ' 500l - 524l';
        if (sizeName === 'XXL') return ' 600l';
        return parseInt(sizeName) * 10 + ' mm';
    }



}

    
        
   
</script>
<style>

    .clickable-roof {
        border: 2px solid transparent;
        cursor: pointer;
        transition: 0.2s;
    }
    .clickable-roof:hover {
        border-color: #007bff;
    }
    .clickable-roof.selected {
        border-color: #007bff;
        background-color: #e9f5ff;
    }
    
    </style>



<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/pages/product/quote.blade.php ENDPATH**/ ?>