<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Payment Analytics Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Payment Analytics Report</h1>
    <p>Generated on: <?php echo e(now()->format('d.m.Y H:i')); ?></p>

    <table class="table">
        <thead>
            <tr>
                <th>Booking ID</th>
                <th>Payment ID</th>
                <th>Customer Name</th>
                <th>Date</th>
                <th>Payment Method</th>
                <th>Amount (€)</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>#<?php echo e($booking->id); ?></td>
                <td><?php echo e($booking->stripe_payment_intent ?? 'N/A'); ?></td>
                <td><?php echo e($booking->userDetails ? $booking->userDetails->first_name.' '.$booking->userDetails->last_name : 'N/A'); ?></td>
                <td><?php echo e($booking->created_at->format('d.m.Y')); ?></td>
                <td><?php echo e($booking->payment_method ?? 'N/A'); ?></td>
                <td><?php echo e(number_format($booking->total, 2, ',', '.')); ?> €</td>
                <td>
                    <?php switch($booking->payment_status):
                        case ('paid'): ?> Completed <?php break; ?>
                        <?php case ('unpaid'): ?> Canceled <?php break; ?>
                        <?php case ('refund'): ?> Refunded <?php break; ?>
                        <?php case ('reconciliation'): ?> Reconciliation <?php break; ?>
                        <?php default: ?> <?php echo e($booking->payment_status); ?>

                    <?php endswitch; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/payment/pdf.blade.php ENDPATH**/ ?>