<?php $__env->startSection('content'); ?>
<style>
.coupon_management_outer .remove-coupon-btn {
    font-size: 10px;
    position: absolute;
    bottom: 0;
    top: auto;
    right: 10px;
    width: unset;
    height: unset;
    background: #fff;
    color: #5bc0de;
    font-weight: 700;
    padding: 5px 5px;
    border: 1px solid;0
    line-height: 1;
    border-radius: 4px;
}

select#coupon_select{
    border: 1.5px solid #dcdcdc;
    color: #666666;
    background-color: transparent;
    font-weight: 500;
    font-size: 1.6rem;
    line-height: 1.707rem;
    letter-spacing: 0%;
    border-radius: 10px;
    padding: 2rem 1.4rem;
}
.rm-cart-item {
    float: right;
    width: unset;
    height: unset;
    background: #fff;
    color: #5bc0de;
    font-weight: 500;
    padding: 10px 15px;
    border: 1px solid;
    line-height: 1;
    border-radius: 4px;
}
.comm_product_cstom_row {
    justify-content: space-between;
}
.pr-wrap {
    display: flex;
    align-items: center;
    gap: 15px;
}

</style>
    <main>

        <div class="col-9 main-dash-left">

        <section class="detail-show-all ">
           
            <h3 class="sub_heading_16"><?php echo e(__('messages.rent_cart_heading')); ?></h3>

                <div class="row row-gap-3 rent_cart_page_row">
                    <div class="col-lg-9">
                        <?php if($cartItems->isEmpty()): ?>
                            <div class="alert alert-info">
                                <?php echo e(__('messages.cart_empty_message')); ?> <a href="<?php echo e(route('product')); ?>"><?php echo e(__('messages.cart_browse_products')); ?></a> <?php echo e(__('messages.cart_browse_suffix')); ?>

                            </div>
                        <?php else: ?>
                        <?php
                            $firstItem = $cartItems->first();
                        ?>
                            <input type="hidden" id="cart_userId" value="<?php echo e($firstItem->user_id); ?>">
                            <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="comm_border_box_outer mb-4">
                                    <div class="comm_border_box">
                                        <div class="comm_booking_detail_col">
                                            <div class="d-flex comm_product_cstom_row">
                                                <div class="pr-wrap">
                                                <figure class="booking-dt-img">
                                                    <img src="<?php echo e($item->product->images->first() ? asset('storage/' . $item->product->images->where('type','main')->first()->image_path) : asset('frontend/images/placeholder.jpg')); ?>"
                                                        alt="<?php echo e($item->product_name); ?>" class="img-fluid" />
                                                </figure>
                                                <div class="booking_cs_detail">
                                                    <h3 class="name" data-product-id="<?php echo e($item->product_id); ?>"><?php echo e($item->product_name); ?></h3>
                                                    <div class="d-flex book_loctn_wrap">
                                                        <i class="fa-solid fa-location-dot"></i>
                                                        <p> <?php echo e($item->vendor_address); ?></p>
                                                        <input type="hidden" class="cart-address" value="<?php echo e($item->vendor_address); ?>">
                                                        <input type="hidden" class="cart-pickup-date" value="<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('Y-m-d')); ?>">
                                                        <input type="hidden" class="cart-dropoff-date" value="<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('Y-m-d')); ?>">


                                                    </div>
                                                   
                                                </div>
                                                </div>


                                                <?php if($item->coupon_code): ?>
                                                




                                                <div class="comm_border_box_outer main-product-vouch" bis_skin_checked="1">

                                                    <div class="d-flex voucher_coupan_row" bis_skin_checked="1">
                                                        <div class="d-flex coupon_management_outer  " bis_skin_checked="1">
                                                            <figure class="coupon_manage_shape">
                                                                <img src="http://49.249.236.30:3131/dachboxmiete-phase-2/public/frontend/images/coup_shape.png"
                                                                alt="" class="img-fluid">
                                                            </figure>
                                                            <figure class="coupon_management_img">
                                                                <img src="http://49.249.236.30:3131/dachboxmiete-phase-2/public/frontend/images/coup-left.png"
                                                                alt="" class="img-fluid">
                                                            </figure>
                                                            <div class="coupon_mange_content">
                                                                
                                                                <h5 class="coupon_txt">
                                                                    <?php echo e(__('messages.coupon_applied')); ?> <?php echo e(strtoupper(trim($item->coupon_code, '[]" '))); ?>

                                                                </h5>
                                                                
                                                                <h6 class="valid text-success">
                                                                    
                                                                    - <?php echo e(number_format($item->discount, 2, ',', '')); ?> € </h6>
                                                                </div>
                                                                <button class="btn-remove-coupon remove-coupon-btn" data-item_id="<?php echo e($item->id); ?>"
                                                                    title="<?php echo e(__('messages.remove_coupon')); ?>">
                                                                   X
                                                                </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                            </div>
                                           
                                            <div class="comm_renting_dt_row_outer">
                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head"><?php echo e(__('messages.car_information')); ?>:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.brand')); ?>:</h5>
                                                            <h6><?php echo e($item->car_name ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.model')); ?>:</h5>
                                                            <h6><?php echo e($item->model ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.year')); ?>:</h5>
                                                            <h6><?php echo e($item->car_year ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.railing_type')); ?>:</h5>
                                                            <h6><?php echo e($item->roof_type ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.trailer_hitch')); ?>:</h5>
                                                            <h6><?php echo e($item->trailer_hitch ? __('messages.yes') : __('messages.no')); ?></h6>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head"><?php echo e(__('messages.renting_details')); ?>:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.from')); ?>:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?>

                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.to')); ?>:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>

                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.pickup_date_time')); ?>:</h5>
                                                            <h6>
                                                                <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?> |
                                                                <?php echo $item->pickup_time
                                                                    ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i')
                                                                    : '<span style="color: red; font-weight: bold;">' . __('messages.not_set') . '</span>'; ?>

                                                            </h6>
                                                        </div>
                                                        
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.dropoff_date_time')); ?>:</h5>
                                                            <h6>
                                                                <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?> |
                                                                <?php echo $item->dropoff_time
                                                                    ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i')
                                                                    : '<span style="color: red; font-weight: bold;">' . __('messages.not_set') . '</span>'; ?>

                                                            </h6>
                                                        </div>
                                                        
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head"><?php echo e(__('messages.rent_information')); ?>:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.quantity')); ?>:</h5>
                                                            <h6>01</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.rental_days')); ?>:</h5>
                                                            <h6><?php echo e($item->days); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.for_days', ['days' => $item->days])); ?>:</h5>
                                                            <h6><?php echo e(__('messages.total')); ?> <?php echo e(number_format($item->calculated_rent, 2)); ?>€</h6>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="booking_modal_carrier_sec">
                                                <?php if($item->is_carrier_included): ?>
                                                    <div class="d-flex booking_modal_carrier_row">
                                                        <div class="cr_box"></div>
                                                        <h6><?php echo e(__('messages.carrier_included')); ?></h6>
                                                    </div>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.length')); ?>:</h5>
                                                            <h6><?php echo e($item->carrier_length ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.foot_kit')); ?>:</h5>
                                                            <h6><?php echo e($item->footkit_sku ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5><?php echo e(__('messages.foot')); ?>:</h5>
                                                            <h6><?php echo e($item->foot_sku ?? 'N/A'); ?></h6>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if($item->is_insured): ?>
                                                <div class="d-flex booking_modal_carrier_row vkassko_rw">
                                                    <div class="cr_box"></div>
                                                    <h6><?php echo e(__('messages.volkasko_insurance')); ?> 25 €</h6>
                                                </div>
                                            <?php endif; ?>
                                            </div>
                                            <button class="btn btn-sm remove-item rm-cart-item"
                                            data-id="<?php echo e($item->id); ?>"><?php echo e(__('messages.remove_cart_item')); ?></button>
                                            
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            


                            <div class="have_coupon_sec">
                                <div class="sub_heading_16"><?php echo e(__('messages.have_voucher')); ?></div>
                                <div class="inner-main-input inner-main-input2">
                                    <label for="coupon_select" class="form-label"><?php echo e(__('messages.select_voucher')); ?></label>
                            
                                    <div class="d-flex coupn_input_wrap">
                                        <select id="coupon_select" class="form-control">
                                            <option value="">-- <?php echo e(__('messages.select_voucher_placeholder')); ?> --</option>
                                            <!-- Options will be loaded via AJAX -->
                                        </select>
                                    </div>
                            
                                    <div id="coupon_message" class="mt-2"></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if(!$cartItems->isEmpty()): ?>
                        <div class="col-lg-3">
                            <div class="cart_total_right_col">
                                <div class="sub_heading_18"><?php echo e(__('messages.cart_totals')); ?></div>
                                <div class="d-flex comm_detail_list_view cart_total_list">
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.subtotal')); ?>:</h5>
                                        <h6 id="cart_sub_total"><?php echo e(number_format($subtotal, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.discount')); ?>:</h5>
                                        <h6><?php echo e(number_format($discount, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.net_price')); ?>:</h5>
                                        <h6><?php echo e(number_format($netPrice, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.net_price_insurance')); ?>:</h5>
                                        <h6><?php echo e(number_format($insuranceTotal, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.tax_19')); ?>:</h5>
                                        <h6><?php echo e(number_format($tax, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col bott_total_row">
                                        <h5><?php echo e(__('messages.total')); ?>:</h5>
                                        <h6><?php echo e(number_format($total, 2, ',', '')); ?> €</h6>
                                    </div>
                                </div>
                                <div class="d-flex flex-column gap-4 mt-4">
                                    <div class="d-flex form-check">
                                        <input class="form-check-input" type="checkbox" id="terms_checkbox">
                                        <label class="form-check-label" for="terms_checkbox">
                                            <p class="default_text"><?php echo e(__('messages.accept_terms')); ?></p>
                                        </label>
                                    </div>
                                </div>
                                <?php
                                    $hasMissingTimes = false;
                                    foreach ($cartItems as $item) {
                                        if (empty($item->pickup_time) || empty($item->dropoff_time)) {
                                            $hasMissingTimes = true;
                                            $itemWithMissingTime = $item;
                                            break;
                                        }
                                    }
                                    
                                    $href = $hasMissingTimes 
                                        ? route('vendor.cart.confirm', ['cartItem' => $itemWithMissingTime->id])
                                        : route('vendor.checkout.index');
                                ?>
                                <a href="<?php echo e($href); ?>" id="checkout_btn"
                                    class="btn primary-btn primary-btn2 w-100 mt-3 disabled <?php echo e($cartItems->isEmpty() ? 'disabled' : ''); ?>">
                                    <?php echo e(__('messages.checkout')); ?>


                                </a>




                              
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
          
        </section>
        <div class="col-9 main-dash-left">
    </main>
    
    
    <div class="modal fade" id="addressMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content text-center p-4">
            <h4 class="modal_heading mb-3"><?php echo e(__('messages.pickup_location_mismatch_title')); ?></h4>
            <p class="mb-4"><?php echo e(__('messages.pickup_location_mismatch_text')); ?></p>
            <button type="button" class="primary-btn w-100" data-bs-dismiss="modal"><?php echo e(__('messages.okay')); ?></button>
          </div>
        </div>
    </div>
    <div class="modal fade" id="pickupDateMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <h4 class="modal_heading mb-3"><?php echo e(__('messages.different_pickup_dates_title')); ?></h4>
                <p class="mb-4"><?php echo e(__('messages.different_pickup_dates_text')); ?></p>
                <button type="button" class="primary-btn w-100" data-bs-dismiss="modal"><?php echo e(__('messages.okay')); ?></button>
            </div>
        </div>
    </div>

    <div class="modal fade comm-modal " id="removeItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-body text-center">
                <h4 class="mb-4 modal_heading"><?php echo e(__('messages.remove_item_confirmation')); ?></h4>
                <input type="hidden" id="remove-item-id" />
                <div class="d-flex justify-content-center gap-3">
                    <div class="modal_two_btns d-flex justify-content-center">
                       <button type="button" class="primary-outline-btn" data-bs-dismiss="modal"><?php echo e(__('messages.no')); ?></button>
                       <button type="button" class="primary-btn comn-btn-logout" id="confirm-remove-item"><?php echo e(__('messages.yes')); ?></button>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
    

    <div class="modal fade" id="dropoffDateMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content text-center p-4">
            <h4 class="modal_heading mb-3"><?php echo e(__('messages.dropoff_date_mismatch_title')); ?></h4>
            <p class="mb-4"><?php echo e(__('messages.dropoff_date_mismatch_text')); ?></p>
            <button type="button" class="primary-btn w-100" data-bs-dismiss="modal"><?php echo e(__('messages.okay')); ?></button>
          </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            let selectedItemId = null;

            $('.remove-item').click(function (e) {
                e.preventDefault();
                selectedItemId = $(this).data('id'); // Store item ID
                $('#remove-item-id').val(selectedItemId);
                $('#removeItemModal').modal('show'); // Show confirmation modal
            });
            $('#confirm-remove-item').click(function () {
                const itemId = $('#remove-item-id').val();
                $.ajax({
                    url: '<?php echo e(route('vendor.cart.remove')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        item_id: itemId
                    },
                    success: function (response) {
                        if (response.success) {
                            $('#removeItemModal').modal('hide');
                            window.location.reload();
                        }
                    },
                    error: function () {
                        alert('Error removing item. Please try again.');
                    }
                });
            });

           
            $('#apply_coupon').click(function() {
                var couponCode = $('#coupon_code').val().trim();
                var userId = $('#cart_userId').val();
                var subTotal = $('#cart_sub_total').text().replace(' €', '').replace(',', '.');

                if (!couponCode) {
                    Swal.fire({
                                icon: 'warning',
                                title: 'Fehler',
                                text: 'Gutscheincode eingeben',
                                confirmButtonColor: '#5BC0DE',
                            });
                    // $('#coupon_message').html(
                    //     '<div class="alert alert-danger">Please enter a coupon code</div>');
                    return;
                }

                $.ajax({
                    url: '<?php echo e(route('vendor.cart.apply_coupon')); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        coupon_code: couponCode,
                        user_id: userId,
                        sub_total: subTotal,
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            // Show success message
                            // $('#coupon_message').html('<div class="alert alert-success">' +
                            //     response.message + '</div>');

                            // Hide input and show applied coupon
                            $('.coupn_input_wrap').hide();
                            // $('#applied_coupon_section').show();
                            $('.applied-coupon-code').text(couponCode);

                            // Update cart totals
                            if (response.discount) {
                                $('.discount-amount').text('-$' + response.discount.toFixed(2));
                                $('.total-amount').text('$' + response.new_total.toFixed(2));
                            }
                            Swal.fire({
                                icon: 'success',
                                title: 'Erfolg',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            });
                            // window.location.reload()
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Fehler',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            })
                            // $('#coupon_message').html('<div class="alert alert-danger">' +
                            //     response.message + '</div>');

                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                                icon: 'error',
                                title: 'Fehler',
                                text: 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
                                confirmButtonColor: '#5BC0DE',
                            })
                        // $('#coupon_message').html(
                        //     '<div class="alert alert-danger">Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.</div>'
                        // );
                    }
                });
            });

            // Remove coupon handler
            $(document).on('click', '.remove-coupon-btn', function() {
                    // Store the button element in case we need it later
                    var $removeButton = $(this);
                    
                    Swal.fire({
                        title: "<?php echo e(__('messages.remove_voucher_title')); ?>",
                        text: "<?php echo e(__('messages.remove_voucher_text')); ?>",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#5BC0DE',
                        cancelButtonColor: '#919191ad',
                        confirmButtonText: 'Yes, remove it!',
                        cancelButtonText: 'No, keep it'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // User confirmed - proceed with removal
                            var userId = $('#cart_userId').val();
                            var itemId = $removeButton.data('item_id');

                            // Show loading state
                            $removeButton.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Removing...');

                            $.ajax({
                                url: '<?php echo e(route("cart.remove_single_coupon")); ?>', // Make sure this route is correct
                                type: 'POST',
                                data: {
                                    _token: '<?php echo e(csrf_token()); ?>',
                                    user_id: userId,
                                    item_id: itemId,
                                },
                                dataType: 'json',
                                success: function(response) {
                                    if (response.success) {
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Erfolg',
                                            text: response.message,
                                            confirmButtonColor: '#5BC0DE',
                                        }).then(() => {
                                            // Refresh the page or update UI as needed
                                            window.location.reload();
                                        });
                                    } else {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Fehler',
                                            text: response.message,
                                            confirmButtonColor: '#5BC0DE',
                                        });
                                        $removeButton.prop('disabled', false).html('Remove');
                                    }
                                },
                                error: function(xhr) {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Fehler',
                                        text: 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
                                        confirmButtonColor: '#5BC0DE',
                                    });
                                    $removeButton.prop('disabled', false).html('Remove');
                                }
                            });
                        }
                    });
                });

            $('#terms_checkbox').change(function () {
                if ($(this).is(':checked')) {
                    const addresses = new Set();
                    const pickupDates = new Set();
                    const dropoffDates = new Set();

                    $('.cart-address').each(function () {
                        addresses.add($(this).val().trim());
                    });

                    $('.cart-pickup-date').each(function () {
                        pickupDates.add($(this).val().trim());
                    });

                    $('.cart-dropoff-date').each(function () {
                        dropoffDates.add($(this).val().trim());
                    });

                    if (addresses.size > 1) {
                        $('#terms_checkbox').prop('checked', false);
                        $('#checkout_btn').addClass('disabled');
                        $('#addressMismatchModal').modal('show');
                    } 
                    else if (pickupDates.size > 1) {
                        $('#terms_checkbox').prop('checked', false);
                        $('#checkout_btn').addClass('disabled');
                        $('#pickupDateMismatchModal').modal('show');
                    }
                    else if (dropoffDates.size > 1) {
                        $('#terms_checkbox').prop('checked', false);
                        $('#checkout_btn').addClass('disabled');
                        $('#dropoffDateMismatchModal').modal('show');
                    }
                    else {
                        $('#checkout_btn').removeClass('disabled');
                    }
                } else {
                    $('#checkout_btn').addClass('disabled');
                }
            });
        });

        $(document).ready(function () {
            let userId = $('#cart_userId').val();
            let firstProductId = $('.comm_border_box_outer').first().find('.name').data('product-id'); 
            // Make sure you add data-product-id="<?php echo e($item->product_id); ?>" in Blade

            // 🔹 Load coupons on page load
            $.ajax({
                url: '<?php echo e(route("vendor.booking.get_coupons")); ?>', 
                type: 'GET',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    product_id: firstProductId,
                },
                success: function (response) {
                    if (response.success && response.coupons.length > 0) {
                        let options = '<option value="">-- Select a coupon --</option>';
                        response.coupons.forEach(function (coupon) {
                            options += `<option value="${coupon.code}">
                                            ${coupon.code}
                                        </option>`;
                        });
                        $('#coupon_select').html(options);
                    } else {
                        $('#coupon_select').html('<option value="">No coupons available</option>');
                    }
                }
            });

            // 🔹 When user selects a coupon
            $('#coupon_select').change(function () {
                let couponCode = $(this).val();
                let subTotal = $('#cart_sub_total').text().replace(' €', '').replace(',', '.');

                if (!couponCode) return;

                $.ajax({
                    url: '<?php echo e(route("vendor.cart.apply_coupon")); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        coupon_code: couponCode,
                        user_id: userId,
                        sub_total: subTotal,
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Erfolg',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            }).then(() => {
                                window.location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Fehler',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Fehler',
                            text: 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
                            confirmButtonColor: '#5BC0DE',
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/booking/cartPage.blade.php ENDPATH**/ ?>