<?php $__env->startSection('content'); ?>
<main>
  <section class="banner-back-img-with profile_main_page">
    <div class="inner-main-img">
      <div class="container">
        <div class="inner-banner-comn">
          <h1>Profile Overview</h1>
        </div>
      </div>
    </div>
  </section>

  <div class="prof-main">
    <section class="comn-padd">
      <div class="container">
        <div class="inner-acount">
          <div class="row">
            <div class="col-lg-3">
              <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-lg-9">              
              <section id="edit-my-profile">
                <div class="comm_border_box">
                  <h3 class="main-head-pro">My Profile</h3>

                  <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                      <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    </div>
                  <?php endif; ?>

                  <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                  <?php endif; ?>

                  
                  <div class="dash_form_outer">
                    <form id="profileForm" class="row comm_form needs-validation" method="POST" action="<?php echo e(route('user.update')); ?>" enctype="multipart/form-data" novalidate>
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="img-profile-main d-flex mb-4">
                          <div class="profile-pic">
                              <label class="label" for="file">
                                  <img class="edit-prof-img" src="<?php echo e(asset('frontend/images/basil_edit-outline.svg')); ?>" alt="edit" />
                              </label>
                              <input name="profile_picture" type="file" id="file" class="form-control" accept="image/*" />
                              <figure class="profile-img">
                                  <img id="profileImagePreview" 
                                      src="<?php echo e($user->profile_image ? asset('storage/' . $user->profile_image) : asset('frontend/images/user.png')); ?>"
                                      alt="Profile Image" />
                              </figure>
                              <div class="invalid-feedback" id="profile-picture-error"></div>
                          </div>
                      </div>
                        
                        <!-- Title Field -->
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label">Title</label>
                                    <select name="title" class="form-select" required>
                                        <option value="">Select</option>
                                        <option value="Mr." <?php echo e($user->title == 'Mr.' ? 'selected' : ''); ?>>Mr.</option>
                                        <option value="Mrs." <?php echo e($user->title == 'Mrs.' ? 'selected' : ''); ?>>Mrs.</option>
                                        <option value="Miss" <?php echo e($user->title == 'Miss' ? 'selected' : ''); ?>>Miss</option>
                                    </select>
                                    <div class="invalid-feedback">Please select a title</div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">First Name</label>
                                    <input type="text" name="first_name" class="form-control" placeholder="Enter your name"
                                        value="<?php echo e($user->first_name); ?>" required minlength="2" maxlength="50">
                                    <div class="invalid-feedback">First name must be 2-50 characters</div>
                                </div>
                            </div>
                        </div>
                    
                        <!-- Last Name Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">Surname</label>
                                <input type="text" name="last_name" class="form-control" placeholder="Enter your surname"
                                    value="<?php echo e($user->last_name); ?>" required minlength="2" maxlength="50">
                                <div class="invalid-feedback">Last name must be 2-50 characters</div>
                            </div>
                        </div>
                    
                        <!-- Address Field -->
                        <div class="col-md-12">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">Street, House Number</label>
                                <input type="text" name="street" class="form-control" placeholder="Enter your address"
                                    value="<?php echo e($user->street); ?>" required>
                                <div class="invalid-feedback">Please enter your address</div>
                            </div>
                        </div>
                    
                        <!-- Zip Code Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">Zip Code</label>
                                <input type="text" name="zip_code" class="form-control" placeholder="Enter zip code"
                                    value="<?php echo e($user->zip_code); ?>" required pattern="\d{4,6}">
                                <div class="invalid-feedback">Please enter a valid 4-6 digit zip code</div>
                            </div>
                        </div>
                    
                        <!-- City Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">City</label>
                                <input type="text" name="city" class="form-control" placeholder="Enter city"
                                    value="<?php echo e($user->city); ?>" required>
                                <div class="invalid-feedback">Please enter your city</div>
                            </div>
                        </div>
                    
                        <!-- Region Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">Region/State</label>
                                <select name="region" class="form-select" required>
                                    <option value="">Select Region</option>
                                    <option value="Baden-Württemberg" <?php echo e($user->region == 'Baden-Württemberg' ? 'selected' : ''); ?>>Baden-Württemberg</option>
                                    <option value="Bavaria" <?php echo e($user->region == 'Bavaria' ? 'selected' : ''); ?>>Bavaria</option>
                                    <option value="Berlin" <?php echo e($user->region == 'Berlin' ? 'selected' : ''); ?>>Berlin</option>
                                    <option value="Brandenburg" <?php echo e($user->region == 'Brandenburg' ? 'selected' : ''); ?>>Brandenburg</option>
                                    <option value="Bremen" <?php echo e($user->region == 'Bremen' ? 'selected' : ''); ?>>Bremen</option>
                                    <option value="Hamburg" <?php echo e($user->region == 'Hamburg' ? 'selected' : ''); ?>>Hamburg</option>
                                    <option value="Hesse" <?php echo e($user->region == 'Hesse' ? 'selected' : ''); ?>>Hesse</option>
                                    <option value="Lower Saxony" <?php echo e($user->region == 'Lower Saxony' ? 'selected' : ''); ?>>Lower Saxony</option>
                                    <option value="Mecklenburg-Vorpommern" <?php echo e($user->region == 'Mecklenburg-Vorpommern' ? 'selected' : ''); ?>>Mecklenburg-Vorpommern</option>
                                    <option value="North Rhine-Westphalia" <?php echo e($user->region == 'North Rhine-Westphalia' ? 'selected' : ''); ?>>North Rhine-Westphalia</option>
                                    <option value="Rhineland-Palatinate" <?php echo e($user->region == 'Rhineland-Palatinate' ? 'selected' : ''); ?>>Rhineland-Palatinate</option>
                                    <option value="Saarland" <?php echo e($user->region == 'Saarland' ? 'selected' : ''); ?>>Saarland</option>
                                    <option value="Saxony" <?php echo e($user->region == 'Saxony' ? 'selected' : ''); ?>>Saxony</option>
                                    <option value="Saxony-Anhalt" <?php echo e($user->region == 'Saxony-Anhalt' ? 'selected' : ''); ?>>Saxony-Anhalt</option>
                                    <option value="Schleswig-Holstein" <?php echo e($user->region == 'Schleswig-Holstein' ? 'selected' : ''); ?>>Schleswig-Holstein</option>
                                    <option value="Thuringia" <?php echo e($user->region == 'Thuringia' ? 'selected' : ''); ?>>Thuringia</option>
                                </select>
                                
                                <div class="invalid-feedback">Please select your region</div>
                            </div>
                        </div>
                    
                        <!-- Phone Field -->
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label">Phone Code</label>
                                    <select name="country_code" class="form-select country_code_custom" required id="country_code">
                                        <option value="">Select Code</option>
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png"  <?php echo e($user->country_code == '+49' ? 'selected' : ''); ?>>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e($user->country_code == '+43' ? 'selected' : ''); ?>>+43</option>
                                        <option value="+41"  data-image="https://flagcdn.com/16x12/ch.png" <?php echo e($user->country_code == '+41' ? 'selected' : ''); ?>>+41</option>
                                    </select>
                                    <div class="invalid-feedback">Please select phone code</div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">Phone Number</label>
                                    <input type="tel" name="number" class="form-control" placeholder="Phone number"
                                        value="<?php echo e($user->number); ?>" required pattern="[\d\-\s]{6,20}">
                                    <div class="invalid-feedback">Please enter a valid phone number (6-20 digits)</div>
                                </div>
                            </div>
                        </div>
                    
                        <!-- Email Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" placeholder="Email"
                                    value="<?php echo e($user->email); ?>" required>
                                <div class="invalid-feedback">Please enter a valid email address</div>
                            </div>
                        </div>
                    
                        <!-- Profile Picture -->
                        
                    
                        <div class="comm_profile_two_btns">
                            <button type="submit" class="primary-btn">Save changes</button>
                            <a href="<?php echo e(route('user.index')); ?>" class="secondary-btn">Cancel</a>
                        </div>
                    </form>
                    </div>
                  </div>
                </div>
              </section>         
            </div>
          </div>
        </div>
      </div>
    </section>
    
  </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('file').addEventListener('change', function(event) {
        const output = document.getElementById('profileImagePreview');
        const file = event.target.files[0];
        const errorElement = document.getElementById('profile-picture-error');
        
        if (file) {
            // Validate file type
            if (!file.type.startsWith('image/')) {
                errorElement.textContent = 'Please select an image file';
                event.target.value = '';
                return;
            }
            
            // Validate file size (max 2MB)
            if (file.size > 2 * 1024 * 1024) {
                errorElement.textContent = 'Image must be less than 2MB';
                event.target.value = '';
                return;
            }
            
            errorElement.textContent = '';
            const reader = new FileReader();
            reader.onload = function(e) {
                output.src = e.target.result;
            }
            reader.readAsDataURL(file);
        }
    });

    const form = document.getElementById('profileForm');
    
    form.querySelectorAll('input, select').forEach(element => {
        element.addEventListener('blur', function() {
            validateField(this);
        });
    });
    
    const emailField = form.querySelector('input[name="email"]');
    if (emailField) {
        emailField.addEventListener('blur', function() {
            if (this.value && this.value !== '<?php echo e($user->email); ?>') {
                checkEmailAvailability(this.value);
            }
        });
    }
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        let isValid = true;
        form.querySelectorAll('input, select').forEach(element => {
            if (!validateField(element)) {
                isValid = false;
            }
        });
        
        if (isValid) {
            submitForm();
        }
    });
    
    function validateField(field) {
    const errorElement = field.nextElementSibling;

    const name = field.name;
    const value = field.value.trim();

    // Required fields
    if (field.hasAttribute('required') && !value) {
        field.classList.add('is-invalid');
        if (errorElement) {
            switch (name) {
                case 'first_name':
                    errorElement.textContent = 'Please enter first name';
                    break;
                case 'last_name':
                    errorElement.textContent = 'Please enter surname';
                    break;
                case 'street':
                    errorElement.textContent = 'Please enter your address';
                    break;
                case 'zip_code':
                    errorElement.textContent = 'Please enter your zip code';
                    break;
                case 'city':
                    errorElement.textContent = 'Please enter your city';
                    break;
                case 'region':
                    errorElement.textContent = 'Please select your region';
                    break;
                case 'phone_code':
                    errorElement.textContent = 'Please select phone code';
                    break;
                case 'number':
                    errorElement.textContent = 'Please enter phone number';
                    break;
                case 'email':
                    errorElement.textContent = 'Please enter email address';
                    break;
                case 'title':
                    errorElement.textContent = 'Please select a title';
                    break;
                default:
                    errorElement.textContent = 'This field is required';
            }
        }
        return false;
    }

    // Email format
    if (field.type === 'email' && value && !/^\S+@\S+\.\S+$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = 'Please enter a valid email address';
        }
        return false;
    }

    // Zip code
    if (name === 'zip_code' && value && !/^\d{4,6}$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = 'Zip code must be 4-6 digits';
        }
        return false;
    }

    // Phone number
    if (name === 'number' && value && !/^[\d\-\s]{8,15}$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = 'Phone number must be 8-15 digits';
        }
        return false;
    }

    // Minlength (e.g., first/last name)
    if (field.hasAttribute('minlength') && value.length < parseInt(field.getAttribute('minlength'))) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = `Must be at least ${field.getAttribute('minlength')} characters`;
        }
        return false;
    }

    // Passed all validations
    field.classList.remove('is-invalid');
    if (errorElement) {
        errorElement.textContent = '';
    }
    return true;
}
    function checkEmailAvailability(email) {
        fetch('<?php echo e(route("user.check-email")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ email: email })
        })
        .then(response => response.json())
        .then(data => {
            const emailField = form.querySelector('input[name="email"]');
            const errorElement = emailField.nextElementSibling;
            
            if (data.available) {
                emailField.classList.remove('is-invalid');
                errorElement.textContent = '';
            } else {
                emailField.classList.add('is-invalid');
                errorElement.textContent = 'This email is already in use';
            }
        });
    }
    
    function submitForm() {
        const formData = new FormData(form);
        
        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
         
            if (data.success) {
                window.location.href = data.redirect_url + '?updated=1';
            } else {
                // Show validation errors
                if (data.errors) {
                    for (const [field, messages] of Object.entries(data.errors)) {
                        const input = form.querySelector(`[name="${field}"]`);
                        const errorElement = input.nextElementSibling;
                        
                        if (input && errorElement) {
                            input.classList.add('is-invalid');
                            errorElement.textContent = messages[0];
                        }
                    }
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
});
  </script>
      <script>
        function formatFlag(option) {
            if (!option.id) return option.text;
            const imageUrl = $(option.element).data('image');
            const text = option.text;
            if (imageUrl) {
                return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
            }
            return text;
        }
    
        $(document).ready(function () {
            $('#country_code').select2({
                templateResult: formatFlag,
                templateSelection: formatFlag,
                minimumResultsForSearch: -1 
            });
        });
    </script>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/user/profile/edit.blade.php ENDPATH**/ ?>