<!DOCTYPE html>
<html>
<head>
    <title><?php echo e(__('messages.invoice')); ?> <?php echo e($invoice_number); ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .header { margin-bottom: 20px; border-bottom: 1px solid #eee; padding-bottom: 10px; }
        .issuer, .recipient { width: 45%; float: left; margin-bottom: 30px; }
        .recipient { float: right; }
        .clear { clear: both; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; font-weight: bold; }
        .totals { float: right; width: 300px; margin-top: 20px; }
        .footer { margin-top: 50px; font-size: 10px; border-top: 1px solid #eee; padding-top: 10px; }
        .invoice-title { font-size: 24px; color: #333; }
    </style>
</head>
<body>
    <div class="header">
        <h1 class="invoice-title"><?php echo e(__('messages.invoice')); ?> <?php echo e($invoice_number); ?></h1>
        <p><strong><?php echo e(__('messages.date')); ?>:</strong> <?php echo e($invoice_date->format('d.m.Y')); ?></p>
    </div>

    <div class="issuer">
        <h3><?php echo e(__('messages.issuer')); ?>:</h3>
        <p><strong><?php echo e($issuer['name']); ?></strong></p>
        <p><?php echo e($issuer['address']); ?></p>
        <p><?php echo e(__('messages.tax_number')); ?>: <?php echo e($issuer['tax_number']); ?></p>
        <p><?php echo e(__('messages.vat_id')); ?>: <?php echo e($issuer['vat_number']); ?></p>
    </div>

    <div class="recipient">
        <h3><?php echo e(__('messages.recipient')); ?>:</h3>
        <p><strong><?php echo e($recipient['name']); ?></strong></p>
        <p><strong><?php echo e($recipient['company_name']); ?></strong></p>
        <p><?php echo e($recipient['address']); ?></p>
        <p><?php echo e($recipient['zip']); ?> <?php echo e($recipient['city']); ?></p>
        <p><?php echo e($recipient['country']); ?></p>
        <p><?php echo e(__('messages.email')); ?>: <?php echo e($recipient['email']); ?></p>
        <p><?php echo e(__('messages.phone')); ?>: <?php echo e($recipient['phone']); ?></p>
    </div>

    <div class="clear"></div>

    <h3><?php echo e(__('messages.booking_details')); ?>:</h3>
    <p><strong><?php echo e(__('messages.booking_date')); ?>:</strong> <?php echo e($booking_date->format('d.m.Y H:i')); ?></p>
    <p><strong><?php echo e(__('messages.payment_method')); ?>:</strong> <?php echo e(ucfirst($payment_method)); ?></p>

    <table>
        <thead>
            <tr>
                <th><?php echo e(__('messages.product')); ?></th>
                <th><?php echo e(__('messages.car_details')); ?></th>
                <th><?php echo e(__('messages.insurance')); ?></th>
                <th><?php echo e(__('messages.carrier')); ?></th>
                <th><?php echo e(__('messages.pickup')); ?></th>
                <th><?php echo e(__('messages.dropoff')); ?></th>
                <th><?php echo e(__('messages.price')); ?> (€)</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $booking_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($item['product_name']); ?> (<?php echo e($item['size']); ?>)</td>
            <td>
                <?php echo e($item['car_name']); ?> <?php echo e($item['car_year']); ?> <?php echo e($item['model']); ?><br>
                <?php echo e(__('messages.color')); ?>: <?php echo e($item['color']); ?><br>
                <?php echo e(__('messages.roof')); ?>: <?php echo e($item['roof_type']); ?>

            </td>
            <td><?php echo e($item['is_insured'] ? __('messages.yes') : __('messages.no')); ?></td>
            <td><?php echo e($item['is_carrier_included'] ? __('messages.yes') : __('messages.no')); ?></td>
            <td><?php echo e(Carbon\Carbon::parse($item['pickup_date'])->format('d.m.y')); ?><br>
                <?php echo e($item['pickup_time'] ? Carbon\Carbon::parse($item['pickup_time'])->format('H:i') : ''); ?></td>
            <td><?php echo e(Carbon\Carbon::parse($item['dropoff_date'])->format('d.m.y')); ?><br>
                <?php echo e($item['dropoff_time'] ? Carbon\Carbon::parse($item['dropoff_time'])->format('H:i') : ''); ?></td>
            <td><?php echo e(number_format($item['calculated_rent'], 2, ',', '.')); ?>€</td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="totals">
        <table>
            <tr>
                <td><?php echo e(__('messages.subtotal')); ?>:</td>
                <td><?php echo e(number_format($subtotal, 2, ',', '.')); ?>€</td>
            </tr>
            <?php if($booking->discount > 0): ?>
            <tr>
                <td><?php echo e(__('messages.discount')); ?>:</td>
                <td>-<?php echo e(number_format($booking->discount, 2, ',', '.')); ?>€</td>
            </tr>
            <?php endif; ?>
            <tr>
                <td><?php echo e(__('messages.vat_19')); ?>:</td>
                <td><?php echo e(number_format($tax, 2, ',', '.')); ?>€</td>
            </tr>
            <tr>
                <td><strong><?php echo e(__('messages.total')); ?>:</strong></td>
                <td><strong><?php echo e(number_format($total, 2, ',', '.')); ?>€</strong></td>
            </tr>
        </table>
    </div>

    <div class="clear"></div>

    <div class="footer">
        <p><strong><?php echo e(__('messages.payment_terms')); ?>:</strong> <?php echo e(__('messages.payment_terms_text')); ?></p>
        <p><strong><?php echo e(__('messages.cancellation_policy')); ?>:</strong> <?php echo e(__('messages.cancellation_policy_text')); ?></p>
       <p><?php echo e(__('messages.thank_you_invoice_message')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/payment/invoice/invoice.blade.php ENDPATH**/ ?>