<?php $__env->startComponent('mail::message'); ?>
# Hello <?php echo e($userDetails->first_name); ?>,

Thank you for your order! Your invoice will be sent to you in a separate email.

<?php if(!auth()->check()): ?>
**Don't forget to create a customer account.** There you can:
- View your personal details and orders
- Access an overview of your appointments with us
- Check and use available vouchers
- Easily reschedule appointments
- Conveniently cancel orders and much more!

<?php $__env->startComponent('mail::button', ['url' => route('register')]); ?>
Sign Up Now
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

## Cancellation Policy
Cancellations are free of charge up to 48 hours before the pick-up time. For cancellations made less than 48 hours before the scheduled pick-up, 100% of the booking costs will apply.

You can easily cancel through your customer account or contact us at info@dachboxit.de.

## Booking Summary
**Booking Number:** BO<?php echo e(str_pad($booking->id, 6, '0', STR_PAD_LEFT)); ?>  
**Booking Date:** <?php echo e($booking->created_at->format('d.m.y H:i')); ?>  
**Booking Status:** <?php echo e(ucfirst($booking->status)); ?>  
**Payment Method:** <?php echo e(ucfirst($booking->payment_method)); ?> (<?php echo e(ucfirst($booking->payment_status)); ?>)

### Product Details
<?php $__env->startComponent('mail::table'); ?>
| Product          | Car Details               | Insurance | Carrier Included | Pickup Date          | Dropoff Date         | Price       |
|------------------|---------------------------|-----------|------------------|----------------------|----------------------|-------------|
<?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
| <?php echo e($item->product_name); ?> (<?php echo e($item->size); ?>) | <?php echo e($item->car_name); ?> <?php echo e($item->car_year); ?> <?php echo e($item->model); ?><br>Roof Type: <?php echo e($item->roof_type); ?><br>Color: <?php echo e($item->color); ?> | <?php echo e($item->is_insured ? 'Yes' : 'No'); ?> | <?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?> | <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.y')); ?> <?php echo e($item->pickup_time ? 'at ' . \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : ''); ?> | <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.y')); ?> <?php echo e($item->dropoff_time ? 'at ' . \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : ''); ?> |  <?php echo e(number_format($item->calculated_rent, 2, ',', '.')); ?>€ |
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php echo $__env->renderComponent(); ?>

### Price Overview
- **Subtotal:** <?php echo e(number_format($booking->subtotal, 2)); ?>€
<?php if($booking->discount > 0): ?>
- **Discount:** -<?php echo e(number_format($booking->discount, 2)); ?>€
<?php endif; ?>
- **Tax (19%):** <?php echo e(number_format($booking->tax, 2)); ?>€
- **Total:** **<?php echo e(number_format($booking->total, 2)); ?>€**

### Pickup Information
**Address:**  
<?php echo e($admin->company_name); ?> 
<?php echo e($admin->address); ?>, <?php echo e($admin->zip_code); ?>  
<?php echo e($admin->city); ?>, Germany

## Contact Information
**Email:** <?php echo e($admin->email); ?>  
**Phone:** <?php echo e($admin->number); ?>


Thank you for choosing Dachboxit!

Best regards,  
The Dachboxit Team
<?php echo $__env->renderComponent(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/email/confirmation.blade.php ENDPATH**/ ?>