<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>booking analytics</h2>
            <div class="d-flex comm_head_top_right">
            <div class="sownload-cv-pdf">
                <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
                <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
            </div>
            <form method="GET" action="<?php echo e(route('vendor.booking.index')); ?>" id="timeFilterForm">
                <select name="time_filter" class="form-select select-main-head" aria-label="Default select example">
                    <option value="year" <?php echo e(request('time_filter', 'year') == 'year' ? 'selected' : ''); ?>>Year</option>
                    <option value="month" <?php echo e(request('time_filter') == 'month' ? 'selected' : ''); ?>>Month</option>
                    <option value="week" <?php echo e(request('time_filter') == 'week' ? 'selected' : ''); ?>>Week</option>
                    <option value="day" <?php echo e(request('time_filter') == 'day' ? 'selected' : ''); ?>>Day</option>
                </select>
            </form>
            </div>
        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/total.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Net revenue(excl. tax)</p>
                                    <h4><?php echo e($analytics['net_revenue']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/green-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Bookings</p>
                                    <h4><?php echo e($analytics['total_bookings']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/top.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Number Of Cancellations</p>
                                    <h4><?php echo e($analytics['cancellations']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/lost.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Revenue Bookings</p>
                                    <h4><?php echo e($analytics['total_revenue']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/parot-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
       
        <form id="exportForm" method="GET" action="" style="display: none;">
            <input type="hidden" name="time_filter" id="exportTimeFilter" value="<?php echo e(request('time_filter', 'year')); ?>">
            <input type="hidden" name="status" id="exportStatusFilter" value="<?php echo e(request('status', 'all')); ?>">
        </form>
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>Booking Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search Name/Email"
                                type="text" id="booking_user" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <?php
                        $status = request()->get('status', ''); // get status from query
                        $statusLabel = 'Filter'; // default text
                        if ($status && $status !== 'all') {
                            $statusLabel = ucfirst($status); // make first letter capital
                        } elseif ($status === 'all') {
                            $statusLabel = 'All Statuses';
                        }
                    ?>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="statusFilterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> <?php echo e($statusLabel); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['status' => 'all'])); ?>">All Statuses</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['status' => 'pending'])); ?>">Pending</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['status' => 'confirmed'])); ?>">Confirmed</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['status' => 'completed'])); ?>">Completed</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['status' => 'cancelled'])); ?>">Cancelled</a></li>
                            </ul>
                        </div>
                    </div>

                    <a class="add-notification-btn" href="<?php echo e(route('vendor.add.booking')); ?>">Add Booking</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Booking ID</th>
                            <th>Customer Name</th>
                            <th>Phone Number</th>
                            <th>Email Address</th>
                            <th>Rental Period</th>
                            <th>Rental Days</th>
                            <th>status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="searchBookingUser">
                        <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                #<?php echo e($booking->id); ?>

                                <?php if($booking->items->contains('user_timing', 1)): ?>
                                    <span class="text-danger me-1" title="Customer requested timing change">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                <?php endif; ?>
                            </td>
                            
                            <td>
                                <?php if($booking->userDetails): ?>
                                    <?php echo e($booking->userDetails->first_name); ?> <?php echo e($booking->userDetails->last_name); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($booking->userDetails): ?>
                                    <?php echo e($booking->userDetails->phone); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($booking->userDetails): ?>
                                    <?php echo e($booking->userDetails->email); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($booking->items->isNotEmpty()): ?>
                                    <?php echo e($booking->items->first()->pickup_date->format('d.m.Y')); ?> - 
                                    <?php echo e($booking->items->first()->dropoff_date->format('d.m.Y')); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($booking->items->isNotEmpty()): ?>
                                    <?php echo e($booking->items->first()->days); ?> Days
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <select class="form-select select-active-block" 
                                id="statusSelect<?php echo e($booking->id); ?>" 
                                aria-label="Default select example" data-current-status="<?php echo e($booking->status); ?>">
                                    <option value="pending" class="pending-op" <?php echo e($booking->status == 'pending' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">pending</option>
                                    <option value="cancelled" class="cancel-op" <?php echo e($booking->status == 'cancelled' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">Cancelled</option>
                                    <option value="confirmed" class="confirmed-op" <?php echo e($booking->status == 'confirmed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">confirmed</option>
                                    <option value="completed" class="completed-op"  <?php echo e($booking->status == 'completed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">completed</option>
                                </select>
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="<?php echo e(route('vendor.view.booking.detail', [$booking->id])); ?>">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                   
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="statusChangeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="statusChangeModalText">Are you sure you want to change the booking status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="statusChangeForm" method="POST" action="">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="status" id="newStatusValue">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function exportData(type) {
        const timeFilter = $('#timeFilterForm select').val();
        const statusFilter = "<?php echo e(request('status', 'all')); ?>";
        
        $('#exportTimeFilter').val(timeFilter);
        $('#exportStatusFilter').val(statusFilter);
        
        const action = type === 'csv' 
            ? "<?php echo e(route('vendor.bookings.download.csv')); ?>" 
            : "<?php echo e(route('vendor.bookings.download.pdf')); ?>";
        $('#exportForm').attr('action', action);
        
        $('#exportForm').submit();
    }
$(document).ready(function() {

    $('#bookingTable').DataTable({
        paging: true,
        searching: false, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

    $('#booking_user').on('keyup', function () {
        $('#bookingTable').DataTable().search(this.value).draw();
    });


    // Time filter change
    $('.select-main-head').on('change', function() {
        $('#timeFilterForm').submit();
    });
    
    // Search bookings
    $('#booking_user').on('keyup', function() {
        let searchQuery = $(this).val();
        
        $.ajax({
            url: "<?php echo e(route('vendor.booking.user.search')); ?>",
            method: 'GET',
            data: {
                search: searchQuery,
                time_filter: "<?php echo e(request('time_filter', 'year')); ?>"
            },
            success: function(response) {
                $('#searchBookingUser').html(response.html);
            },
            error: function(xhr, status, error) {
                console.error("Error: " + error);
            }
        });
    });
    
    // Status change handling
    $('.select-active-block').on('change', function() {
        const $select = $(this);
        const newStatus = $select.val();
        const bookingId = $select.attr('id').replace('statusSelect', '');
        const currentStatus = $select.find('option:selected').data('previous-value');
        
        if (newStatus === currentStatus) {
            return;
        }
    
        let message = '';
        switch(newStatus) {
            case 'pending':
                message = 'Are you sure you want to set this booking as Pending?';
                break;
            case 'cancelled':
                message = 'Are you sure you want to cancel this booking?';
                break;
            case 'confirmed':
                message = 'Are you sure you want to confirm this booking?';
                break;
            case 'completed':
                message = 'Are you sure you want to mark this booking as Completed?';
                break;
        }
    
        $('#statusChangeModalText').text(message);
        $('#newStatusValue').val(newStatus);
        $('#statusChangeForm').attr('action', '/vendor/bookings/' + bookingId + '/status');
        
        $('#statusChangeModal').data('select', $select);
        $('#statusChangeModal').data('current-status', currentStatus);
        
        $('#statusChangeModal').modal('show');
    });
    
    $('#statusChangeForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const url = form.attr('action');
        const $select = $('#statusChangeModal').data('select');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                if(response.success) {
                    $select.find('option:selected').data('previous-value', $('#newStatusValue').val());
                    
                    $('#statusChangeModal').modal('hide'); 
                    Swal.fire({
                            icon: 'success',
                            title: 'Booking Status',
                            text: 'Booking status updated successfully!',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.reload();
                            }
                        });
                    
                    updateRowStatus($select.closest('tr'), $('#newStatusValue').val());
                }
            },
            error: function(xhr) {
                console.error('Error:', xhr.responseText);
                alert('Error updating booking status. Please try again.');
                
                $select.val($('#statusChangeModal').data('current-status'));
                
                $('#statusChangeModal').modal('hide');
            }
        });
    });
    
    $('#statusChangeModal').on('hidden.bs.modal', function() {
        const $select = $(this).data('select');
        const currentStatus = $(this).data('current-status');
        
        if ($select && currentStatus) {
            $select.val(currentStatus);
        }
    });
    
    function updateRowStatus($row, status) {
        $row.removeClass('table-warning table-success table-danger table-info');
        
        switch(status) {
            case 'pending':
                $row.addClass('table-warning');
                break;
            case 'confirmed':
                $row.addClass('table-info');
                break;
            case 'completed':
                $row.addClass('table-success');
                break;
            case 'cancel':
                $row.addClass('table-danger');
                break;
        }
    }
  
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/vendor/booking/index.blade.php ENDPATH**/ ?>