<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="<?php echo e(route('admin.booking.index')); ?>">Booking Management</a>
                    <a class="active" href="">Edit Booking Details</a>
                </div>
            </div>

            <div class="add-user-form">
                <h3>Edit Booking <span class="ms-3">Booking ID : #<?php echo e($booking->id); ?></span></h3>
                
                <form method="POST" action="<?php echo e(route('admin.update.booking.detail', $booking->id)); ?>">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Customer Details -->
                    <div class="row">
                        <div class="col-md-1">
                            <div class="comn-input-select">
                                <label for="inputtitle" class="form-label">Title</label>
                                <select id="inputtitle" name="title" class="form-select">
                                    <option value="Mr." <?php echo e(str_contains(optional($booking->userDetails)->first_name, 'Mr.') ? 'selected' : ''); ?>>Mr.</option>
                                    <option value="Mrs." <?php echo e(str_contains(optional($booking->userDetails)->first_name, 'Mrs.') ? 'selected' : ''); ?>>Mrs.</option>
                                    <option value="Ms." <?php echo e(str_contains(optional($booking->userDetails)->first_name, 'Ms.') ? 'selected' : ''); ?>>Ms.</option>
                                    <option value="Dr." <?php echo e(str_contains(optional($booking->userDetails)->first_name, 'Dr.') ? 'selected' : ''); ?>>Dr.</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-5">
                            <div class="comn-input-select">
                                <label for="first-name" class="form-label">First Name</label>
                                <input type="text" class="form-control" id="first-name" name="first_name"
                                    value="<?php echo e(optional($booking->userDetails)->first_name); ?>" required>
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="last-name" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="last-name" name="last_name"
                                    value="<?php echo e(optional($booking->userDetails)->last_name); ?>" required>
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Street, house number:</label>
                                <input type="text" class="form-control" id="inputAddress" name="address"
                                    value="<?php echo e(optional($booking->userDetails)->address); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress2" class="form-label">Zip Code</label>
                                <input type="text" class="form-control" id="inputAddress2" name="zip"
                                    value="<?php echo e(optional($booking->userDetails)->zip); ?>" required>
                                <?php $__errorArgs = ['zip'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputCity" class="form-label">City</label>
                                <input type="text" class="form-control" id="inputCity" name="city"
                                    value="<?php echo e(optional($booking->userDetails)->city); ?>" required>
                                <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputState" class="form-label">Country</label>
                                <select id="inputState" name="country" class="form-select" required>
                                    <option value="">Choose...</option>
                                    <option value="Germany" <?php echo e(old('country', $booking->userDetails->country) == 'Germany' ? 'selected' : ''); ?>>Germany</option>
                                    <option value="Austria" <?php echo e(old('country', $booking->userDetails->country) == 'Austria' ? 'selected' : ''); ?>>Austria</option>
                                    <option value="Switzerland" <?php echo e(old('country', $booking->userDetails->country) == 'Switzerland' ? 'selected' : ''); ?>>Switzerland</option>
                                </select>
                                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="email-address" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email-address" name="email"
                                    value="<?php echo e(optional($booking->userDetails)->email); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputZip" class="form-label">Phone Number</label>
                                <div class="numer-input d-flex">
                                    <?php
                                        $phone = optional($booking->userDetails)->phone;
                                        $phoneCode = '+49';
                                        $phoneNumber = $phone;
                                        
                                        if ($phone && str_starts_with($phone, '+')) {
                                            $phoneCode = substr($phone, 0, 3);
                                            $phoneNumber = substr($phone, 3);
                                        }
                                    ?>
                                    
                                    <select id="phone_code" name="phone_code" class="form-select country_code_custom">
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e($phoneCode == '+49' ? 'selected' : ''); ?>>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e($phoneCode == '+43' ? 'selected' : ''); ?>>+43</option>
                                        <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" <?php echo e($phoneCode == '+41' ? 'selected' : ''); ?>>+41</option>
                                    </select>

                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="<?php echo e($phoneNumber); ?>" required>
                                </div>
                                <?php $__errorArgs = ['phone_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="note-main" class="form-label">Note</label>
                                <input type="text" class="form-control" id="note-main" name="note"
                                    placeholder="Enter Note" value="<?php echo e($booking->note ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Booking Items Section -->
                    <div class="mt-5">
                        <h4 class="booking-item-h">Booking Items</h4>
                        
                        <div class="booking-items-container">
                            <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="booking-item-card mb-4 p-3 border rounded" data-item-id="<?php echo e($item->id); ?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <img src="<?php echo e(asset('frontend/images/roof1.png')); ?>" alt="<?php echo e($item->product_name); ?>" class="img-fluid">
                                    </div>
                                    <div class="col-md-9">
                                        <h5><?php echo e($item->product_name); ?> | <?php echo e($item->size); ?></h5>
                                        
                                        <div class="previous-booking-details mb-3 p-2 bg-light rounded">
                                            <h6>Current Booking:</h6>
                                            <p>
                                                Pickup: <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?> at <?php echo e($item->pickup_time); ?><br>
                                                Dropoff: <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?> at <?php echo e($item->dropoff_time); ?>

                                            </p>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Date</label>
                                                    <input type="text" 
                                                           class="form-control pickup-date flatpickr" 
                                                           data-item-id="<?php echo e($item->id); ?>"
                                                           placeholder="Select Pickup Date"
                                                           data-default-date="<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?>">
                                                    <input type="hidden" 
                                                           name="items[<?php echo e($item->id); ?>][pickup_date]" 
                                                           value="<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?>">
                                                    <?php $__errorArgs = ["items.{$item->id}.pickup_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Time</label>
                                                    <select name="items[<?php echo e($item->id); ?>][pickup_time]" class="form-control pickup-time" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    <?php $__errorArgs = ["items.{$item->id}.pickup_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Date</label>
                                                    <input type="text" 
                                                           class="form-control dropoff-date flatpickr" 
                                                           data-item-id="<?php echo e($item->id); ?>"
                                                           placeholder="Select Dropoff Date"
                                                           data-default-date="<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>">
                                                    <input type="hidden" 
                                                           name="items[<?php echo e($item->id); ?>][dropoff_date]" 
                                                           value="<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>">
                                                    <?php $__errorArgs = ["items.{$item->id}.dropoff_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Time</label>
                                                    <select name="items[<?php echo e($item->id); ?>][dropoff_time]" class="form-control dropoff-time" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    <?php $__errorArgs = ["items.{$item->id}.dropoff_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group mt-3">
                                            <label>Change Reason (Optional)</label>
                                            <textarea name="items[<?php echo e($item->id); ?>][change_reason]" class="form-control" rows="2"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <div class="upper-main-btn-last-comn d-flex">
                            <button type="submit" class="add-user">Update Booking</button>
                            <a href="<?php echo e(route('admin.booking.index')); ?>" class="cancel-btn">Back</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    .flatpickr-input {
        background-color: white;
        cursor: pointer;
    }
    .booking-item-card {
        background-color: #f8f9fa;
        transition: all 0.3s ease;
    }
    .booking-item-card:hover {
        background-color: #e9ecef;
    }
    .previous-booking-details {
        font-size: 0.9rem;
    }
    .text-danger {
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
</style>

<script>
    var baseUrl = '/dachboxmiete/public';
    $(document).ready(function() {
        // Initialize Flatpickr with disabled weekends
        $('.flatpickr').flatpickr({
            dateFormat: "d.m.Y",
            minDate: "today",
            disable: [
                function(date) {
                    // Disable weekends (Sunday = 0, Saturday = 6)
                    return (date.getDay() === 0 || date.getDay() === 6);
                }
            ],
            locale: {
                firstDayOfWeek: 1 // Monday
            },
            onChange: function(selectedDates, dateStr, instance) {
                const itemId = instance.element.dataset.itemId;
                const isPickup = instance.element.classList.contains('pickup-date');
                
                $(`input[name="items[${itemId}][${isPickup ? 'pickup' : 'dropoff'}_date]"]`).val(dateStr);
                
                // Clear any existing validation errors
                $(`.booking-item-card[data-item-id="${itemId}"] .${isPickup ? 'pickup' : 'dropoff'}-date`).next('.text-danger').remove();
                
                // Only load time slots if date is selected
                if (dateStr) {
                    loadTimeSlots(itemId, dateStr, isPickup);
                } else {
                    // Clear time slots if date is cleared
                    const timeSelect = isPickup ? 
                        $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                        $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                    timeSelect.html('<option value="">Select date first</option>').prop('disabled', true);
                }
                
                validateDateRange(itemId);
            }
        });
        
        function loadTimeSlots(itemId, date, isPickup) {
            const timeSelect = isPickup ? 
                $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                
            timeSelect.prop('disabled', true).html('<option value="">Loading time slots...</option>');
            
            $.ajax({
                url: `${baseUrl}/admin/getTime`,
                type: 'GET',
                data: {
                    date: date,
                    item_id: itemId,
                    is_pickup: isPickup
                },
                success: function(response) {
                    let options = '<option value="">No time selected (keep current)</option>';
                    
                    if (response.slots && response.slots.length > 0) {
                        response.slots.forEach(slot => {
                            const timeValue = slot.label.split(' - ')[0];
                            const disabledAttr = slot.disabled ? 'disabled' : '';
                            
                            options += `<option value="${timeValue}" ${disabledAttr}>${slot.label}</option>`;
                        });
                    }
                    
                    timeSelect.html(options).prop('disabled', false);
                    
                    // If keeping existing time, set it as selected
                    const previousTime = isPickup ? 
                        "<?php echo e($item->pickup_time); ?>" : 
                        "<?php echo e($item->dropoff_time); ?>";
                    if (previousTime) {
                        timeSelect.find('option').each(function() {
                            if ($(this).val() === previousTime) {
                                $(this).prop('selected', true);
                                return false; // break the loop
                            }
                        });
                    } else {
                        // Select "No time selected" by default
                        timeSelect.val('');
                    }
                },
                error: function() {
                    timeSelect.html('<option value="">Error loading slots</option>');
                }
            });
        }
        
        function validateDateRange(itemId) {
            const pickupDate = $(`input[name="items[${itemId}][pickup_date]"]`).val();
            const dropoffDate = $(`input[name="items[${itemId}][dropoff_date]"]`).val();
            
            // Clear any existing validation errors
            $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).next('.text-danger').remove();
            
            if (pickupDate && dropoffDate) {
                if (new Date(pickupDate) > new Date(dropoffDate)) {
                    // Show validation error
                    const errorDiv = $('<div class="text-danger">Dropoff date must be after pickup date</div>');
                    $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).after(errorDiv);
                }
            }
        }
        
        // Initialize time slots for existing dates on page load
        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($item->pickup_date): ?>
                loadTimeSlots("<?php echo e($item->id); ?>", "<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('Y-m-d')); ?>", true);
            <?php endif; ?>
            <?php if($item->dropoff_date): ?>
                loadTimeSlots("<?php echo e($item->id); ?>", "<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('Y-m-d')); ?>", false);
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
    
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/booking/edit_booking_detail.blade.php ENDPATH**/ ?>