<?php $__env->startSection('content'); ?>

<div class="col-9 main-dash-left sora-font">
    <div class="analytics">
        <div class="name-head">
            <h2>SPO Analytics</h2>
            <div class="d-flex comm_head_top_right">
            <div class="sownload-cv-pdf">
                <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
                <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
            </div>
            <select class="form-select select-main-head" aria-label="Default select example" id="timeFilter">
                <option value="year" <?php echo e(request('time_filter', 'year') == 'year' ? 'selected' : ''); ?>>Year</option>
                <option value="month" <?php echo e(request('time_filter') == 'month' ? 'selected' : ''); ?>>Month</option>
                <option value="week" <?php echo e(request('time_filter') == 'week' ? 'selected' : ''); ?>>Week</option>
                <option value="day" <?php echo e(request('time_filter') == 'day' ? 'selected' : ''); ?>>Day</option>
            </select>
        </div>
        </div>
       
       
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/total.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total SPOs</p>
                                    <h4><?php echo e($analytics['total_users']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/green-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>FullTimer</p>
                                    <h4><?php echo e($analytics['fulltimer']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/top.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Side Business</p>
                                    <h4><?php echo e($analytics['sidebusiness']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Active SPO</p>
                                    <h4><?php echo e($analytics['active']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form id="exportForm" method="GET" action="<?php echo e(route('admin.spo.download.csv')); ?>" style="display: none;">
                <input type="hidden" name="search" id="exportSearch">
                <input type="hidden" name="sort_by" id="exportSort">
                <input type="hidden" name="time_filter" id="exportTimeFilter">
            </form>
        </div>
        
        
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>SPO Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For SPO" type="text" id="searchUser" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="sortFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-sort"></i>
                                <?php echo e(request('sort_by') == 'asc' ? 'Oldest' : 'Newest'); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="sortFilterDropdown">
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'desc' ? 'active' : ''); ?>" href="#" data-value="desc">Newest</a></li>
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'asc' ? 'active' : ''); ?>" href="#" data-value="asc">Oldest</a></li>
                            </ul>
                        </div>
                    </div>
                    <form id="sortForm" method="GET">
                        <input type="hidden" name="sort_by" id="sortInput" value="<?php echo e(request('sort_by', 'desc')); ?>">
                    </form>
                    <a class="add-notification-btn" href="<?php echo e(route('admin.spo.create')); ?>">Add New SPO</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>SPO ID</th>
                            <th>SPO Name</th>
                            <th>City</th>
                            <th>Phone Number</th>
                            <th>Business Type </th>
                            <th>Business Model</th>
                            <th>Size Of Location</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="userResults">
                        <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>#<?php echo e($vendor->id); ?></td>
                            <td><?php echo e($vendor->first_name . ' ' . $vendor->last_name); ?></td>
                            <td><?php echo e($vendor->city); ?></td>
                            <td><?php echo e($vendor->country_code . ' ' . $vendor->number); ?></td>
                            <td><?php echo e($vendor->business_type); ?></td>
                            <td><?php echo e($vendor->business_model); ?></td>
                            <td><?php echo e($vendor->size_of_location); ?></td>
                            <td>
                                <select class="form-select select-active-block"
                                    onchange="openStatusChangeModal('<?php echo e($vendor->id); ?>', this.value, this)"
                                    data-current-status="<?php echo e($vendor->status == 'active' ? 'Active' : 'Blocked'); ?>"
                                >
                                    <option data-status='Active' class="active-op" value="Active" <?php echo e($vendor->status == 'active' ? 'selected' : ''); ?>>Active</option>
                                    <option class="block-op" data-status='Blocked' value="Blocked" <?php echo e($vendor->status == 'inactive' ? 'selected' : ''); ?>>Blocked</option>
                                </select>
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="<?php echo e(route('admin.spo.show', $vendor)); ?>">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="<?php echo e(route('admin.spo.edit', $vendor)); ?>">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                   
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($vendors->links()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" class="comn-modal-btns-transparent btn btn-primary" data-bs-dismiss="modal" onclick="resetStatusSelect()">No</button>
                        <form id="status-change-form" method="POST" action="<?php echo e(route('admin.spo.status')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="user-id">
                            <input type="hidden" name="new_status" id="new-status">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade modal-delete-logout" id="deleteuser" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this SPO?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST" action="<?php echo e(route('admin.spo.destroy')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="delete-user-id">
                            <button type="submit" class="comn-modal-btns-blue btn btn-danger">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).ready(function() {
        document.getElementById('timeFilter').addEventListener('change', function() {
            const timeFilter = this.value;
            const url = new URL(window.location.href);
            url.searchParams.set('time_filter', timeFilter);
            window.location.href = url.toString();
        });
    });

    document.querySelectorAll('.sort-option').forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const sortValue = this.getAttribute('data-value');
            document.getElementById('sortInput').value = sortValue;
            document.getElementById('sortForm').submit();
        });
    });
    
    let statusSelectEl = null;
    
    function openStatusChangeModal(userId, newStatus, selectEl) {
        statusSelectEl = selectEl;
        const statusText = newStatus === 'Active'
            ? 'Are you sure you want to activate this SPO?'
            : 'Are you sure you want to block this SPO?';

        document.getElementById('status-text').innerText = statusText;
        document.getElementById('user-id').value = userId;
        document.getElementById('new-status').value = newStatus;

        const modal = new bootstrap.Modal(document.getElementById('changestatus'));
        modal.show();
    }

    function resetStatusSelect() {
        if (statusSelectEl) {
            const current = statusSelectEl.getAttribute('data-current-status');
            statusSelectEl.value = current;
        }
    }

    function openDeleteModal(userId) {
        document.getElementById('delete-user-id').value = userId;
        const modal = new bootstrap.Modal(document.getElementById('deleteuser'));
        modal.show();
    }

    $(document).ready(function() {
        $('#searchUser').on('keyup', function() {
            let searchQuery = $(this).val().toLowerCase();  
            $('.download-pdf, .download-csv').each(function() {
                let href = $(this).attr('href').split('?')[0];
                $(this).attr('href', href + '?search=' + encodeURIComponent(searchQuery));
            });
            
            $('#userResults tr').each(function() {  
                let rowText = $(this).text().toLowerCase();  
                $(this).toggle(rowText.indexOf(searchQuery) > -1);
            });
        });
    });
    
    function exportData(type) {
        $('#exportSearch').val($('#searchUser').val());
        $('#exportSort').val("<?php echo e(request('sort_by', 'desc')); ?>");
        $('#exportTimeFilter').val($('#timeFilter').val());
        
        let action = type === 'csv' 
            ? "<?php echo e(route('admin.spo.download.csv')); ?>" 
            : "<?php echo e(route('admin.spo.download.pdf')); ?>";
        $('#exportForm').attr('action', action);
        $('#exportForm').submit();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/spo/index.blade.php ENDPATH**/ ?>