<?php $__env->startSection('content'); ?>



<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>Commission Analytics</h2>
            <select class="form-select select-main-head" aria-label="Default select example" id="timeFilter">
                <option value="year" <?php echo e(request('time_filter', 'year') == 'year' ? 'selected' : ''); ?>>Year</option>
                <option value="month" <?php echo e(request('time_filter') == 'month' ? 'selected' : ''); ?>>Month</option>
                <option value="week" <?php echo e(request('time_filter') == 'week' ? 'selected' : ''); ?>>Week</option>
                <option value="day" <?php echo e(request('time_filter') == 'day' ? 'selected' : ''); ?>>Day</option>
            </select>
        </div>
       
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/total.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Revenue</p>
                                    <h4><?php echo e(number_format($dashboardAnalytics['total_revenue'] ?? 0, 2, ',', '.')); ?> €</h4>
                                   
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/green-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Commission</p>
                                    <h4><?php echo e(number_format($dashboardAnalytics['total_commission'] ?? 0, 2, ',', '.')); ?> €</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/top.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Commission From Fulltimer</p>
                                    <h4><?php echo e(number_format($dashboardAnalytics['commission_fulltimer'] ?? 0, 2, ',', '.')); ?> €</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/lost.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Commission From Side Business</p>
                                    <h4><?php echo e(number_format($dashboardAnalytics['commission_sidebusiness'] ?? 0, 2, ',', '.')); ?> €</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/parot-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
            <form id="exportForm" method="GET" action="<?php echo e(route('admin.users.download.csv')); ?>" style="display: none;">
    <input type="hidden" name="search" id="exportSearch">
    <input type="hidden" name="sort_by" id="exportSort">
    <input type="hidden" name="time_filter" id="exportTimeFilter">
</form>
        </div>
        <div class="sownload-cv-pdf">
        <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
        <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
        </div>
        
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>Commission Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For User" type="text" id="searchUser" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Sort By:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="sortFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-sort"></i>
                                <?php echo e(request('sort_by') == 'asc' ? 'Oldest' : 'Newest'); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="sortFilterDropdown">
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'desc' ? 'active' : ''); ?>" href="#" data-value="desc">Newest</a></li>
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'asc' ? 'active' : ''); ?>" href="#" data-value="asc">Oldest</a></li>
                            </ul>
                        </div>
                    </div>
                    <form id="sortForm" method="GET">
                        <input type="hidden" name="sort_by" id="sortInput" value="<?php echo e(request('sort_by', 'desc')); ?>">
                    </form>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="usersTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>SPO ID</th>
                            <th>SPO Name</th>
                            <th>email address</th>
                            <th>Business Type</th>
                            <th>Contract</th>
                            <th>Business Model</th>
                            <th>Annual Revenue</th>
                            <th>Annual Commission </th>
                            <th>Action</th>
                            <th>Stop Payout</th>
                        </tr>
                    </thead>
                    <tbody id="userResults">
                        
                            <?php $__currentLoopData = $spos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>

                           <td >
                                #<?php echo e($user->id); ?>

                            </td>
                            <td><?php echo e($user->first_name . ' ' . $user->last_name); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td><?php echo e($user->business_type); ?></td>
                            <td><?php echo e($user->contact_person); ?></td>
                            <td><?php echo e($user->business_model); ?></td>
                            <td><?php echo e(number_format($user->annual_revenue ?? 0, 2, ',', '.')); ?> €</td>
                            <td><?php echo e(number_format($user->annual_commission ?? 0, 2, ',', '.')); ?> €</td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="<?php echo e(route('admin.commission.spo.profile',$user)); ?>">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                   

                                </div>
                            </td>
                            <td>
                                <label class="switch custm_toggle_switch">
                                    <input type="checkbox" class="variant-status-toggle"
                                        data-type="product"
                                        data-variant-id="<?php echo e($user->id); ?>"
                                        <?php echo e($user->stop_payout === 1 ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </td>

                            

                           
                            
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>
<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" class="comn-modal-btns-transparent btn btn-primary" data-bs-dismiss="modal" onclick="resetStatusSelect()">No</button>
                        <form id="status-change-form" method="POST" action="<?php echo e(route('admin.user.status.update')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="user-id">
                            <input type="hidden" name="new_status" id="new-status">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade modal-delete-logout" id="deleteProductModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text" class="mb-3"></h4>
                    <p id="delete-description" class=" mb-0"></p>
                    <div class="upper-btns-modal-pair">
                        <button type="button" id="confirmToggle" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        <button type="button" id="cancelToggle" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



</div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.8.2/jspdf.plugin.autotable.min.js"></script>

<script>

    function exportData(type) {
        let searchQuery = $('#searchUser').val().toLowerCase();
        let sort_by = "<?php echo e(request('sort_by')); ?>";
        let time_filter = $('#timeFilter').val();

        // --- Prepare headers and body from the table ---
        const headers = [];
        $('#usersTable thead th').each(function(index) {
            const text = $(this).text().trim();
            // Skip Action and Stop Payout columns
            if (text !== 'Action' && text !== 'Stop Payout') {
                headers.push(text);
            }
        });

        const body = [];
        $('#usersTable tbody tr').each(function() {
            const row = [];
            $(this).find('td').each(function(index) {
                const thText = $('#usersTable thead th').eq(index).text().trim();
                if (thText !== 'Action' && thText !== 'Stop Payout') {
                    row.push($(this).text().trim());
                }
            });
            // Only include non-empty rows (optional)
            if (row.length) body.push(row);
        });

        if (type === 'pdf') {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF('l', 'pt', 'a4'); // Landscape

            // Add Heading
            doc.setFontSize(16);
            doc.setFont('helvetica', 'bold');
            doc.text('Commission Report', doc.internal.pageSize.getWidth() / 2, 30, { align: 'center' });
            doc.setFontSize(12);
            doc.setFont('helvetica', 'normal');
            doc.text('Generated: ' + new Date().toLocaleDateString(), doc.internal.pageSize.getWidth() / 2, 50, { align: 'center' });

            // Add Table
            doc.autoTable({
                head: [headers],
                body: body,
                startY: 70,
                theme: 'grid',
                headStyles: { 
                    fillColor: [242, 242, 242], 
                    textColor: [0, 0, 0],
                    lineColor: [0,0,0], 
                    lineWidth: 0.5,
                    cellPadding: 6
                },
                styles: {
                    fontSize: 10,
                    textColor: [0,0,0],
                    lineColor: [0,0,0],   
                    lineWidth: 0.5,
                    cellPadding: 6
                },
                tableLineColor: [0,0,0],
                tableLineWidth: 0.5
            });

            doc.save('commission_report.pdf');
        } else if (type === 'csv') {
            // CSV Export
            let csvContent = '';
            csvContent += headers.join(',') + "\n";
            body.forEach(row => {
                csvContent += row.map(item => `"${item.replace(/"/g, '""')}"`).join(',') + "\n";
            });

            const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
            const link = document.createElement("a");
            const url = URL.createObjectURL(blob);
            link.setAttribute("href", url);
            link.setAttribute("download", "commission_report.csv");
            link.style.visibility = 'hidden';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    }
       var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";

    $(document).ready(function() {
    document.getElementById('timeFilter').addEventListener('change', function() {
        const timeFilter = this.value;
        const url = new URL(window.location.href);
        url.searchParams.set('time_filter', timeFilter);
        window.location.href = url.toString();
    });
    $('#usersTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

   

});

    document.querySelectorAll('.variant-status-toggle').forEach(function (toggle) {
        toggle.addEventListener('change', function (e) {
            e.preventDefault(); 
            const checkbox = this;

            checkbox.checked = !checkbox.checked;

            const id = checkbox.dataset.variantId;
            const type = checkbox.dataset.type;
            const isEnabling = !checkbox.checked;
            const status = isEnabling ? 1 : 0;
          

            pendingToggle = { checkbox, id, type, status };

            const heading = isEnabling
                ? `Do you want to start payout for SPOID ${id} ?`
                : `Do you want to stop payout for SPOID ${id} ?`

            

            document.getElementById('delete-text').textContent = heading;

            const modal = new bootstrap.Modal(document.getElementById('deleteProductModal'));
            modal.show();
        });
    });

    document.getElementById('confirmToggle').addEventListener('click', function () {
        if (!pendingToggle) return;

        const { checkbox, id, type, status } = pendingToggle;

        fetch(`${baseUrl}/admin/spo/${id}/status`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                checkbox.checked = (status === 1);
            } else {
                alert('Failed to update status');
            }
        })
        .catch(() => {
            alert('Something went wrong');
        })
        .finally(() => {
            pendingToggle = null;
            location.reload();
            const modalEl = bootstrap.Modal.getInstance(document.getElementById('deleteProductModal'));
            modalEl?.hide();
        });
    });

    document.getElementById('cancelToggle').addEventListener('click', function () {
        pendingToggle = null;
    });
     


   
    document.querySelectorAll('.sort-option').forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const sortValue = this.getAttribute('data-value');
            document.getElementById('sortInput').value = sortValue;
            document.getElementById('sortForm').submit();
        });
    });
    let statusSelectEl = null;
    function openStatusChangeModal(userId, newStatus, selectEl) {
        statusSelectEl = selectEl; // save reference to dropdown

        const statusText = newStatus === 'Active'
            ? 'Are you sure you want to activate this user?'
            : 'Are you sure you want to block this user?';

        document.getElementById('status-text').innerText = statusText;
        document.getElementById('user-id').value = userId;
        document.getElementById('new-status').value = newStatus;

        const modal = new bootstrap.Modal(document.getElementById('changestatus'));
        modal.show();
    }

    function resetStatusSelect() {
        if (statusSelectEl) {
            const current = statusSelectEl.getAttribute('data-current-status');
            statusSelectEl.value = current;
        }
    }

    function openDeleteModal(userId) {
        document.getElementById('delete-user-id').value = userId;

        var myModal = new bootstrap.Modal(document.getElementById('deleteuser'));
        myModal.show();

        $('#delete-user-form').off('submit').on('submit', function (e) {
            e.preventDefault(); 

            var userId = $('#delete-user-id').val();
            var formData = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                user_id: userId
            };

            $.ajax({
                url: "<?php echo e(route('admin.user.delete')); ?>",
                type: 'POST',
                data: formData,
                success: function(response) {
                    myModal.hide();
                    location.reload(); 
                },
                error: function(xhr, status, error) {
                    // On error, show an error message
                    alert('Something went wrong! Please try again later.');
                }
            });
        });
    }

    $(document).ready(function() {
        $('#searchUser').on('keyup', function() {
            let searchQuery = $(this).val().toLowerCase();  
            $('.download-pdf, .download-csv').each(function() {
            let href = $(this).attr('href').split('?')[0];
            $(this).attr('href', href + '?search=' + encodeURIComponent(searchQuery));
        });
          
            $('#usersTable').DataTable().search(this.value).draw();
        });
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/commission/index.blade.php ENDPATH**/ ?>