<?php $__env->startSection('content'); ?>



<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>User Analytics</h2>
            <select class="form-select select-main-head" aria-label="Default select example" id="timeFilter">
                <option value="year" <?php echo e(request('time_filter', 'year') == 'year' ? 'selected' : ''); ?>>Year</option>
                <option value="month" <?php echo e(request('time_filter') == 'month' ? 'selected' : ''); ?>>Month</option>
                <option value="week" <?php echo e(request('time_filter') == 'week' ? 'selected' : ''); ?>>Week</option>
                <option value="day" <?php echo e(request('time_filter') == 'day' ? 'selected' : ''); ?>>Day</option>
            </select>
        </div>
       
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/total.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Total Number of Users</p>
                                    <h4><?php echo e($analytics['total_users']); ?></h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/green-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/return.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>% of Returning Customers (Coming Back Every Year)</p>
                                    <h4><?php echo e($analytics['returning_percentage']); ?>%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/top.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>% of Top Customer (% of Users With More Than 1 Booking/Order Per Year)</p>
                                    <h4><?php echo e($analytics['top_percentage']); ?>%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/lost.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>% of Lost Customer (Customer Who Didn't Come Back The Next Year)</p>
                                    <h4><?php echo e($analytics['lost_percentage']); ?>%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/parot-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form id="exportForm" method="GET" action="<?php echo e(route('admin.users.download.csv')); ?>" style="display: none;">
    <input type="hidden" name="search" id="exportSearch">
    <input type="hidden" name="sort_by" id="exportSort">
    <input type="hidden" name="time_filter" id="exportTimeFilter">
</form>
        </div>
        <div class="sownload-cv-pdf">
        <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
        <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
        </div>
        
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>User Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For User" type="text" id="searchUser" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Sort By:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="sortFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-sort"></i>
                                <?php echo e(request('sort_by') == 'asc' ? 'Oldest' : 'Newest'); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="sortFilterDropdown">
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'desc' ? 'active' : ''); ?>" href="#" data-value="desc">Newest</a></li>
                                <li><a class="dropdown-item sort-option <?php echo e(request('sort_by') == 'asc' ? 'active' : ''); ?>" href="#" data-value="asc">Oldest</a></li>
                            </ul>
                        </div>
                    </div>
                    <form id="sortForm" method="GET">
                        <input type="hidden" name="sort_by" id="sortInput" value="<?php echo e(request('sort_by', 'desc')); ?>">
                    </form>
                    <a class="add-notification-btn" href="<?php echo e(route('admin.add.user.view')); ?>">Add User</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Customer ID</th>
                            <th>Customer Name</th>
                            <th>contact number</th>
                            <th>email address</th>
                            <th>Address Details</th>
                            <th>status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="userResults">
                        
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                            <td>#<?php echo e($user->id); ?></td>
                            <td><?php echo e($user->first_name . ' ' . $user->last_name); ?></td>
                            <td><?php echo e($user->country_code . ' ' . $user->number); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td><?php echo e($user->street.','.$user->zip_code.','.$user->city.','.$user->region); ?></td>
                            <td>
                                <select class="form-select select-active-block"
                                onchange="openStatusChangeModal('<?php echo e($user->id); ?>', this.value, this)"
                                data-current-status="<?php echo e($user->status == 1 ? 'Active' : 'Blocked'); ?>"
                            >
                                <option data-status='Active' class="active-op"  value="Active" <?php echo e($user->status == 1 ? 'selected' : ''); ?>>Active</option>
                                <option class="block-op" data-status='Blocked' value="Blocked" <?php echo e($user->status == 0 ? 'selected' : ''); ?>>Blocked</option>
                            </select>
                            </td>

                           
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="<?php echo e(route('admin.user.profile',$user)); ?>">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="<?php echo e(route('admin.user.edit',$user)); ?>">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                    <a class="delete-btn-eye" href="javascript:void(0);" onclick="openDeleteModal('<?php echo e($user->id); ?>')">
                                        <i class="fa-solid fa-trash"></i>
                                    </a>

                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>
<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" class="comn-modal-btns-transparent btn btn-primary" data-bs-dismiss="modal" onclick="resetStatusSelect()">No</button>
                        <form id="status-change-form" method="POST" action="<?php echo e(route('admin.user.status.update')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="user-id">
                            <input type="hidden" name="new_status" id="new-status">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-delete-logout" id="deleteuser" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this user?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="delete-user-id">
                            <button type="submit" class="comn-modal-btns-blue btn btn-danger">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


</div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
    document.getElementById('timeFilter').addEventListener('change', function() {
        const timeFilter = this.value;
        const url = new URL(window.location.href);
        url.searchParams.set('time_filter', timeFilter);
        window.location.href = url.toString();
    });

});

    //  document.getElementById('sort_filter').addEventListener('change', function(){
    //     this.form.submit();
    // });
    document.querySelectorAll('.sort-option').forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const sortValue = this.getAttribute('data-value');
            document.getElementById('sortInput').value = sortValue;
            document.getElementById('sortForm').submit();
        });
    });
    let statusSelectEl = null;
    function openStatusChangeModal(userId, newStatus, selectEl) {
        statusSelectEl = selectEl; // save reference to dropdown

        const statusText = newStatus === 'Active'
            ? 'Are you sure you want to activate this user?'
            : 'Are you sure you want to block this user?';

        document.getElementById('status-text').innerText = statusText;
        document.getElementById('user-id').value = userId;
        document.getElementById('new-status').value = newStatus;

        const modal = new bootstrap.Modal(document.getElementById('changestatus'));
        modal.show();
    }

    function resetStatusSelect() {
        if (statusSelectEl) {
            const current = statusSelectEl.getAttribute('data-current-status');
            statusSelectEl.value = current;
        }
    }

    function openDeleteModal(userId) {
        document.getElementById('delete-user-id').value = userId;

        var myModal = new bootstrap.Modal(document.getElementById('deleteuser'));
        myModal.show();

        $('#delete-user-form').off('submit').on('submit', function (e) {
            e.preventDefault(); 

            var userId = $('#delete-user-id').val();
            var formData = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                user_id: userId
            };

            $.ajax({
                url: "<?php echo e(route('admin.user.delete')); ?>",
                type: 'POST',
                data: formData,
                success: function(response) {
                    myModal.hide();
                    location.reload(); 
                },
                error: function(xhr, status, error) {
                    // On error, show an error message
                    alert('Something went wrong! Please try again later.');
                }
            });
        });
    }

    $(document).ready(function() {
        $('#searchUser').on('keyup', function() {
            let searchQuery = $(this).val().toLowerCase();  
            $('.download-pdf, .download-csv').each(function() {
            let href = $(this).attr('href').split('?')[0];
            $(this).attr('href', href + '?search=' + encodeURIComponent(searchQuery));
        });
            $('#userResults tr').each(function() {  
                let rowText = $(this).text().toLowerCase();  
                if (rowText.indexOf(searchQuery) === -1) {  
                    $(this).hide();
                } else {
                    $(this).show();  
                }
            });
        });
    });
    function exportData(type) {
    // Get current filter values
   let sort_by = "<?php echo e(request('sort_by')); ?>";
    $('#exportSearch').val($('#searchUser').val());
    $('#exportSort').val(sort_by);
    $('#exportTimeFilter').val($('#timeFilter').val());
    
    // Set the correct action URL
    let action = type === 'csv' 
        ? "<?php echo e(route('admin.users.download.csv')); ?>" 
        : "<?php echo e(route('admin.users.download.pdf')); ?>";
    $('#exportForm').attr('action', action);
    
    // Submit the form
    $('#exportForm').submit();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/user/index.blade.php ENDPATH**/ ?>