<?php $__env->startSection('content'); ?>
    <main>
        <div class="navigation-main">
            <div class="container">
                <div class="navigat">
                    <a href="<?php echo e(route('home')); ?>">Home</a>
                    <a href="<?php echo e(route('product')); ?>">Products</a>
                    <a class="prod-name active" href="">Rental Cart</a>
                </div>
            </div>
        </div>

        <section class="detail-show-all comn-padd-100">
            <div class="container">
                <h3 class="sub_heading_16">Rent Cart</h3>

                <div class="row row-gap-3 rent_cart_page_row">
                    <div class="col-lg-9">
                        <?php if($cartItems->isEmpty()): ?>
                            <div class="alert alert-info">
                                Your cart is empty. <a href="<?php echo e(route('product')); ?>">Browse products</a> to add items.
                            </div>
                        <?php else: ?>
                        <?php
        $firstItem = $cartItems->first();
    ?>
    <input type="hidden" id="cart_userId" value="<?php echo e($firstItem->user_id); ?>">
                            <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="comm_border_box_outer mb-4">
                                    <div class="comm_border_box">
                                        <div class="comm_booking_detail_col">
                                            <div class="d-flex comm_product_cstom_row">
                                                <figure class="booking-dt-img">
                                                    <img src="<?php echo e($item->product->images->first() ? asset('storage/' . $item->product->images->where('type','main')->first()->image_path) : asset('frontend/images/placeholder.jpg')); ?>"
                                                        alt="<?php echo e($item->product_name); ?>" class="img-fluid" />
                                                </figure>
                                                <div class="booking_cs_detail">
                                                    <h3 class="name"><?php echo e($item->product_name); ?></h3>
                                                    <div class="d-flex book_loctn_wrap">
                                                        <i class="fa-solid fa-location-dot"></i>
                                                        <p>Esperantostr. 10, 70197 Stuttgart</p>
                                                    </div>
                                                   
                                                </div>
                                                <button class="btn btn-sm btn-danger remove-item"
                                                data-id="<?php echo e($item->id); ?>">X</button>


                                                <?php if($item->coupon_code): ?>
                                                




                                                <div class="comm_border_box_outer main-product-vouch" bis_skin_checked="1">

                                                    <div class="d-flex voucher_coupan_row" bis_skin_checked="1">
                                                        <div class="d-flex coupon_management_outer  " bis_skin_checked="1">
                                                            <button class="btn-remove-coupon remove-coupon-btn" data-item_id="<?php echo e($item->id); ?>"
                                                                title="Remove coupon">
                                                                <i class="fas fa-times ms-2"></i>
                                                            </button>
                                                            <figure class="coupon_manage_shape">
                                                                <img src="http://127.0.0.1:8000/frontend/images/coup_shape.png"
                                                                    alt="" class="img-fluid">
                                                            </figure>
                                                            <figure class="coupon_management_img">
                                                                <img src="http://127.0.0.1:8000/frontend/images/coup-left.png"
                                                                    alt="" class="img-fluid">
                                                            </figure>
                                                            <div class="coupon_mange_content">

                                                                <h5 class="coupon_txt">
                                                                    Coupon Applied: <?php echo e(strtoupper(trim($item->coupon_code, '[]" '))); ?>

                                                                </h5>

                                                                <h6 class="valid text-success">
                                                                    
                                                                    - <?php echo e(number_format($item->discount, 2, ',', '')); ?> € </h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>


                                            </div>
                                           
                                            <div class="comm_renting_dt_row_outer">
                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">car information:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>Brand: </h5>
                                                            <h6><?php echo e($item->car_name ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>Model:</h5>
                                                            <h6><?php echo e($item->model ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>Year:</h5>
                                                            <h6><?php echo e($item->car_year ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>railing type:</h5>
                                                            <h6><?php echo e($item->roof_type ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>trailer hitch:</h5>
                                                            <h6><?php echo e($item->trailer_hitch ? 'Yes' : 'No'); ?></h6>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">renting details:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>from:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?>

                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>to:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?>

                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>pickup date & time:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?>

                                                                |
                                                                <?php echo e($item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('h:i A') : 'Not set'); ?>

                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>dropoff date & time:</h5>
                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?>

                                                                |
                                                                <?php echo e($item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('h:i A') : 'Not set'); ?>

                                                            </h6>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">rent information:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                        <h5>Quanity:</h5>
                                                            <h6>01</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>Rental days:</h5>
                                                            <h6><?php echo e($item->days); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>for <?php echo e($item->days); ?> days:</h5>
                                                            <h6>Total <?php echo e(number_format($item->calculated_rent, 2)); ?>€</h6>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="booking_modal_carrier_sec">
                                                <?php if($item->is_carrier_included): ?>
                                                    <div class="d-flex booking_modal_carrier_row">
                                                        <div class="cr_box"></div>
                                                        <h6>Carrier Included</h6>
                                                    </div>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>length:</h5>
                                                            <h6><?php echo e($item->carrier_length ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>Foot kit:</h5>
                                                            <h6><?php echo e($item->footkit_sku ?? 'N/A'); ?></h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>Foot:</h5>
                                                            <h6><?php echo e($item->foot_sku ?? 'N/A'); ?></h6>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if($item->is_insured): ?>
                                                    <div class="d-flex booking_modal_carrier_row vkassko_rw">
                                                        <div class="cr_box"></div>
                                                        <h6>Volkassko Insurance 25 €</h6>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="have_coupon_sec">
                                <div class="sub_heading_16">Have a coupon?</div>
                                <div class="inner-main-input inner-main-input2">
                                    <label for="contact-number" class="form-label">Add your coupon Here</label>

                                    <!-- Initially hidden applied coupon section -->
                                    <div id="applied_coupon_section" class="applied-coupon-wrap mb-3"
                                        style="display: none;">
                                        <div class="d-flex align-items-center justify-content-between bg-light p-2 rounded">
                                            <span class="applied-coupon-code font-weight-bold"></span>
                                            <button class="btn btn-sm btn-outline-danger remove-coupon-btn">Remove</button>
                                        </div>
                                    </div>

                                    <div class="d-flex coupn_input_wrap">
                                        <input type="text" class="form-control" placeholder="Enter code Here"
                                            id="coupon_code">
                                        <button class="btn primary-btn primary-btn2" id="apply_coupon">Apply</button>
                                    </div>
                                    <div id="coupon_message" class="mt-2"></div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if(!$cartItems->isEmpty()): ?>
                        <div class="col-lg-3">
                            <div class="cart_total_right_col">
                                <div class="sub_heading_18">Cart Totals</div>
                                <div class="d-flex comm_detail_list_view cart_total_list">
                                    <div class="comm_detail_list_col">
                                        <h5>Subtotal</h5>
                                        <h6 id="cart_sub_total"><?php echo e(number_format($subtotal, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>Discount</h5>
                                        <h6><?php echo e(number_format($discount, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>Net Price</h5>
                                        <h6><?php echo e(number_format($netPrice, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>Net Price Insurance</h5>
                                        <h6><?php echo e(number_format($insuranceTotal, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>Tax (19%)</h5>
                                        <h6><?php echo e(number_format($tax, 2, ',', '')); ?> €</h6>
                                    </div>
                                    <div class="comm_detail_list_col bott_total_row">
                                        <h5>Total</h5>
                                        <h6><?php echo e(number_format($total, 2, ',', '')); ?> €</h6>
                                    </div>
                                </div>

                                <div class="d-flex flex-column gap-4 mt-4">
                                    <div class="d-flex form-check">
                                        <input class="form-check-input" type="checkbox" id="terms_checkbox">
                                        <label class="form-check-label" for="terms_checkbox">
                                            <p class="default_text">I do accept the terms & conditions and the cancellation
                                                rules.</p>
                                        </label>
                                    </div>
                                    <div class="d-flex form-check">
                                        <input class="form-check-input" type="checkbox" id="marketing_checkbox">
                                        <label class="form-check-label" for="marketing_checkbox">
                                            <p class="default_text">I agree to receive electronic messages from Dachboxit
                                                about product and service offers. I can revoke this consent at any time by
                                                unsubscribing.</p>
                                        </label>
                                    </div>
                                </div>

                                <a href="<?php echo e(route('user.checkout.index')); ?>" id="checkout_btn"
                                    class="btn primary-btn primary-btn2 w-100 mt-3 disabled <?php echo e($cartItems->isEmpty() ? 'disabled' : ''); ?>">
                                    Checkout
                                </a>



                                <a href="<?php echo e(route('product')); ?>" class="default_text cart_back_rent_btn">
                                    <img src="<?php echo e(asset('frontend/images/back-rent.png')); ?>" alt=""
                                        class="back_rent img-fluid" />
                                    Add more rental Products
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    </main>
    <div class="modal fade comm-modal " id="removeItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-body text-center">
                <h4 class="mb-4 modal_heading">Are you sure you want to remove this item from your cart?</h4>
                <input type="hidden" id="remove-item-id" />
                <div class="d-flex justify-content-center gap-3">
              

                <div class="modal_two_btns d-flex justify-content-center">
                       <button type="button" class="primary-outline-btn" data-bs-dismiss="modal">No</button>
                <button type="button" class="primary-btn comn-btn-logout" id="confirm-remove-item">Yes</button>

                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            let selectedItemId = null;

            $('.remove-item').click(function (e) {
                e.preventDefault();
                selectedItemId = $(this).data('id'); // Store item ID
                $('#remove-item-id').val(selectedItemId);
                $('#removeItemModal').modal('show'); // Show confirmation modal
            });

            $('#confirm-remove-item').click(function () {
                const itemId = $('#remove-item-id').val();
                $.ajax({
                    url: '<?php echo e(route('cart.remove')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        item_id: itemId
                    },
                    success: function (response) {
                        if (response.success) {
                            $('#removeItemModal').modal('hide');
                            window.location.reload();
                        }
                    },
                    error: function () {
                        alert('Error removing item. Please try again.');
                    }
                });
            });
            $('#apply_coupon').click(function() {
                var couponCode = $('#coupon_code').val().trim();
                var userId = $('#cart_userId').val();
                var subTotal = $('#cart_sub_total').text().replace(' €', '').replace(',', '.');

                if (!couponCode) {
                    Swal.fire({
                                icon: 'warning',
                                title: 'Error',
                                text: 'Please enter a coupon code',
                                confirmButtonColor: '#5BC0DE',
                            });
                    // $('#coupon_message').html(
                    //     '<div class="alert alert-danger">Please enter a coupon code</div>');
                    return;
                }

                $.ajax({
                    url: '<?php echo e(route('cart.apply_coupon')); ?>',
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        coupon_code: couponCode,
                        user_id: userId,
                        sub_total: subTotal,
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            // Show success message
                            // $('#coupon_message').html('<div class="alert alert-success">' +
                            //     response.message + '</div>');

                            // Hide input and show applied coupon
                            $('.coupn_input_wrap').hide();
                            // $('#applied_coupon_section').show();
                            $('.applied-coupon-code').text(couponCode);

                            // Update cart totals
                            if (response.discount) {
                                $('.discount-amount').text('-$' + response.discount.toFixed(2));
                                $('.total-amount').text('$' + response.new_total.toFixed(2));
                            }
                            Swal.fire({
                                icon: 'success',
                                title: 'Success',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            });
                            // window.location.reload()
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            })
                            // $('#coupon_message').html('<div class="alert alert-danger">' +
                            //     response.message + '</div>');

                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'An error occurred. Please try again.',
                                confirmButtonColor: '#5BC0DE',
                            })
                        // $('#coupon_message').html(
                        //     '<div class="alert alert-danger">An error occurred. Please try again.</div>'
                        // );
                    }
                });
            });

            // Remove coupon handler
            $(document).on('click', '.remove-coupon-btn', function() {
    // Store the button element in case we need it later
    var $removeButton = $(this);
    
    Swal.fire({
        title: 'Remove Coupon?',
        text: "Are you sure you want to remove this coupon?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#5BC0DE',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, remove it!',
        cancelButtonText: 'No, keep it'
    }).then((result) => {
        if (result.isConfirmed) {
            // User confirmed - proceed with removal
            var userId = $('#cart_userId').val();
            var itemId = $removeButton.data('item_id');

            // Show loading state
            $removeButton.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Removing...');

            $.ajax({
                url: '<?php echo e(route("cart.remove_single_coupon")); ?>', // Make sure this route is correct
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    user_id: userId,
                    item_id: itemId,
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response.message,
                            confirmButtonColor: '#5BC0DE',
                        }).then(() => {
                            // Refresh the page or update UI as needed
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: response.message,
                            confirmButtonColor: '#5BC0DE',
                        });
                        $removeButton.prop('disabled', false).html('Remove');
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred. Please try again.',
                        confirmButtonColor: '#5BC0DE',
                    });
                    $removeButton.prop('disabled', false).html('Remove');
                }
            });
        }
    });
});

            $('#terms_checkbox').change(function() {
                if ($(this).is(':checked')) {
                    $('#checkout_btn').removeClass('disabled');
                } else {
                    $('#checkout_btn').addClass('disabled');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/cart/index.blade.php ENDPATH**/ ?>