<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo app('translator')->get('messages.invoice_email.title'); ?></title>
</head>

<body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color:#ffffff;">
    <table align="center" width="100%" cellpadding="0" cellspacing="0" border="0" style="max-width:700px;">
        <!-- Email Banner -->
         <tr>
            <td align="center" valign="top">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" valign="top" style=" width:100%; height:60px;">
                    
                    <!-- Spacer to push logo down -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" height="27">
                      <tr>
                        <td></td>
                      </tr>
                    </table>

                    <!-- Logo -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td align="center">
                          <img src="<?php echo e(asset('frontend/images/logo.png')); ?>" width="240" style="max-width:240px; width:100%; display:block; border:0;" alt="Logo">
                        </td>
                      </tr>
                    </table>

                  </td>
                </tr>
              </table>
            </td>
          </tr>

        <!-- Email Body -->
        <tr>
            <td style="padding:50px 30px; font-family:Arial, sans-serif;">
                <h2 style="font-family:Arial, sans-serif; font-weight:700; font-size:24px; line-height:100%; text-align:center; margin:0;">
                    <?php echo app('translator')->get('messages.invoice_email.booking_invoice'); ?>
                </h2>
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; text-align:center; margin:30px 0 30px 0; color:#111111;">
                     <?php echo app('translator')->get('messages.invoice_email.dear', ['name' => $recipient['name']]); ?><br>
                     <?php echo app('translator')->get('messages.invoice_email.thank_you_message'); ?></p>

                     
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.invoice_email.customer_details'); ?>:</b>
                </p>
                    <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE;    table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.customer_id'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #<?php echo e(str_pad($userDetails->user_id, 6, '0', STR_PAD_LEFT)); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.customer_name'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($userDetails->first_name); ?> <?php echo e($userDetails->last_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.address'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($userDetails->address); ?>, <br>  <?php echo e($userDetails->zip); ?> <?php echo e($userDetails->city); ?>, <br> <?php echo e($userDetails->country); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.email_address'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($userDetails->email); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.phone_number'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($userDetails->phone); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.invoice_number'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($booking->invoice_number); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.invoice_date'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($booking->created_at->format('d.m.Y')); ?>

                        </td>
                    </tr>
                </table>

              <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                  <b><?php echo app('translator')->get('messages.invoice_email.issuer_details'); ?>:</b>
              </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE;    table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            Rerent
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo app('translator')->get('messages.invoice_email.issuer_address'); ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.tax_number'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($issuer['tax_number']); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.vat_id'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($issuer['vat_number']); ?>

                        </td>
                    </tr>
                </table>

                <!-- Booking Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.invoice_email.booking_details'); ?>:</b>
                </p>
                    <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE;    table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.booking_id'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #<?php echo e(str_pad($booking->id, 6, '0', STR_PAD_LEFT)); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.booking_date'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($booking->created_at->format('d.m.Y')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.booking_status'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(ucfirst($booking->status)); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.payment_method'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            
                           <?php echo e(str_contains(strtolower($booking->payment_method), 'card') ? 'Karte' : ucfirst($booking->payment_method)); ?>

                        </td>
                    </tr>
                    <?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!$item->related_item): ?>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.rental_period'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?> - <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.rental_days'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->diffInDays(\Carbon\Carbon::parse($item->dropoff_date))); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.pickup_location'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;"> 


                              <?php echo e($vendor->street ?? $admin->address ?? ''); ?><br>
                            <?php echo e($vendor->zip_code ?? $admin->zip_code ?? ''); ?> <?php echo e($vendor->city ?? $admin->city ?? ''); ?> <br>
                            <?php echo e($vendor->country ?? $admin->state ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.pickup_datetime'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?> | 
                            <?php echo e($item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.dropoff_datetime'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?> | 
                            <?php echo e($item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.carrier_included'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php if($item->is_carrier_included): ?>
                                <?php echo app('translator')->get('messages.invoice_email.length'); ?>: <?php echo e($item->carrier_length ?? 'N/A'); ?><br>
                                <?php echo app('translator')->get('messages.invoice_email.foot_kit'); ?>: <?php echo e($item->carrier_foot_kit ?? 'N/A'); ?><br>
                                <?php echo app('translator')->get('messages.invoice_email.foot'); ?>: <?php echo e($item->carrier_foot ?? 'N/A'); ?>

                            <?php else: ?>
                                <?php echo app('translator')->get('messages.invoice_email.no'); ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.insurance'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($item->is_insured ? __('messages.invoice_email.included') : __('messages.invoice_email.not_included')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.mounting_services'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.included'); ?>
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.cleaning_service'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo app('translator')->get('messages.invoice_email.included'); ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.coupon_discount'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e(number_format($booking->discount ?? 0, 2)); ?>€
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.subtotal'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(number_format($booking->subtotal, 2, ',', '.')); ?> €
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.tax'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e(number_format($booking->tax, 2)); ?>€
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.total'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(number_format($booking->total, 2, ',', '.')); ?> €
                        </td>
                    </tr>
                </table>

                <!-- Product Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.invoice_email.product_details'); ?>:</b>
                </p>
                    <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE;    table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!$item->related_item): ?>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.product_id'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #<?php echo e(str_pad($item->product_id, 6, '0', STR_PAD_LEFT)); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.product_name'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($item->product_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.quantity'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            1
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.size_variation'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($item->size); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.color'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($item->color); ?>

                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>

                <!-- Car Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.invoice_email.car_details'); ?>:</b>
                </p>
                    <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE;    table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!$item->related_item): ?>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.brand'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($item->car_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.year'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($item->car_year); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.model'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($item->model); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.invoice_email.trailer_hitch'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($item->trailer_hitch ? __('messages.invoice_email.yes') : __('messages.invoice_email.no')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.invoice_email.roof_type'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($item->roof_type); ?>

                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>

                <!-- Closing Paragraph -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#000000; margin-top:30px;">
                    <?php echo app('translator')->get('messages.invoice_email.closing_message'); ?><br><br>
                    <?php echo app('translator')->get('messages.invoice_email.best_regards'); ?><br>
                    <?php echo app('translator')->get('messages.invoice_email.team_signature'); ?>
                </p>
            </td>
        </tr>

        <!-- Footer -->
        <tr>
            <td bgcolor="#111111" style="padding:31px 45px 0px 45px; border-bottom:unset;" align="center">
                <img src="<?php echo e(asset('frontend/images/logo.png')); ?>" alt="" width="220" style="display:block; margin:0 auto;">
               

                <!-- Social Section -->
                <table border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0;">
                            <img src="<?php echo e(asset('frontend/images/Message.png')); ?>" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">cs@dachboxit.de</p>
                        </td>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0; ">
                            <img src="<?php echo e(asset('frontend/images/Mobile.png')); ?>" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">+4915172876293</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">
                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin: 0px 0 20px 0;">
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/gdpr" style="color:#ffffff; text-decoration:none; margin:15px 5px;">
                        <?php echo e(__('messages.payment_link_email.privacy_policy')); ?>

                    </a>
                    |
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/term-condition" style="color:#ffffff; text-decoration:none; margin:0 5px;">
                        <?php echo e(__('messages.payment_link_email.terms_conditions')); ?>

                    </a>
                </p>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">

                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:0;">
                    Rerent Esperantostrasse 10, 70197 Stuttgart, Deutschland<br>Usatzsteuer-ID: DE300067568
                </p>
            </td>

        </tr>
        <!-- Copyright -->
        <tr>
            <td bgcolor="#111111" style="padding:15px 30px; text-align:center;">
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:14px; line-height:24px; color:#fff; margin:0;">
                    <?php echo app('translator')->get('messages.invoice_email.copyright', ['year' => date('Y')]); ?>
                </p>
            </td>
        </tr>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/email/invoice.blade.php ENDPATH**/ ?>