<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>Color Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <a class="add-notification-btn" href="<?php echo e(route('admin.color.add.view')); ?>">Add Color</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>No.</th>
                            <th>Color Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($val->name); ?></td>
                                <td>
                                    <div class="upper-delete-btns d-flex">
                                        <a class="edit-btn-eye" href="<?php echo e(route('admin.color.edit.view', $val->slug)); ?>">
                                            <i class="fa-solid fa-pen-to-square"></i>
                                        </a>
                                        <a class="delete-btn-eye" href="javascript:void(0);" onclick="openDeleteModal('<?php echo e($val->slug); ?>')">
                                            <i class="fa-solid fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($colors->isEmpty()): ?>
                            <tr><td colspan="3">No colors found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade modal-delete-logout" id="deleteuser" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this color?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="slug" id="delete-user-id">
                            <button type="submit" class="comn-modal-btns-blue btn btn-danger">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function openDeleteModal(slug) {
    document.getElementById('delete-user-id').value = slug;

    var myModal = new bootstrap.Modal(document.getElementById('deleteuser'));
    myModal.show();

    $('#delete-user-form').off('submit').on('submit', function (e) {
        e.preventDefault();

        var slug = $('#delete-user-id').val();
        var formData = {
            _token: $('meta[name="csrf-token"]').attr('content'),
            slug: slug
        };

        $.ajax({
            url: "<?php echo e(route('admin.color.delete')); ?>",
            type: 'POST',
            data: formData,
            success: function(response) {
                myModal.hide();
                location.reload();
            },
            error: function() {
                alert('Something went wrong! Please try again.');
            }
        });
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/color/index.blade.php ENDPATH**/ ?>