<?php $__env->startSection('content'); ?>

<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1><?php echo e(__('messages.my_appointment')); ?></h1>
                </div>
            </div>
        </div>
    </section>
    

    <div class="prof-main">
        <section class="comn-padd">
            <div class="container">
                <div class="inner-acount">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="inner-left-tabs">
                                <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <section id="my_booking_page">
                                <div class="comm_border_box_outer">
                                    <div class="comm_border_box">
                                        <h3 class="main-head-pro"><?php echo e(__('messages.my_appointment')); ?></h3>
                            
                                        <?php if(count($recentBookings) > 0): ?>
                                            <div class="comm_booking_head">
                                                <h6><?php echo e(__('messages.recent_appointments')); ?></h6>
                                            </div>
                                            <div class="comm_booking_detail_row">
                                                <?php $__currentLoopData = $recentBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="d-flex comm_booking_detail_col">
                                                            <div class="d-flex comm_detail_inner_row">
                                                                <div class="d-flex book-dt-left comm_product_cstom_row">
                                                                    <figure class="booking-dt-img">
                                                                        <img src="<?php echo e(asset('frontend/images/roof1.png')); ?>" alt="" class="img-fluid" />
                                                                    </figure>
                                                                    <div class="booking_cs_detail">
                                                                        <h3 class="name">THULE <?php echo e($item->product_name); ?> | <?php echo e($item->size); ?></h3>
                                                                        <h6 class="book_id_txt"><?php echo e(__('messages.booking_id')); ?>: <span><?php echo e($booking->id); ?></span></h6>
                                                                        <div class="d-flex book_loctn_wrap">
                                                                            <i class="fa-solid fa-location-dot"></i>
                                                                            <p>Esperantostr. 10, 70197 Stuttgart</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <button class="primary-btn show-more" data-booking-id="<?php echo e($booking->id); ?>" data-item-id="<?php echo e($item->id); ?>" data-bs-toggle="modal">
                                                                    <?php echo e(__('messages.show_more')); ?>

                                                                </button>
                                                            </div>
                                                            <div class="comm_renting_dt_row">
                                                                <h3 class="rnt_head"><?php echo e(__('messages.renting_details')); ?></h3>
                                                                <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                                    <div class="comm_detail_list_col">
                                                                        <h5><?php echo e(__('messages.from')); ?></h5>
                                                                        <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?></h6>
                                                                    </div>
                                                                    <div class="comm_detail_list_col">
                                                                        <h5><?php echo e(__('messages.to')); ?></h5>
                                                                        <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?></h6>
                                                                    </div>
                                                                    <div class="comm_detail_list_col">
                                                                        <h5><?php echo e(__('messages.pickup_datetime')); ?></h5>
                                                                        <h6>
                                                                            <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?> |
                                                                            <?php echo e(\Carbon\Carbon::parse($item->pickup_time)->format('h:i A')); ?>

                                                                        </h6>
                                                                    </div>
                                                                    <div class="comm_detail_list_col">
                                                                        <h5><?php echo e(__('messages.dropoff_datetime')); ?></h5>
                                                                        <h6>
                                                                            <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?> |
                                                                            <?php echo e(\Carbon\Carbon::parse($item->dropoff_time)->format('h:i A')); ?>

                                                                        </h6>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                            
                                        <?php if(count($pastBookings) > 0): ?>
                                            <div class="past_booking_wrap">
                                                <div class="comm_booking_head">
                                                    <h6><?php echo e(__('messages.past_appointments')); ?></h6>
                                                </div>
                                                <div class="comm_booking_detail_row">
                                                    <?php $__currentLoopData = $pastBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="d-flex comm_booking_detail_col">
                                                                <div class="d-flex comm_detail_inner_row">
                                                                    <div class="d-flex book-dt-left comm_product_cstom_row">
                                                                        <figure class="booking-dt-img">
                                                                            <img src="<?php echo e(asset('frontend/images/roof1.png')); ?>" alt="" class="img-fluid" />
                                                                        </figure>
                                                                        <div class="booking_cs_detail">
                                                                            <h3 class="name"><?php echo e($item->product_name); ?> | <?php echo e($item->size); ?></h3>
                                                                            <h6 class="book_id_txt"><?php echo e(__('messages.booking_id')); ?>: <span><?php echo e($booking->id); ?></span></h6>
                                                                            <div class="d-flex book_loctn_wrap">
                                                                                <i class="fa-solid fa-location-dot"></i>
                                                                                <p><?php echo e($booking->userDetails->address ?? ''); ?>, <?php echo e($booking->userDetails->zip ?? ''); ?> <?php echo e($booking->userDetails->city ?? ''); ?>, <?php echo e($booking->userDetails->country ?? ''); ?></p>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <button class="primary-btn show-more" data-booking-id="<?php echo e($booking->id); ?>" data-item-id="<?php echo e($item->id); ?>" data-bs-toggle="modal" disabled>
                                                                        <?php echo e(__('messages.show_more')); ?>

                                                                    </button>
                                                                </div>
                                                                <div class="comm_renting_dt_row">
                                                                    <h3 class="rnt_head"><?php echo e(__('messages.renting_details')); ?></h3>
                                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                                        <div class="comm_detail_list_col">
                                                                            <h5><?php echo e(__('messages.from')); ?></h5>
                                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?></h6>
                                                                        </div>
                                                                        <div class="comm_detail_list_col">
                                                                            <h5><?php echo e(__('messages.to')); ?></h5>
                                                                            <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?></h6>
                                                                        </div>
                                                                        <div class="comm_detail_list_col">
                                                                            <h5><?php echo e(__('messages.pickup_datetime')); ?></h5>
                                                                            <h6>
                                                                                <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?> |
                                                                                <?php echo e(\Carbon\Carbon::parse($item->pickup_time)->format('h:i A')); ?>

                                                                            </h6>
                                                                        </div>
                                                                        <div class="comm_detail_list_col">
                                                                            <h5><?php echo e(__('messages.dropoff_datetime')); ?></h5>
                                                                            <h6>
                                                                                <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?> |
                                                                                <?php echo e(\Carbon\Carbon::parse($item->dropoff_time)->format('h:i A')); ?>

                                                                            </h6>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </section>
                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>
<div class="modal fade comm-modal appointment-modal" id="appointmentModal" tabindex="-1" aria-labelledby="appointmentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body p-0">
                <div class="inner-modal-content">
                    
                    <div id="appointmentDetailsContent">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade comm-modal logout-modal" id="confirmChangeModal" tabindex="-1" aria-labelledby="confirmChangeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-modal-content">
                    <h3 class="save-moda-heading"><?php echo e(__('messages.confirm_change_heading')); ?></h3>
                    <div class="inner-main-input mb-0">
                        <label for="changeReason" class="form-label"><?php echo e(__('messages.enter_reason')); ?></label>
                        <textarea class="form-control" placeholder="<?php echo e(__('messages.enter_reason_placeholder')); ?>" id="changeReason" name="changeReason" style="height: 135px"></textarea>
                    </div>
                    <div class="modal_two_btns d-flex justify-content-center">
                        <button type="button" class="primary-outline-btn" data-bs-dismiss="modal"><?php echo e(__('messages.cancel')); ?></button>
                        <button type="button" class="primary-btn comn-btn-logout" id="confirmChangeBtn"><?php echo e(__('messages.yes_change')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Contact Modal -->
<div class="modal fade" id="contactModal" tabindex="-1" aria-labelledby="contactModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="contactModalLabel"><?php echo e(__('messages.contact_modal_title')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('messages.close')); ?>"></button>
            </div>
            <div class="modal-body">
                <form class="row" id="contactForm" method="post" action="<?php echo e(route('contact.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="col-md-12 mb-3">
                        <label for="name" class="form-label"><?php echo e(__('messages.name')); ?></label>
                        <input type="text" name="name" id="name"
                               class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="<?php echo e(__('messages.name_placeholder')); ?>" value="<?php echo e(old('name')); ?>">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="email" class="form-label"><?php echo e(__('messages.email')); ?></label>
                        <input type="text" name="email" id="email"
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="<?php echo e(__('messages.email_placeholder')); ?>" value="<?php echo e(old('email')); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="contact-number" class="form-label"><?php echo e(__('messages.contact_number')); ?></label>
                        <input type="tel" name="number" id="contact-number"
                               class="form-control <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="<?php echo e(__('messages.contact_number_placeholder')); ?>" value="<?php echo e(old('number')); ?>">
                        <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="message" class="form-label"><?php echo e(__('messages.message')); ?></label>
                        <textarea name="message" id="message" style="height: 135px"
                                  class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  placeholder="<?php echo e(__('messages.message_placeholder')); ?>"><?php echo e(old('message')); ?></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <input type="hidden" name="booking_id" id="booking_id" value="">
                    <input type="hidden" name="item_id" id="item_id" value="">

                    <div class="col-12 text-end">
                        <button type="submit" class="btn btn-primary"><?php echo e(__('messages.send_message')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
  

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('contactForm');

    form.addEventListener('submit', function (e) {
        e.preventDefault();
        let isValid = true;

        // Clear old errors
        form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
        form.querySelectorAll('.text-danger.client-error').forEach(el => el.remove());

        const name = form.querySelector('#name');
        const email = form.querySelector('#email');
        const number = form.querySelector('#contact-number');
        const message = form.querySelector('#message');

        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        // Validate Name
        if (!name.value.trim()) {
            showError(name, 'Please enter your name');
            isValid = false;
        }

        // Validate Email
        if (!email.value.trim()) {
            showError(email, 'Please enter your email address');
            isValid = false;
        } else if (!emailPattern.test(email.value.trim())) {
            showError(email, 'Please enter a valid email address');
            isValid = false;
        }

        // Validate Number
        if (!number.value.trim()) {
            showError(number, 'Please enter your contact number');
            isValid = false;
        }

        // Validate Message
        if (!message.value.trim()) {
            showError(message, 'Please enter your query details here (e.g., booking ID, change details)');
            isValid = false;
        }

        if (isValid) {
            form.submit(); // only submit if all valid
        }
    });

    function showError(input, message) {
        input.classList.add('is-invalid');
        const span = document.createElement('span');
        span.classList.add('text-danger', 'client-error');
        span.textContent = message;
        input.insertAdjacentElement('afterend', span);
    }
});
</script>

<script>
    var baseUrl = '';
    $(document).ready(function() {
        let currentBookingId = null;
        let selectedPickupDate = null;
        let selectedDropoffDate = null;
        let selectedPickupTime = null;
        let selectedDropoffTime = null;
        let rentalFrom = null;
        let rentalTo = null;
        let originalPickupTime = null;
        let originalDropOffTime = null;
        
        $('.show-more').click(function() {
            currentBookingId = $(this).data('booking-id');
            currentItemId = $(this).data('item-id');
            $('#booking_id').val(currentBookingId);
            $('#item_id').val(currentItemId);
            
            $.ajax({
                url: `${baseUrl}/user/appointment/` + currentBookingId + '/details/' + currentItemId,
                type: 'GET',
                success: function(response) {
                    $('#appointmentDetailsContent').html(response);
                    $('#appointmentModal').modal('show');
                    
                    $.ajax({
                        url: `${baseUrl}/user/appointment/` + currentBookingId + '/getdetails/' + currentItemId,
                        type: 'GET',
                        success: function(response) {
                            const firstItem = response.booking.items[0];
                            rentalFrom = new Date(firstItem.pickup_date);
                            rentalTo = new Date(firstItem.dropoff_date);
                            originalPickupTime = firstItem.pickup_time;
                            originalDropOffTime = firstItem.dropoff_time

                            selectedPickupDate = rentalFrom;
                            selectedDropoffDate = rentalTo; 

                            rentalFrom.setHours(0, 0, 0, 0);
                            rentalTo.setHours(0, 0, 0, 0);
                            
                            initCalendar();

                            loadTimeSlots(selectedPickupDate, '#from-slots');
                            loadTimeSlots(selectedDropoffDate, '#to-slots');

                            selectedPickupTime = firstItem.pickup_time;
                            selectedDropoffTime = firstItem.dropoff_time;

                            setTimeout(() => {
                                highlightInitialTimeSlots(firstItem.pickup_time, firstItem.dropoff_time);
                            }, 200);
                        },
                        error: function(xhr) {
                            console.error(xhr);
                            alert('Failed to load booking details.');
                        }
                    });
                    
                    
                    initCalendar();
                },
                error: function(xhr) {
                    console.error(xhr);
                    alert('Failed to load booking details.');
                }
            });
        });

        function highlightInitialTimeSlots(pickupTime, dropoffTime) {
                // Format times to match the slot format (e.g., "09:00 - 10:00")
                const formattedPickupTime = formatTimeForSlot(pickupTime);
                const formattedDropoffTime = formatTimeForSlot(dropoffTime);
                
                // Highlight pickup time slot
                $(`#from-slots li`).each(function() {
                    if ($(this).data('time').includes(formattedPickupTime)) {
                        $(this).addClass('active');
                        return false; // break the loop
                    }
                });
                
                // Highlight dropoff time slot
                $(`#to-slots li`).each(function() {
                    if ($(this).data('time').includes(formattedDropoffTime)) {
                        $(this).addClass('active');
                        return false; // break the loop
                    }
                });
            }

        function formatTimeForSlot(timeString) {
        // Convert time string like "09:00:00" to "09:00"
            return timeString.substring(0, 5);
        }
        
        function initCalendar() {
            
            flatpickr("#calendar-box", {
                inline: true,
                mode: "range",
                defaultDate: [rentalFrom, rentalTo],
                disable: [
                    function(date) {
                        return !(date >= rentalFrom && date <= rentalTo);
                    }
                ],
                clickOpens: false,  
                onReady: function() {
                    this.prevMonthNav.style.pointerEvents = 'none';
                    this.nextMonthNav.style.pointerEvents = 'none';
                    this.currentYearElement.style.pointerEvents = 'none';
                    this.monthNav.style.pointerEvents = 'none';
                    
                    this.prevMonthNav.style.opacity = '0.5';
                    this.nextMonthNav.style.opacity = '0.5';
                    this.currentYearElement.style.opacity = '0.5';
                    this.monthNav.style.opacity = '0.5';
                },
                onChange: function(selectedDates, dateStr, instance) {
                }
            });
            flatpickr.localize(flatpickr.l10ns.default);
            flatpickr.l10ns.default.firstDayOfWeek = 1;

            flatpickr("#pickupDate", {
                dateFormat: "d/m/Y",
                defaultDate: rentalFrom,
                minDate: rentalFrom,
                maxDate: rentalFrom,
                clickOpens: false, // Prevents the popup from opening
                onChange: function(selectedDates, dateStr, instance) {
                    selectedPickupDate = selectedDates[0];
                    updateRangeCalendar();
                    loadTimeSlots(selectedPickupDate, '#from-slots');
                }
            });

            flatpickr("#dropoffDate", {
                dateFormat: "d/m/Y",
                defaultDate: rentalTo,
                minDate: rentalTo,
                maxDate: rentalTo,
                clickOpens: false, // Prevents the popup from opening
                onChange: function(selectedDates, dateStr, instance) {
                    selectedDropoffDate = selectedDates[0];
                    updateRangeCalendar();
                    loadTimeSlots(selectedDropoffDate, '#to-slots');
                }
            });
        }
        
        function updateRangeCalendar() {
            if (selectedPickupDate && selectedDropoffDate) {
                $("#calendar-box").flatpickr().destroy();
                
                flatpickr("#calendar-box", {
                    inline: true,
                    mode: "range",
                    defaultDate: [selectedPickupDate, selectedDropoffDate],
                    disable: [
                        function(date) {
                            return !(date >= selectedPickupDate && date <= selectedDropoffDate);
                        }
                    ]
                });
            }
        }
        
        function loadTimeSlots(date, container) {
            const formattedDate = flatpickr.formatDate(date, "Y-m-d");
            
            $.ajax({
                url: `${baseUrl}/user/appointment/get-time`,
                type: 'GET',
                data: {
                    date: formattedDate,
                    container: container
                },
                success: function(response) {
                    updateTimeSlotsUI(response, container);
                },
                error: function(xhr) {
                    console.error(xhr);
                    alert('Failed to load time slots.');
                }
            });
        }
        
        function updateTimeSlotsUI(data, container) {
            let slotsHtml = '';
            
            data.slots.forEach(function(slot) {
                const disabledClass = slot.disabled ? 'disabled' : '';
                slotsHtml += `<li class="${disabledClass}" data-time="${slot.label}">${slot.label}</li>`;
            });
            
            $(container).html(slotsHtml);
            
            $(container + ' li:not(.disabled)').click(function() {
                $(container + ' li').removeClass('active');
                $(this).addClass('active');
                
                if (container === '#from-slots') {
                    selectedPickupTime = $(this).data('time').split(' - ')[0];
                } else {
                    selectedDropoffTime = $(this).data('time').split(' - ')[0];
                }
                
                updateNewSlotPreview();
            });
        }
        
        function updateNewSlotPreview() {
            if (selectedPickupDate && selectedDropoffDate && selectedPickupTime && selectedDropoffTime) {
                const pickupDateFormatted = flatpickr.formatDate(selectedPickupDate, "d/m/Y");
                const dropoffDateFormatted = flatpickr.formatDate(selectedDropoffDate, "d/m/Y");
                
                $('#newSlotPreview').html(`
                    <h3 class="rnt_head">New Slot: <span>booking ID: ${currentBookingId}</span></h3>
                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                        <div class="comm_detail_list_col">
                            <h5>from:</h5>
                            <h6>${pickupDateFormatted}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>to:</h5>
                            <h6>${dropoffDateFormatted}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>pickup date & time:</h5>
                            <h6>${pickupDateFormatted} | ${selectedPickupTime}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>dropoff date & time:</h5>
                            <h6>${dropoffDateFormatted} | ${selectedDropoffTime}</h6>
                        </div>
                    </div>
                `);
                
                $('#saveChangesBtn').prop('disabled', false);
            }
        }
        
        $(document).on('click', '#saveChangesBtn', function() {
            if (!validateDateChange()) {
                return;
            }
            $('#confirmChangeModal').modal('show');
        });


        function validateDateChange() {
            if (!rentalFrom || !originalPickupTime) return true;

            const originalPickupDateTime = new Date(rentalFrom);

            const timeParts = originalPickupTime.split(':');
            if (timeParts.length >= 2) {
                const hours = parseInt(timeParts[0]);
                const minutes = parseInt(timeParts[1]);
                const seconds = timeParts.length > 2 ? parseInt(timeParts[2]) : 0;

                originalPickupDateTime.setHours(hours);
                originalPickupDateTime.setMinutes(minutes);
                originalPickupDateTime.setSeconds(seconds);
                originalPickupDateTime.setMilliseconds(0);
            }

            const now = new Date();
            const hoursDiff = (originalPickupDateTime - now) / (1000 * 60 * 60); 
            if (hoursDiff < 48) {
                    const formattedDate = originalPickupDateTime.toLocaleString();
                    Swal.fire({
                        icon: 'warning',
                        title: 'Change Not Allowed',
                        html: `You cannot change your appointment within <b>48 hours</b> of the original pickup time.<br><br><strong>${formattedDate}</strong><br><br>Please contact customer service.`,
                        confirmButtonText: 'OK'
                    });
                    return false;
                }

            return true;
        }
        $('#confirmChangeBtn').click(function() {
            const reason = $('#changeReason').val();
            
            $.ajax({
                url: `${baseUrl}/user/appointment/` + currentBookingId + '/update/' + currentItemId,
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    pickup_date: flatpickr.formatDate(selectedPickupDate, "Y-m-d"),
                    dropoff_date: flatpickr.formatDate(selectedDropoffDate, "Y-m-d"),
                    pickup_time: selectedPickupTime,
                    dropoff_time: selectedDropoffTime,

                    reason: reason
                },
                success: function(response) {
                    if (response.success) {
                        alert('Appointment updated successfully!');
                        location.reload();
                    } else {
                        alert(response.message || 'Failed to update appointment.');
                    }
                },
                error: function(xhr) {
                    console.error(xhr);
                    alert('Failed to update appointment.');
                }
            });
        });
    });
    </script>
    <style>
    /* Appointment Modal Styles */
.appointment-modal .modal-content {
    padding: 30px;
}
.appointment-modal .modal-dialog{
    max-width: 1200px !important;
}

.available_slots_row {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-top: 15px;
    padding: 0;
    list-style: none;
}

.available_slots_row li {
    padding: 8px 15px;
    background: #f5f5f5;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.available_slots_row li:hover:not(.disabled) {
    background: #e0e0e0;
}
.cst_calender .flatpickr-day {
    pointer-events: none !important;
    cursor: not-allowed !important;
}

.available_slots_row li.active {
    background: var(--primary-color);
    color: white;
}

.available_slots_row li.disabled {
    background: #f5f5f5;
    color: #ccc;
    cursor: not-allowed;
    text-decoration: line-through;
}

#newSlotPreview {
    margin-top: 30px;
    padding: 20px;
    background: #f9f9f9;
    border-radius: 8px;
}

.my_appiont_date_col {
    margin-bottom: 20px;
}

.avail_slots_text {
    font-size: 14px;
    color: #666;
    margin-top: 10px;
}

.date-input {
    cursor: pointer;
}

.cst_calender{
    max-width: 645px;
    margin: auto;
}
.date-input {
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23005b9f' viewBox='0 0 16 16'%3E%3Cpath d='M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 10px center;
    background-size: 16px;
    padding-right: 35px;
}
    </style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/user/appointment/index.blade.php ENDPATH**/ ?>