<?php $__env->startSection('content'); ?>

<style>
    .bg-purple{
        background-color : purple !important;
    }
    .cs-pagination span svg {
        width: 10px;
        height: 10px;
    }
    .bg-pink{
        background-color : #e83e8c !important;
    }
    .bg-darkGreen{
        background-color :rgb(4, 100, 1)
    }
</style>
<div class="col-9 main-dash-left">
    <div class="notification-block">
        <div class="d-flex justify-content-between align-items-center mb-3 noti-inner">
            <h4 class="mb-0"><?php echo app('translator')->get('messages.ui.all_notifications'); ?></h4>
            <?php if($notifications->where('is_read', false)->count() > 0): ?>
                <form action="<?php echo e(route('admin.notifications.read.all')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="noti-btn">
                        <i class="fas fa-check-circle me-1"></i> <?php echo app('translator')->get('messages.ui.mark_all_read'); ?>
                    </button>
                </form>
            <?php endif; ?>
        </div>

        <?php if($notifications->isEmpty()): ?>
            <p class="text-muted"><?php echo app('translator')->get('messages.ui.no_notifications'); ?></p>
        <?php else: ?>
        <div class="mb-3 d-flex justify-content-between align-items-center">
            <div class="d-flex w-100">
                <input type="text" id="searchNotifications" 
                    class="form-control form-control-lg me-3 flex-grow-1"
                    placeholder="<?php echo app('translator')->get('messages.ui.search_placeholder'); ?>">
        
                    <form method="GET" action="<?php echo e(route('admin.notifications.page')); ?>" class="flex-shrink-0" style="min-width: 250px;">
                        <select name="type" class="form-select form-select-lg" onchange="this.form.submit()">
                            <option value=""><?php echo app('translator')->get('messages.ui.filter'); ?></option>
                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $displayType = trans('messages.types.' . $type);
                                // Fallback if translation not found
                                if ($displayType === 'messages.types.' . $type) {
                                    $displayType = str_replace('_', ' ', $type);
                                    $displayType = \Illuminate\Support\Str::title($displayType);
                                    $displayType = preg_replace('/\bSpo\b/', 'SPO', $displayType);
                                }
                            ?>
                            <option value="<?php echo e($type); ?>" <?php echo e(request('type') == $type ? 'selected' : ''); ?>>
                                <?php echo e($displayType); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </form>
                    
            </div>
        </div>
        
        <!-- Add a no results message element -->
        <div id="noResults" class="alert alert-info d-none">
            <?php echo app('translator')->get('messages.ui.no_results'); ?>
        </div>
        
            <ul class="list-group" id="notificationList">
                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex notification-item justify-content-between align-items-start <?php echo e($notification->is_read ? '' : 'fw-bold bg-light'); ?>">
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center bk-title">
                                <?php
                                    // Badge classes
                                    switch ($notification->type) {
                                        case 'new_query':
                                        case 'new_Query':
                                            $badgeClass = 'bg-info'; 
                                            break;
                                        case 'booking_cancellation':
                                            $badgeClass = 'bg-danger'; 
                                            break;
                                        case 'max_voucher_limit_exceed':
                                            $badgeClass = 'bg-warning text-dark'; 
                                            break;
                                        case 'preferred_timings':
                                        case 'Preferred Timings':
                                            $badgeClass = 'bg-primary';
                                            break;
                                        case 'spo_product_request':
                                            $badgeClass = 'bg-warning'; 
                                            break;
                                        case 'payment_link_paid':
                                            $badgeClass = 'bg-dark';
                                            break;
                                        case 'new_booking_request':
                                            $badgeClass = 'bg-purple';
                                            break;
                                        case 'new_SPO_registration':
                                            $badgeClass = 'bg-success';
                                            break;
                                        case 'user_slot_change_request':
                                            $badgeClass = 'bg-pink';
                                            break;
                                        case 'SPO_product_enable':
                                        case 'SPO_product_administration':
                                            $badgeClass = 'bg-darkGreen';
                                            break;
                                        case 'payment_link_expired':
                                            $badgeClass = 'bg-danger';
                                            break;
                                        case 'voucher_expired':
                                            $badgeClass = 'bg-warning text-dark';
                                            break;
                                        default:
                                            $badgeClass = 'bg-secondary';
                                    }

                                    // Translate notification type
                                    $formattedType = trans('messages.types.' . strtolower($notification->type));
                                    if ($formattedType === 'messages.types.' . strtolower($notification->type)) {
                                        $formattedType = \Illuminate\Support\Str::title(str_replace('_', ' ', $notification->type));
                                    }
                                    
                                    // Translate status
                                    $status = trans('messages.notificationstatus.' . $notification->status);
                                    if ($status === 'messages.notificationstatus.' . $notification->status) {
                                        $status = $notification->status;
                                    }
                                ?>

                                <div>
                                    <span class="badge <?php echo e($badgeClass); ?> me-2 text-uppercase">
                                        <?php echo e($formattedType); ?>

                                    </span>
                                    <?php echo e($status); ?>

                                </div>
                                <?php if(!$notification->is_read): ?>
                                <form method="POST" action="<?php echo e(route('admin.notifications.read', $notification->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-sm btn-outline-success" title="<?php echo app('translator')->get('messages.ui.mark_as_read'); ?>">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                <?php else: ?>
                                    <form method="POST" action="<?php echo e(route('admin.notifications.unread', $notification->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-sm btn-outline-warning" title="<?php echo app('translator')->get('messages.ui.mark_as_unread'); ?>">
                                            <i class="fas fa-flag"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>

                            <p class="description">
                                <?php echo e(ucwords($notification->customer_name)); ?> - <?php echo e($notification->customer_email); ?> - <?php echo e($notification->customer_phone); ?>

                            </p>
                            
                            <?php if(is_array($notification->data)): ?>
                                <ul class="bk-details">
                                    <?php if(in_array($notification->type, ['new_booking_request','voucher_expired', 'payment_link_expired', 'new_SPO_registration', 'user_slot_change_request', 'SPO_product_enable', 'new_Query', 'SPO_product_administration', 'spo_product_request'])): ?>
                                        <?php $__currentLoopData = $notification->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                // Translate label
                                                $label = trans('messages.labels.' . $item['label']);
                                                if ($label === 'messages.labels.' . $item['label']) {
                                                    $label = ucwords($item['label']);
                                                }
                                            ?>
                                            <li><strong><?php echo e($label); ?>:</strong> <?php echo e(ucwords($item['value'])); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php $__currentLoopData = $notification->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                // Translate key
                                                $label = trans('messages.labels.' . $key);
                                                if ($label === 'messages.labels.' . $key) {
                                                    $label = ucwords(str_replace('_', ' ', $key));
                                                }
                                            ?>
                                            <li><strong><?php echo e($label); ?>:</strong> <?php echo e(ucwords($value)); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            <?php else: ?>
                                <div class="small text-muted mt-2"><?php echo e($notification->data); ?></div>
                            <?php endif; ?>
                        </div>
                        <small class="time"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>

            <div class="mt-4 cs-pagination">
                <?php echo e($notifications->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    $(document).ready(function(){
        $('#searchNotifications').on('keyup', function(){
            let searchText = $(this).val().toLowerCase().trim();
            let hasResults = false;
            
            if (searchText === '') {
                $('#notificationList .notification-item').show();
                $('#notificationList .notification-item').addClass('d-flex');
                $('#noResults').addClass('d-none');
                return;
            }
            
            $('#notificationList .notification-item').each(function(){
                let notificationText = $(this).text().toLowerCase();
                
                if (notificationText.includes(searchText)) {
                    $(this).addClass('d-flex');
                    $(this).show();
                    hasResults = true;
                } else {
                    $(this).removeClass('d-flex');
                    $(this).hide();
                }
            });

            if (hasResults) {
                $('#noResults').addClass('d-none');
            } else {
                $('#noResults').removeClass('d-none');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>