<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>SPO List</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>
    <h2>SPO List - <?php echo e(now()->format('d.m.Y')); ?></h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Full Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Business Type</th>
                <th>Business Model</th>
                <th>Contract Type</th>
                <th>Size of Location</th>
                <th>City</th>
                <th>Status</th>
                
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($vendor->title); ?> <?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?></td>
                    <td><?php echo e($vendor->email); ?></td>
                    <td><?php echo e($vendor->country_code); ?> <?php echo e($vendor->number); ?></td>
                    <td><?php echo e($vendor->business_type); ?></td>
                    <td><?php echo e($vendor->business_model); ?></td>
                    <td><?php echo e($vendor->contact_person); ?></td>
                    <td><?php echo e($vendor->size_of_location); ?></td>
                    <td><?php echo e($vendor->city); ?></td>
                    <td><?php echo e($vendor->status == 'active' ? 'Active' : 'Blocked'); ?></td>
                    
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/spo/pdf.blade.php ENDPATH**/ ?>