<?php $__env->startSection('content'); ?>

<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('admin.user.index')); ?>">user management</a>
            <a class="active" >Edit user</a>
        </div>
    </div>


    <div class="add-user-form">
        <h3>Edit user</h3>
        <form class="row g-3" method="Post" action="<?php echo e(route('admin.user.update',$user)); ?>" id="userForm">
            <?php echo csrf_field(); ?>
        
            <div class="col-md-1">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">title</label>
                    <select id="inputtitle" class="form-select" name="title">
                        <option value="mr" <?php echo e(old('title', $user->title) == 'mr' ? 'selected' : ''); ?>>Mr.</option>
                        <option value="mrs" <?php echo e(old('title', $user->title) == 'mrs' ? 'selected' : ''); ?>>Mrs.</option>
                        <option value="ms" <?php echo e(old('title', $user->title) == 'ms' ? 'selected' : ''); ?>>Ms.</option>
                    </select>
                    <span class="error-message" id="title-error"></span>
                </div>
            </div>
        
            <div class="col-md-5">
                <div class="comn-input-select">
                    <label for="first-name" class="form-label">First Name</label>
                    <input type="text" class="form-control" id="first-name" placeholder="Please enter first name" name="first_name" value="<?php echo e(old('first_name', $user->first_name)); ?>">
                    <span class="error-message" id="first_name-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="last-name" class="form-label">Last Name</label>
                    <input type="text" class="form-control" id="last-name"  placeholder="Please enter last name" name="last_name" value="<?php echo e(old('last_name', $user->last_name)); ?>">
                    <span class="error-message" id="last_name-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputAddress" class="form-label">Street, House Number</label>
                    <input type="text" class="form-control" id="inputAddress" name="street" value="<?php echo e(old('street', $user->street)); ?>">
                    <span class="error-message" id="street-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputAddress2" class="form-label">Zip Code</label>
                    <input type="number" class="form-control" id="inputAddress2" name="zip_code" value="<?php echo e(old('zip_code', $user->zip_code)); ?>">
                    <span class="error-message" id="zip_code-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputCity" class="form-label">City</label>
                    <input type="text" class="form-control" id="inputCity" name="city" value="<?php echo e(old('city', $user->city)); ?>">
                    <span class="error-message" id="city-error"></span>
                </div>
            </div>
            <div class="col-md-6">
                <div class="inner-main-input inner-main-input2">
                    <label for="inputState" class="form-label">Region/State</label>
                    <select class="form-select" name="region">
                        <option value=""><?php echo e(__('messages.select_region')); ?></option>

                        <?php $__currentLoopData = __('messages.region'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(($user->region ?? '') === $key ? 'selected' : ''); ?>>
                                <?php echo e($value); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    
                    <span class="error-message" id="region-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputState" class="form-label">Country</label>
                    <select id="inputState" class="form-select" name="country">
                        <option value="" hidden><?php echo e(__('messages.choose_country')); ?></option>

                        <?php $__currentLoopData = __('messages.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($label); ?>" <?php echo e(old('country', $user->country ?? '') === $label ? 'selected' : ''); ?>>
                                <?php echo e($label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="error-message" id="country-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="email-address" class="form-label">Email Address</label>
                    <input type="email" class="form-control" id="email-address" name="email" value="<?php echo e(old('email', $user->email)); ?>">
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputZip" class="form-label">Phone Number</label>
                    <div class="numer-input d-flex">
                        

                        <select name="country_code" class="form-select country_code_custom" required id="country_code">
                            <option value="">Select Code</option>
                            <option value="+49" data-image="https://flagcdn.com/16x12/de.png"  <?php echo e($user->country_code == '+49' ? 'selected' : ''); ?>>+49</option>
                            <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e($user->country_code == '+43' ? 'selected' : ''); ?>>+43</option>
                            <option value="+41"  data-image="https://flagcdn.com/16x12/ch.png" <?php echo e($user->country_code == '+41' ? 'selected' : ''); ?>>+41</option>
                        </select>
                        <input type="text" class="form-control" id="inputZip" placeholder="Please enter phone number"  name="number" value="<?php echo e(old('number', $user->number)); ?>">
                    </div>
                    <span class="error-message" id="number-error"></span>
                </div>
            </div>
        
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class=" add-user">Save Changes</button>
                    <button type="button" class="cancel-btn" onclick="window.location='<?php echo e(route('admin.user.index')); ?>'">
                        Cancel
                    </button>
                </div>
            </div>
        </form>
        
        
    </div>
</div>
</div>
</div>
<script>
   document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('userForm');
    const inputs = form.querySelectorAll('input, select');

    inputs.forEach(input => {
        input.addEventListener('input', function () {
            validateField(input);
        });
    });

    function validateField(input) {
    const value = input.value.trim();
    const name = input.name;
    let errorMessage = '';

    // Required field validation
    if (value === '') {
        switch (name) {
            case 'title':
                errorMessage = 'Please select a title.';
                break;
            case 'first_name':
                errorMessage = 'Please enter first name.';
                break;
            case 'last_name':
                errorMessage = 'Please enter last name.';
                break;
            case 'street':
                errorMessage = 'Please enter your street and house number.';
                break;
            case 'zip_code':
                errorMessage = 'Please enter your zip code.';
                break;
            case 'city':
                errorMessage = 'Please enter your city.';
                break;
            case 'country':
                errorMessage = 'Please select a country.';
            case 'region':
                errorMessage = 'Please select a region.';
                break;
            case 'number':
                errorMessage = 'Please enter phone number.';
                break;
            default:
                errorMessage = 'This field is required.';
        }
    }

    // Field-specific rules
    if (name === 'first_name' || name === 'last_name') {
        if (value && value.length > 50) {
            errorMessage = 'Maximum length is 50 characters.';
        }
    }

    if (name === 'zip_code') {
        if (value && value.length > 20) {
            errorMessage = 'Zip code must not exceed 20 characters.';
        }
    }

    if (name === 'number') {
        if (value && !/^[0-9+]*$/.test(value)) {
            errorMessage = 'Only digits and plus symbol are allowed.';
        } else if (value.length > 15 || value.length < 8) {
            errorMessage = 'Phone number should be between 8 to 15 digits.';
        }else if(value.length == 0){
            errorMessage = 'Please enter Phone number.';
        }
    }

    // Show/hide error
    const errorElement = document.getElementById(`${name}-error`);
    if (errorElement) {
        errorElement.textContent = errorMessage;
    }

    input.classList.toggle('is-invalid', !!errorMessage);
    return !errorMessage;
}


    form.addEventListener('submit', function (e) {
        let isValid = true;

        inputs.forEach(input => {
            if (!validateField(input)) {
                isValid = false;
            }
        });

        if (!isValid) {
            e.preventDefault(); 
        }
    });
});
</script>
</script>
      <script>
        function formatFlag(option) {
            if (!option.id) return option.text;
            const imageUrl = $(option.element).data('image');
            const text = option.text;
            if (imageUrl) {
                return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
            }
            return text;
        }
    
        $(document).ready(function () {
            $('#country_code').select2({
                templateResult: formatFlag,
                templateSelection: formatFlag,
                minimumResultsForSearch: -1 
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/user/edit.blade.php ENDPATH**/ ?>