<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
    <!-- Main CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/responsive.css')); ?>">
    <style>
        .is-invalid {
            border-color: #dc3545 !important;
        }
        .invalid-feedback {
            display: none;
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }
        .is-invalid ~ .invalid-feedback {
            display: block;
        }
    </style>
</head>

<body>
    <section>
        <div class="inner-login">
            <div class="row">
                <div class="col-lg-6">
                    <div class="inner-login-img">
                        <figure>
                            <img src="<?php echo e(asset('admin/images/login.png')); ?>" alt="">
                        </figure>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="upper-high-main">
                        <div class="inner-login-input-form">
                            <div class="inner-login-page">
                                <div class="inner-login-wrapper">
                                    <div class="logo-login">
                                        <img src="<?php echo e(asset('admin/images/login-logo.png')); ?>" alt="">
                                    </div>
                                    <h2>Login to your account</h2>
                                </div>
                                <form class="email-login" method="POST" action="<?php echo e(route('admin.login.submit')); ?>" id="loginForm">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-12 inner-main-input">
                                            <label for="email" class="form-label">Email Address</label>
                                            <input type="text" class="form-control" placeholder="Enter email address" id="email" name="email">
                                            <div class="invalid-feedback">Please enter a valid email address</div>
                                        </div>
                                        <div class="col-md-12 inner-main-input mb-3">
                                            <label for="password" class="form-label">Password</label>
                                            <div class="input-pass-show">
                                                <input id="password" type="password" class="form-control" name="password" placeholder="Enter your Password">
                                                
                                                <span class="toggle-password" toggle="#password">
                                                    <i class="fa fa-eye-slash"></i>
                                                </span>
                                                <div class="invalid-feedback">Please enter your password</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="remember-main-marg d-flex">
                                        <div class="">
                                            <div class="form-check check-s">
                                                <input class="form-check-input" type="checkbox" id="gridCheck" name="remember_me">
                                                <label class="form-check-label" for="gridCheck">
                                                    Remember Me
                                                </label>
                                            </div>
                                        </div>
                                        <div class="">
                                            <div class="">
                                                <a class="forgot-pass" href="<?php echo e(route('admin.forgot.password.view')); ?>">Forgot Password?</a>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="btn primary-btn w-100" type="submit">
                                        Login
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('loginForm');
            const emailInput = document.getElementById('email');
            const passwordInput = document.getElementById('password');
        
            function validateEmail(email) {
                const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return re.test(email.toLowerCase());
            }

            document.querySelector('.toggle-password').addEventListener('click', function () {
            const input = document.querySelector(this.getAttribute('toggle'));
            const icon = this.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });
        
            form.addEventListener('submit', function (e) {
                e.preventDefault();
                let isValid = true;
        
                // Reset states
                emailInput.classList.remove('is-invalid');
                passwordInput.classList.remove('is-invalid');
        
                // Email validation
                if (!emailInput.value.trim()) {
                    emailInput.nextElementSibling.textContent = "Please enter email address.";
                    emailInput.classList.add('is-invalid');
                    isValid = false;
                } else if (!validateEmail(emailInput.value.trim())) {
                    emailInput.nextElementSibling.textContent = "Please enter valid email address.";
                    emailInput.classList.add('is-invalid');
                    isValid = false;
                }
        
                // Password empty check only
                if (!passwordInput.value.trim()) {
                    passwordInput.nextElementSibling.textContent = "Please enter password.";
                    passwordInput.classList.add('is-invalid');
                    isValid = false;
                }
        
                if (isValid) {
                    form.submit();
                } else {
                    const firstInvalid = document.querySelector('.is-invalid');
                    if (firstInvalid) {
                        firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
                        firstInvalid.focus();
                    }
                }
            });
        
            // Blur validations
            emailInput.addEventListener('blur', function () {
                if (!this.value.trim() || !validateEmail(this.value.trim())) {
                    this.classList.add('is-invalid');
                } else {
                    this.classList.remove('is-invalid');
                }
            });
        
            passwordInput.addEventListener('blur', function () {
                if (!this.value.trim()) {
                    this.classList.add('is-invalid');
                } else {
                    this.classList.remove('is-invalid');
                }
            });
        });
        </script>
        
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>