<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="<?php echo e(route('admin.booking.index')); ?>">Booking Management</a>
                    <a class="active" href="">Edit Booking Details</a>
                </div>
            </div>
            <div class="add-user-form">
                <h3>Edit Booking <span class="ms-3"></span></h3>
                
                <form method="POST" action="<?php echo e(route('admin.update.booking.detail', $booking->id)); ?>">
                    <?php echo csrf_field(); ?>
                    
                    <div class="row">
                        <div class="col-md-1">
                            <div class="comn-input-select">
                                <label for="inputtitle" class="form-label">Title</label>
                                <select id="inputtitle" name="title" class="form-select">
                                    <option value="Mr."  <?php echo e((optional($booking->userDetails)->title ?? '') === 'Mr.' ? 'selected' : ''); ?>>
                                        <?php echo e(__('messages.title_mr')); ?>

                                    </option>
                                    <option value="Mrs." <?php echo e((optional($booking->userDetails)->title ?? '') === 'Mrs.' ? 'selected' : ''); ?>>
                                        <?php echo e(__('messages.title_mrs')); ?>

                                    </option>
                                   
                                   
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-5">
                            <div class="comn-input-select">
                                <label for="first-name" class="form-label">First Name</label>
                                <input type="text" class="form-control" id="first-name" name="first_name"
                                    value="<?php echo e(optional($booking->userDetails)->first_name); ?>" required>
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="last-name" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="last-name" name="last_name"
                                    value="<?php echo e(optional($booking->userDetails)->last_name); ?>" required>
                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Street, house number:</label>
                                <input type="text" class="form-control" id="inputAddress" name="address"
                                    value="<?php echo e(optional($booking->userDetails)->address); ?>" required>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress2" class="form-label">Zip Code</label>
                                <input type="text" class="form-control" id="inputAddress2" name="zip"
                                    value="<?php echo e(optional($booking->userDetails)->zip); ?>" required>
                                <?php $__errorArgs = ['zip'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputCity" class="form-label">City</label>
                                <input type="text" class="form-control" id="inputCity" name="city"
                                    value="<?php echo e(optional($booking->userDetails)->city); ?>" required>
                                <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputState" class="form-label">Country</label>
                                <select id="inputState" name="country" class="form-select" required>
                                    <option value=""><?php echo e(__('messages.choose_country')); ?></option>

                                    <?php $__currentLoopData = __('messages.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($label); ?>" <?php echo e(old('country', $booking->userDetails->country ?? '') === $label ? 'selected' : ''); ?>>
                                            <?php echo e($label); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="email-address" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email-address" name="email"
                                    value="<?php echo e(optional($booking->userDetails)->email); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputZip" class="form-label">Phone Number</label>
                                <div class="numer-input d-flex">
                                    <?php
                                        $phone = optional($booking->userDetails)->phone;
                                        $phoneCode = '+49';
                                        $phoneNumber = $phone;
                                        
                                        if ($phone && str_starts_with($phone, '+')) {
                                            $phoneCode = substr($phone, 0, 3);
                                            $phoneNumber = substr($phone, 3);
                                        }
                                    ?>
                                    
                                    <select id="phone_code" name="phone_code" class="form-select country_code_custom">
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e($phoneCode == '+49' ? 'selected' : ''); ?>>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e($phoneCode == '+43' ? 'selected' : ''); ?>>+43</option>
                                        <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" <?php echo e($phoneCode == '+41' ? 'selected' : ''); ?>>+41</option>
                                    </select>

                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="<?php echo e($phoneNumber); ?>" required>
                                </div>
                                <?php $__errorArgs = ['phone_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="note-main" class="form-label">Note</label>
                                <input type="text" class="form-control" id="note-main" name="notes"
                                    placeholder="Enter Note" value="<?php echo e($booking->notes ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-5">
                        <h4 class="booking-item-h">Prefered Time Functionality <span class="ms-3">Booking ID : #<?php echo e($booking->id); ?></span></h4>
                        
                        <div class="booking-items-container">
                            <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="booking-item-card mb-4 p-3 border rounded" data-item-id="<?php echo e($item->id); ?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <img src="<?php echo e($item->product->images->first() ? asset('storage/' . $item->product->images->where('type','home')->first()->image_path) : asset('frontend/images/roof1.jpg')); ?>"
                                                        alt="<?php echo e($item->product_name); ?>" class="img-fluid" />
                                    </div>
                                    <div class="col-md-9">
                                        <h5><?php echo e($item->product_name); ?> | <?php echo e($item->size); ?></h5>
                                        
                                        <div class="previous-booking-details mb-3 p-2 bg-light rounded">
                                            <h6>Current Booking:</h6>
                                            <p>
                                                Pickup: <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?> / <?php echo e(\Carbon\Carbon::parse($item->pickup_time)->format('H:i')); ?><br>
                                                Dropoff: <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?> / <?php echo e(\Carbon\Carbon::parse($item->dropoff_time)->format('H:i')); ?>

                                            </p>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Date</label>
                                                    <input type="text" 
                                                           class="form-control pickup-date flatpickr" 
                                                           data-item-id="<?php echo e($item->id); ?>"
                                                           placeholder="Select Pickup Date"
                                                           data-default-date="<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?>">
                                                    <input type="hidden" 
                                                           name="items[<?php echo e($item->id); ?>][pickup_date]" 
                                                           value="<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?>">
                                                    <?php $__errorArgs = ["items.{$item->id}.pickup_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Time</label>
                                                    <select name="items[<?php echo e($item->id); ?>][pickup_time]" class="form-control pickup-time" data-item-id="<?php echo e($item->id); ?>" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    <?php $__errorArgs = ["items.{$item->id}.pickup_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Date</label>
                                                    <input type="text" 
                                                           class="form-control dropoff-date flatpickr" 
                                                           data-item-id="<?php echo e($item->id); ?>"
                                                           placeholder="Select Dropoff Date"
                                                           data-default-date="<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>">
                                                    <input type="hidden" 
                                                           name="items[<?php echo e($item->id); ?>][dropoff_date]" 
                                                           value="<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?>">
                                                    <?php $__errorArgs = ["items.{$item->id}.dropoff_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Time</label>
                                                    <select name="items[<?php echo e($item->id); ?>][dropoff_time]" class="form-control dropoff-time" data-item-id="<?php echo e($item->id); ?>" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    <?php $__errorArgs = ["items.{$item->id}.dropoff_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="text-danger"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group mt-3">
                                            <label>Change Reason (Optional)</label>
                                            <textarea name="items[<?php echo e($item->id); ?>][change_reason]" class="form-control " style="font-size: 16px" rows="2"><?php echo e(old("items.$item->id.change_reason", $item->change_reason)); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <input type="hidden" id="vendor_id" value="<?php echo e($item->vendor_id); ?>">

                    <div class="col-12">
                        <div class="upper-main-btn-last-comn d-flex">
                            <button type="submit" class="add-user">Update Booking</button>
                            <a href="<?php echo e(route('admin.booking.index')); ?>" class="cancel-btn">Back</a>
                        </div>
                    </div>
                </form>

                <div class="return-block">
                    <h3>Return Related Functionalities </h3>
                    <?php
                        $hasAlreadyBooked = $booking->items->contains(function($item) {
                            return !empty($item->already_booked) && $item->already_booked == true;
                        });
                    ?>
                    <?php if($hasAlreadyBooked): ?>
                        <p style="color: red;">A booking has already been made against this booking . To avoid issues kindly check it. </p>
                    <?php endif; ?>

                    <form method="POST" class="cu-common-form" action="<?php echo e(route('admin.update.booking.returnDetail', $booking->id)); ?>">
                        <?php echo csrf_field(); ?>
                    
                        <div class="row">
                            <div class="col-md-12">
                                <div class="comn-input-select">
                                    <label for="damaged_item" class="form-label">Damaged</label>
                                    <select id="damaged_item" name="damaged_items[]" class="form-select" multiple>
                                        <option></option> 
                                        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option 
                                                value="<?php echo e($item->id); ?>" 
                                                data-product-name="<?php echo e($item->product_name); ?>" 
                                                data-product-days="<?php echo e($item->days); ?>"
                                                <?php if($item->damage): ?> selected <?php endif; ?>
                                            >
                                                <?php echo e($item->product_name); ?> - <?php echo e($item->size); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label for="delay" class="form-label">Delay:</label>
                                    <select id="delay" name="delay" class="form-select">
                                        <option value="0" <?php echo e($booking->delay == 0 ? 'selected' : ''); ?>>No</option>
                                        <option value="1" <?php echo e($booking->delay == 1 ? 'selected' : ''); ?>>Yes</option>
                                    </select>
                                </div>
                            </div>
                            <div id="delay_fields" class="row" style="display: <?php echo e($booking->delay ? 'block' : 'none'); ?>;">
                            <div class="col-md-12">
                                <div class="comn-input-select">
                                    <label for="delayed_item" class="form-label">Delay For Products</label>
                                    <select id="delayed_item" name="delayed_item" class="form-select" multiple>
                                        <option></option> 
                                        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option 
                                                value="<?php echo e($item->id); ?>" 
                                                data-product-name="<?php echo e($item->product_name); ?>" 
                                                data-product-days="<?php echo e($item->days); ?>"
                                                 data-related-item="<?php echo e($item->related_item); ?>"
                                                 data-roof-rack = "<?php echo e($item->is_roof_rack_product); ?>"
                                                <?php if($item->delay): ?> selected <?php endif; ?>
                                            >
                                                <?php echo e($item->product_name); ?> - <?php echo e($item->size); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                    
                            
                            
                            <div class="col-md-6 comn-input-select">
                                <label for="rental_from" class="form-label">New DropOff Date</label>
                                <?php
                                    $defaultDropoffDate = $booking->new_dropoff_date 
                                        ? \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y')
                                        : ($item->dropoff_date 
                                            ? \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') 
                                            : '');
                                ?>
                                <input type="text" 
                                    class="form-control new_dropoff rental_from" 
                                    data-item-id="<?php echo e($item->id); ?>"
                                    placeholder="Select New Drop Off Date"
                                    data-default-date="<?php echo e($defaultDropoffDate); ?>">
                         
                                <input type="hidden" 
                                        name="new_dropoff"
                                        value="<?php echo e($defaultDropoffDate); ?>">
                              
                               
                            </div>
                            <div class="col-md-6 comn-input-select">
                                <div class="form-group">
                                    <label>New Drop Off Time</label>
                                    <select name="new_dropoff_time" 
                                            class="form-control new_dropoff_time" 
                                            data-selected-time="<?php echo e($item->new_dropoff_time); ?>"
                                            disabled>
                                        <option value="">Select date first</option>
                                    </select>
                                   
                                </div>
                            </div>


                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Pickup Date</label>
                                        
                                        <?php $__errorArgs = ["items.{$item->id}.pickup_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                               
                            </div>
                    
                            <div class="col-md-12 d-flex align-items-center mt-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="delay_fee_checkbox" name="delay_fee_checkbox" value="1"
                                    <?php echo e($booking->delay ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="delay_fee_checkbox">
                                        Apply Delay Fee
                                    </label>
                                </div>
                            </div>
                    
                            <div class="col-md-12 mt-5">
                                <div class="comn-input-select col-md-6">
                                <label for="delay_fee" class="form-label">Delay Fee Amount (€)</label>
                                <input type="number" class="form-control" id="delay_fee" name="delay_fee" 
                                step="0.01" min="0" value="<?php echo e($booking->delay_fees); ?>">
                                </div>
                            </div>
                    
                            <div class="col-md-12 mt-3">
                                <div class="comn-input-select col-md-6">
                                <label for="additional_days" class="form-label">Additional Rental Days</label>
                                <input type="number" class="form-control" id="additional_days" name="additional_days" 
                                    min="0" value="<?php echo e($booking->additional_days); ?>">
                                </div>
                            </div>
                    
                        </div>

                        </div>
                        <?php
                            $subtotal = 0;
                            
                            $netPrice = 0;
                          
                            $tax = 0;
                            $total = 0; 
                        ?>
                            <div class="sub_heading_18">Cart Totals</div>
                            <div class="comm_detail_list_view cart_total_list">
                                <div class="comm_detail_list_col">
                                    <h5>Subtotal</h5>
                                    <h6 id="cart_sub_total"><?php echo e(number_format($subtotal, 2, ',', '')); ?> €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Delay Fees</h5>
                                    <h6 id="delay_fees"><?php echo e(number_format($netPrice, 2, ',', '')); ?> €</h6>
                                </div>
                               
                                <div class="comm_detail_list_col">
                                    <h5>Net Price</h5>
                                    <h6 id="net_price"><?php echo e(number_format($netPrice, 2, ',', '')); ?> €</h6>
                                </div>
                               
                                <div class="comm_detail_list_col">
                                    <h5>Tax (19%)</h5>
                                    <h6 id="tax"><?php echo e(number_format($tax, 2, ',', '')); ?> €</h6>
                                </div>
                                <div class="comm_detail_list_col bott_total_row">
                                    <h5>Total</h5>
                                    <h6 id="totalRow"></h6>
                                </div>
                            </div>
                            <input type="hidden" name="subtotal" id="subtotal_input">
                            <input type="hidden" name="delay_fees_value" id="delay_fees_input">
                            <input type="hidden" name="net_price" id="net_price_input">
                            <input type="hidden" name="tax" id="tax_input">
                            <input type="hidden" name="total" id="total_input">
                            <input type="hidden" name="return_booking_id" id="return_booking_id" value="<?php echo e($booking->id); ?>">

                            <input type="hidden" name="additional_days_rent" id="additional_days_rent" value="">

                            <?php echo e(\Carbon\Carbon::parse($booking->last_delay_payment_link_sent_at)->format('d.m.y H:i')); ?>

                            <p style="font-size: 12px">For resending the paymentlink please click on the "Update Return Information" This can be done without adjustments on the page.</p>
                            <div class="col-md-12 mt-4">
                                <button type="submit" class="add-user">
                                    Update Return Information
                                </button>
                            </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>





<div class="modal fade modal-delete-logout" id="syncItemsModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="syncItemsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="syncItemsModalLabel" class="mb-3">Synchronize Dates/Times</h4>
                    <p id="delete-description" class=" mb-0"> Do you want to update the pickup and dropoff date and time for all related items in this group as well?</p>
                    <div class="upper-btns-modal-pair">
                        <button type="button" id="syncItemsModalYes" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        <button type="button" id="syncItemsModalNo" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .flatpickr-input {
        background-color: white;
        cursor: pointer;
    }
    .booking-item-card {
        background-color: #f8f9fa;
        transition: all 0.3s ease;
    }
    .booking-item-card:hover {
        background-color: #e9ecef;
    }
    .previous-booking-details {
        font-size: 0.9rem;
    }
    .text-danger {
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
</style>

<?php if(!empty($warnings)): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const warnings = <?php echo json_encode($warnings, 15, 512) ?>;

    // Build readable message
    let html = '<ul style="text-align:left;">';
    warnings.forEach(w => {
        html += `<li style="font-size: 14px"><strong>${w.product_name}</strong>: <br/> Marking this booking as delayed may affect other bookings with an earlier pickup date and time depending on the new dropoff date and time you are going to insert here for this booking. </br></br>
            ${w.message}<br/></br><strong>Affected bookings:</strong><ul>
            `;
        w.affected_bookings.forEach(ab => {
            const formatDate = d => {
                const date = new Date(d);
                const day = String(date.getDate()).padStart(2, '0');       // 1 → "01"
                const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-indexed
                const year = date.getFullYear();
                return `${day}.${month}.${year}`;
            };
            const formatTime = t => {
                if (!t) return '';
                const [h, m] = t.split(':');
                return `${h.padStart(2, '0')}:${m.padStart(2, '0')}`;
            };

            html += `<li>(Booking #${ab.booking_id}) — ${formatDate(ab.pickup_date)} / ${formatTime(ab.pickup_time)} → ${formatDate(ab.dropoff_date)} ${formatTime(ab.dropoff_time)}, qty: ${ab.quantity}</li>`;
        });
        html += `</ul></li>`;
    });
    html += '</ul>';

    Swal.fire({
        title: 'Warning — Inventory Impact',
        html: html,
        icon: 'warning',
        width: 800,
        confirmButtonText: 'OK'
    });
});
</script>
<?php endif; ?>

<script>
    let itemData = <?php echo json_encode($booking->items->map(function($item) {
        return ['id' => $item->id, 'related_item' => $item->related_item];
    })); ?>;

    let pendingSync = null;
    let syncInProgress = false;

    function getGroupIds(changedId) {
        let main = itemData.find(i => i.id == changedId);
        if (!main) return [];
        let parentId = main.related_item ? main.related_item : main.id;
        let group = itemData.filter(i => (i.related_item == parentId || i.id == parentId)).map(i => i.id);
        return group;
    }

    function parseDate(dateStr) {
        const parts = dateStr.split('.');
        if (parts.length === 3) {
            return parts[2] + '-' + parts[1].padStart(2, '0') + '-' + parts[0].padStart(2, '0');
        }
        return dateStr;
    }

    $('#delay').on('change', function() {
        if ($(this).val() === '1') {
            $('#delay_fields').slideDown();
        } else {
            $('#delay_fields').slideUp();
        }
    });

    if ($('#delay').val() === '1') {
        $('#delay_fields').show();
    } else {
        $('#delay_fields').hide();
    }
    var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";
    
    $(document).ready(function() {
        let dailyPriceMap = {}; 
      
        $('#damaged_item').select2({
            placeholder: "Select damaged item(s)",
            allowClear: true,
            width: '100%'
        });
        $('#delayed_item').select2({
            placeholder: "Select delayed item(s)",
            allowClear: true,
            width: '100%'
        });

        $('#damaged_item').on('change', function() {
            let selectedIds = $(this).val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            if (selectedIds.length === 0) {
                calculateRent();
                return;
            }

            let requests = [];
            dailyPriceMap = {}; 

            selectedIds.forEach(id => {
                let productName = $(`#damaged_item option[value="${id}"]`).data('product-name');

                requests.push(
                    $.get(`${baseUrl}/admin/dailyPrice/product`, { productName }, function(data) {
                        dailyPriceMap[id] = data;
                    })
                );
            });

            $.when.apply($, requests).done(function() {
                calculateRent();
            });
        });

        $('#delayed_item').on('change', function() {
            let selectedIds = $(this).val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            if (selectedIds.length === 0) {
                calculateRent();
                return;
            }

            let requests = [];
            dailyPriceMap = {}; 

            selectedIds.forEach(id => {
                let productName = $(`#delayed_item option[value="${id}"]`).data('product-name');
                let relatedItem = $(`#delayed_item option[value="${id}"]`).data('related-item');
                let roofRackProduct = $(`#delayed_item option[value="${id}"]`).data('roof-rack');

                if (relatedItem ) {
                    productName = "Dachträger ergänzt zu Dachbox/ Dachfahrradträger";
                } else {
                    productName = productName;
                }

                if(roofRackProduct){
                    productName = '';
                }
                if(productName){

                    requests.push(
                        $.get(`${baseUrl}/admin/dailyPrice/product`, { productName }, function(data) {
                            dailyPriceMap[id] = data;
                        })
                    );
                }
            });

            $.when.apply($, requests).done(function() {
                calculateRent();
            });
        });

        $('#additional_days, #delay_fee, #delay_fee_checkbox').on('input change', function() {
            calculateRent();
        });

        function calculateRent() {
            let selectedIds =  $('#delayed_item').val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            let additionalDays = parseInt($('#additional_days').val() || 0, 10);
            let total = 0;
            let subtotal = 0;

            selectedIds.forEach(id => {
                let oldDays =  parseInt($(`#delayed_item option[value="${id}"]`).data('product-days') || 0, 10);
                let totalDays = oldDays + additionalDays;
                let prices = dailyPriceMap[id] || [];

                for (let i = oldDays + 1; i <= totalDays && i < prices.length; i++) {
                    total += parseFloat(prices[i] || 0);
                    subtotal += parseFloat(prices[i] || 0);
                }
            });
            $('#additional_days_rent').val(total);

           
            let tax = subtotal - (subtotal/1.19);
            subtotal = subtotal / 1.19;
            let netPrice = subtotal; 
            
            if ($('#delay_fee_checkbox').is(':checked')) {
                total += parseFloat($('#delay_fee').val() || 0);
                netPrice += parseFloat($('#delay_fee').val() / 1.19 || 0);
                tax += parseFloat($('#delay_fee').val() || 0) - parseFloat($('#delay_fee').val() / 1.19 || 0);
            }

            $('#subtotal_input').val(subtotal.toFixed(2));
            $('#delay_fees_input').val(parseFloat($('#delay_fee').val() || 0).toFixed(2));
            $('#net_price_input').val(netPrice.toFixed(2));
            $('#tax_input').val(tax.toFixed(2));
            $('#total_input').val(total.toFixed(2));

            $('#cart_sub_total').text(formatEuro(subtotal));
            $('#totalRow').text(formatEuro(total));
            $('#net_price').text(formatEuro(netPrice));
            $('#tax').text(formatEuro(tax));
            $('#delay_fees').text(formatEuro(parseFloat($('#delay_fee').val() || 0)));
        }

        function formatEuro(amount) {
            return amount.toLocaleString('de-DE', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + ' €';
        }
        if ($('#delayed_item').val() && $('#delayed_item').val().length > 0) {
            $('#delayed_item').trigger('change');
        } else {
            calculateRent();
        }
    });

    $(document).on('change', '.pickup-date,.pickup-time,.dropoff-date,.dropoff-time', function () {
        if (syncInProgress) return;
        
        let $input = $(this);
        let itemId = parseInt($input.data('item-id'));
        let groupIds = getGroupIds(itemId);

        if (groupIds.length > 1) {
            let inputType = '';
            if ($input.hasClass('pickup-date')) inputType = 'pickup-date';
            else if ($input.hasClass('pickup-time')) inputType = 'pickup-time';
            else if ($input.hasClass('dropoff-date')) inputType = 'dropoff-date';
            else if ($input.hasClass('dropoff-time')) inputType = 'dropoff-time';

            pendingSync = {
                itemId: itemId,
                groupIds: groupIds,
                inputType: inputType,
                newValue: $input.val(),
                $triggerInput: $input
            };
            $('#syncItemsModal').modal('show');
        }
    });

    $('#syncItemsModalYes').on('click', function () {
        if (pendingSync) {
            syncInProgress = true;
            
            pendingSync.groupIds.forEach(function (id) {
                if (id == pendingSync.itemId) return;

                let $targetInput = $(`.booking-item-card[data-item-id="${id}"] .${pendingSync.inputType}`);
                if ($targetInput.length) {
                    if (pendingSync.inputType.includes('date')) {
                        let flatpickrInstance = $targetInput[0]._flatpickr;
                        if (flatpickrInstance) {
                            flatpickrInstance.setDate(pendingSync.newValue, true);
                        } else {
                            $targetInput.val(pendingSync.newValue);
                            let hiddenName = pendingSync.inputType === 'pickup-date' ? 
                                `items[${id}][pickup_date]` : `items[${id}][dropoff_date]`;
                            $(`input[name="${hiddenName}"]`).val(pendingSync.newValue);
                            
                            const isPickup = pendingSync.inputType === 'pickup-date';
                            const dateForApi = parseDate(pendingSync.newValue);
                            loadTimeSlots(id, dateForApi, isPickup);
                        }
                    } else if (pendingSync.inputType.includes('time')) {
                        $targetInput.val(pendingSync.newValue).trigger('change');
                    }
                }
            });
            
            syncInProgress = false;
        }
        $('#syncItemsModal').modal('hide');
        pendingSync = null;
    });

    $('#syncItemsModalNo').on('click', function () {
        $('#syncItemsModal').modal('hide');
        pendingSync = null;
    });

    $(document).ready(function() {
        $('.rental_from').flatpickr({
            dateFormat: "d.m.Y",
            minDate: "today",
            disable: [
                function(date) {
                    return (date.getDay() === 0 || date.getDay() === 6);
                }
            ],
            locale: {
                firstDayOfWeek: 1
            },
            defaultDate: $('.new_dropoff').data('default-date'),
            onChange: function(selectedDates, dateStr, instance) {
                const itemId = instance.element.dataset.itemId;
                $(`input[name="new_dropoff"]`).val(dateStr);

                if (dateStr) {
                    loadTimeSlotsDelay(itemId, dateStr);
                } else {
                    const timeSelect = $(`.new_dropoff_time`);
                    timeSelect.html('<option value="">Select date first</option>').prop('disabled', true);
                }
                
                validateDateRange(itemId);
            }
        });

        $('.flatpickr').flatpickr({
            dateFormat: "d.m.Y",
            minDate: "today",
            disable: [
                function(date) {
                    return (date.getDay() === 0 || date.getDay() === 6);
                }
            ],
            locale: {
                firstDayOfWeek: 1
            },
            onChange: function(selectedDates, dateStr, instance) {
                const itemId = instance.element.dataset.itemId;
                const isPickup = instance.element.classList.contains('pickup-date');
                
                $(`input[name="items[${itemId}][${isPickup ? 'pickup' : 'dropoff'}_date]"]`).val(dateStr);
                
                $(`.booking-item-card[data-item-id="${itemId}"] .${isPickup ? 'pickup' : 'dropoff'}-date`).next('.text-danger').remove();
                
                if (dateStr) {
                    loadTimeSlots(itemId, dateStr, isPickup);

                    if (!isPickup) {
                        validateDateRange(itemId);
                    }
                    
                    // If this is a pickup date change, update dropoff minDate
                    if (isPickup) {
                        const dropoffInput = $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`);
                        if (dropoffInput.length) {
                            const dropoffInstance = dropoffInput[0]._flatpickr;
                            if (dropoffInstance) {
                                // Set minDate for dropoff to be at least the pickup date
                                dropoffInstance.set('minDate', selectedDates[0]);
                                
                                // Validate if dropoff date is already selected
                                validateDateRange(itemId);
                            }
                        }
                    }
                } else {
                    const timeSelect = isPickup ? 
                        $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                        $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                    timeSelect.html('<option value="">Select date first</option>').prop('disabled', true);
                }
                
                validateDateRange(itemId);
            }
        });
        
        function loadTimeSlots(itemId, date, isPickup) {
            const timeSelect = isPickup ? 
                $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                
            timeSelect.prop('disabled', true).html('<option value="">Loading time slots...</option>');
            
            $.ajax({
                url: `${baseUrl}/admin/getTime`,
                type: 'GET',
                data: {
                    date: date,
                    item_id: itemId,
                    is_pickup: isPickup,
                    vendor_id : $('#vendor_id').val()
                },
                success: function(response) {
                    let options = '<option value="">No time selected (keep current)</option>';
                    
                    if (response.slots && response.slots.length > 0) {
                        response.slots.forEach(slot => {
                            const timeValue = slot.label.split(' - ')[0];
                            const disabledAttr = slot.disabled ? 'disabled' : '';
                            
                            options += `<option value="${timeValue}" ${disabledAttr}>${slot.label}</option>`;
                        });
                    }
                    
                    timeSelect.html(options).prop('disabled', false);
                    
                    const previousTime = isPickup ? 
                        "<?php echo e($item->pickup_time); ?>" : 
                        "<?php echo e($item->dropoff_time); ?>";
                    if (previousTime) {
                        timeSelect.find('option').each(function() {
                            if ($(this).val() === previousTime) {
                                $(this).prop('selected', true);
                                return false;
                            }
                        });
                    } else {
                        timeSelect.val('');
                    }
                },
                error: function() {
                    timeSelect.html('<option value="">Error loading slots</option>');
                }
            });
        }

        const newDropoffDate = $('input[name="new_dropoff"]').val();
        if (newDropoffDate) {
            const itemId = $('.new_dropoff').data('item-id');
            loadTimeSlotsDelay(itemId, newDropoffDate);
            
            let selectedTime = $('.new_dropoff_time').data('selected-time');
            selectedTime = selectedTime.substring(0,5);
            if (selectedTime) {
                $(document).ajaxStop(function() {
                    $('.new_dropoff_time').val(selectedTime);
                });
            }
        }

        function loadTimeSlotsDelay(itemId, date) {
            const timeSelect = $(`.new_dropoff_time`);
                
            timeSelect.prop('disabled', true).html('<option value="">Loading time slots...</option>');
            
            $.ajax({
                url: `${baseUrl}/admin/getTime`,
                type: 'GET',
                data: {
                    date: date,
                    item_id: itemId,
                    vendor_id : $('#vendor_id').val()
                },
                success: function(response) {
                    let options = '<option value="">No time selected (keep current)</option>';
                    
                    if (response.slots && response.slots.length > 0) {
                        response.slots.forEach(slot => {
                            const timeValue = slot.label.split(' - ')[0];
                            const disabledAttr = slot.disabled ? 'disabled' : '';
                            
                            options += `<option value="${timeValue}" ${disabledAttr}>${slot.label}</option>`;
                        });
                    }
                    
                    timeSelect.html(options).prop('disabled', false);
                    const selectedTime = timeSelect.data('selected-time');
                    if (selectedTime) {
                        timeSelect.val(selectedTime);
                    } else {
                        timeSelect.val('');
                    }
                    
                },
                error: function() {
                    timeSelect.html('<option value="">Error loading slots</option>');
                }
            });
        }
        
        function validateDateRange(itemId) {
            const pickupDateStr = $(`input[name="items[${itemId}][pickup_date]"]`).val();
            const dropoffDateStr = $(`input[name="items[${itemId}][dropoff_date]"]`).val();
            
            // Remove any existing error messages
            $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).next('.text-danger').remove();
            $(`.booking-item-card[data-item-id="${itemId}"] .pickup-date`).next('.text-danger').remove();
            
            if (pickupDateStr && dropoffDateStr) {
                // Convert date strings to Date objects (format: d.m.Y)
                const pickupParts = pickupDateStr.split('.');
                const dropoffParts = dropoffDateStr.split('.');
                
                const pickupDate = new Date(pickupParts[2], pickupParts[1] - 1, pickupParts[0]);
                const dropoffDate = new Date(dropoffParts[2], dropoffParts[1] - 1, dropoffParts[0]);
                
                if (dropoffDate < pickupDate) {
                    const errorDiv = $('<div class="text-danger">Dropoff date must be after pickup date</div>');
                    $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).after(errorDiv);
                    return false;
                }
            }
            return true;
        }
        
        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($item->pickup_date): ?>
                loadTimeSlots("<?php echo e($item->id); ?>", "<?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('Y-m-d')); ?>", true);
            <?php endif; ?>
            <?php if($item->dropoff_date): ?>
                loadTimeSlots("<?php echo e($item->id); ?>", "<?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('Y-m-d')); ?>", false);
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });

    
    
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/booking/edit_booking_detail.blade.php ENDPATH**/ ?>