<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div id="sidebar"></div>
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="<?php echo e(route('admin.products.index')); ?>">product management</a>
                    <a class="active" href="">Quick Edit Product</a>
                </div>
            </div>

            <div class="add-user-form">
                <h3>Quick Edit Product</h3>
                <form class="row" method="POST" action="<?php echo e(route('admin.products.quick-update', $product->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="alert alert-info">
                        <i class="fa-solid fa-info-circle"></i> 
                        This is a lightweight edit mode. For editing variations and colors, please use the full edit page.
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="product-name" class="form-label">Product Name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" placeholder="Enter Product Name"
                                    id="product-name" name="name" value="<?php echo e(old('name', $product->name)); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Product category<span class="text-danger">*</span></label>
                                <select id="category" class="form-select required" name="category_id">
                                    <option value="">Select Product Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Product brand<span class="text-danger">*</span></label>
                                <select id="brand" class="form-select required" name="brand_id">
                                    <option value="">select product brand</option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($brand->id); ?>" <?php echo e($product->brand_id == $brand->id ? 'selected' : ''); ?>><?php echo e($brand->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="inputState1" class="form-label multiselect-form">description<span class="text-danger">*</span></label>
                                <textarea class="form-control required" placeholder="Enter Description" 
                                    style="height: 145px; resize:none;" name="description"><?php echo e(old('description', $product->description)); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="railing_type" name="railing_type" value="1" 
                                        <?php if(isset($product) && $product->railing_type): ?> checked <?php endif; ?>>
                                    <label class="form-check-label" for="railing_type">
                                        Railing Type Required <span class="text-danger">*</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Basic Product Info (for non-variant products) -->
                    <?php if($product->variations->isEmpty()): ?>
                    <div class="inner-add-color">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label for="last-name" class="form-label">Product Weight</label>
                                    <div class="price_icon_input">
                                        <input type="text" class="form-control" placeholder="Enter Product Weight" 
                                            name="weight" value="<?php echo e($product->weight); ?>">
                                        <p>Kg</p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label for="inputState" class="form-label">Status<span class="text-danger">*</span></label>
                                    <select class="form-select required" name="status">
                                        <option value="in_stock" <?php echo e($product->status == 'in_stock' ? 'selected' : ''); ?>>In Stock</option>
                                        <option value="out_of_stock" <?php echo e($product->status == 'out_of_stock' ? 'selected' : ''); ?>>Out of Stock</option>
                                        <option value="pre_order" <?php echo e($product->status == 'pre_order' ? 'selected' : ''); ?>>Pre-order</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="comn-input-select mb-2">
                                    <label for="inputCity" class="form-label mb-0">Product Dimensions</label>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="comn-input-select">
                                            <label class="form-label">length</label>
                                            <div class="price_icon_input">
                                                <input type="text" class="form-control" placeholder="Enter length" 
                                                    name="length" value="<?php echo e($product->length); ?>">
                                                <p>mm</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="comn-input-select">
                                            <label class="form-label">width</label>
                                            <div class="price_icon_input">
                                                <input type="text" class="form-control" placeholder="Enter Width" 
                                                    name="width" value="<?php echo e($product->width); ?>">
                                                <p>mm</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="comn-input-select">
                                            <label class="form-label">height</label>
                                            <div class="price_icon_input">
                                                <input type="text" class="form-control" placeholder="Enter height" 
                                                    name="height" value="<?php echo e($product->height); ?>">
                                                <p>mm</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label class="form-label">Volume</label>
                                    <div class="price_icon_input">
                                        <input type="number" class="form-control" placeholder="Enter Volume" 
                                            name="volume" value="<?php echo e($product->volume); ?>">
                                        <p>L</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label class="form-label">Max. Load</label>
                                    <div class="price_icon_input">
                                        <input type="number" class="form-control" placeholder="Enter Max. Load" 
                                            name="max_load" value="<?php echo e($product->max_load); ?>">
                                        <p>Kg</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Other Information Section -->
                    <div class="comn-input-select">
                        <label class="form-label">Other Information<span class="text-danger">*</span></label>
                    </div>
                    <div id="other-info-container">
                        <?php $__currentLoopData = $product->otherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infoIndex => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="other-info-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="comn-input-select">
                                            <div class="btn-category">
                                                <label class="uplod-file" for="file-up-<?php echo e($infoIndex); ?>">
                                                    <i class="fa-solid fa-arrow-up-from-bracket"></i>
                                                    <p>Upload image</p>
                                                </label>
                                                <input type="file" class="form-control uplod-file-inpt" id="file-up-<?php echo e($infoIndex); ?>" name="other_info[<?php echo e($infoIndex); ?>][image]">
                                                <input type="hidden" name="other_info[<?php echo e($infoIndex); ?>][id]" value="<?php echo e($info->id); ?>">
                                                <input type="text" class="form-control required" placeholder="Enter description here" name="other_info[<?php echo e($infoIndex); ?>][description]" value="<?php echo e($info->description); ?>">
                                                <a class="delete-outline-btn remove-info" href="javascript:void(0)">Delete</a>
                                                <?php if($info->image_path): ?>
                                                    <div class="d-flex align-items-center preview-wrapper">
                                                        <img src="<?php echo e(asset('storage/' . $info->image_path)); ?>" width="100" class="me-2 preview-image">
                                                        <input type="hidden" name="other_info[<?php echo e($infoIndex); ?>][existing_image]" value="<?php echo e($info->image_path); ?>">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="other-info-block d-none" id="other-info-template">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="comn-input-select">
                                    <div class="btn-category">
                                        <label class="uplod-file" for="file-up-__INDEX__">
                                            <i class="fa-solid fa-arrow-up-from-bracket"></i>
                                            <p>Upload image</p>
                                        </label>
                                        <input type="file" class="form-control uplod-file-inpt" id="file-up-__INDEX__" name="other_info[__INDEX__][image]">
                                        <input type="hidden" name="other_info[__INDEX__][id]">
                                        <input type="text" class="form-control required" placeholder="Enter description here" name="other_info[__INDEX__][description]">
                                        <a class="delete-outline-btn remove-info" href="javascript:void(0)">Delete</a>
                                         <div class="preview-wrapper mt-2"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="button" id="add-info-btn" class="add-user">Add Another Information</button>

                    <!-- Keywords and Related Products -->
                    <div class="row marg-t-b">
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="product-name" class="form-label">Keywords<span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" placeholder="Enter Keywords" 
                                    name="keywords" value="<?php echo e($product->keywords); ?>">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Related Products</label>
                                <select id="related-products" class="form-select" name="related_products[]" multiple>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $mainPhoto = $prod->mainPhoto->image_path ?? null;
                                        ?>
                                        <option 
                                            value="<?php echo e($prod->id); ?>" 
                                            data-image="<?php echo e($mainPhoto ? asset('storage/' . $mainPhoto) : ''); ?>"
                                            <?php echo e(in_array($prod->id, $selectedOptionIds) ? 'selected' : ''); ?>>
                                            <?php echo e($prod->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Available Models Section -->
                    <div class="row marg-t-b">
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="inputAddress2" class="form-label">available models<span class="text-danger">*</span></label>
                                <div class="btn-category models-container flex-direc-column">
                                    <?php $__currentLoopData = $product->models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modelIndex => $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex-main-avail-model w-100">
                                            <div class="model-row cat w-100">
                                                <input type="text" class="form-control mb-3 required" placeholder="enter title here" 
                                                    name="models[<?php echo e($modelIndex); ?>][title]" value="<?php echo e($model->title); ?>">
                                                <textarea class="form-control required" placeholder="Enter Description Here" 
                                                    style="height: 145px; resize:none;" 
                                                    name="models[<?php echo e($modelIndex); ?>][description]"><?php echo e($model->description); ?></textarea>
                                            </div>
                                            <a class="delete-outline-btn remove-model">Delete</a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <button type="button" id="add-model" class="add-user marg-t-30">Add another available model</button>
                            </div>
                        </div>
                    </div>

                    <!-- Images Section -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="upload-photo" class="form-label multiselect-form">Upload Photos<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="upload-photo" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add photos</p>
                                    </label>
                                    <input type="file" id="upload-photo" class="d-none" name="gallery_images[]" accept="image/*" multiple>
                                </div>
                                <div id="image-previews" class="d-flex mt-2">
                                    <?php $__currentLoopData = $product->images->where('type', 'gallery'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="preview-item show-one-img p-0" style="position: relative;">
                                            <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>">
                                            <input type="hidden" name="existing_gallery_images[]" value="<?php echo e($image->id); ?>">
                                            <div class="cross remove-existing-image" data-id="<?php echo e($image->id); ?>">
                                                <i class="fa-solid fa-xmark"></i>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <p class="support-show">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="main-image" class="form-label multiselect-form">Upload product main Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="main-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="main-image" class="d-none" name="main_image" accept="image/*">
                                </div>
                                <div id="main-image-preview" class="d-flex mt-2">
                                    <?php if($mainImage = $product->images->where('type', 'main')->first()): ?>
                                        <div class="preview-item show-one-img p-0" style="position: relative;">
                                            <img src="<?php echo e(asset('storage/' . $mainImage->image_path)); ?>">
                                            <input type="hidden" name="existing_main_image" value="<?php echo e($mainImage->id); ?>">
                                            <div class="cross remove-existing-image" data-id="<?php echo e($mainImage->id); ?>">
                                                <i class="fa-solid fa-xmark"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="info-image" class="form-label multiselect-form">Upload information Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="info-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="info-image" class="d-none" name="info_image" accept="image/*">
                                </div>
                                <div id="info-image-preview" class="d-flex mt-2">
                                    <?php if($infoImage = $product->images->where('type', 'info')->first()): ?>
                                        <div class="preview-item show-one-img p-0" style="position: relative;">
                                            <img src="<?php echo e(asset('storage/' . $infoImage->image_path)); ?>">
                                            <input type="hidden" name="existing_info_image" value="<?php echo e($infoImage->id); ?>">
                                            <div class="cross remove-existing-image" data-id="<?php echo e($infoImage->id); ?>">
                                                <i class="fa-solid fa-xmark"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="home-image" class="form-label multiselect-form">Upload Product Preview Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="home-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="home-image" class="d-none" name="home_image" accept="image/*">
                                </div>
                                <div id="home-image-preview" class="d-flex mt-2">
                                    <?php if($homeImage = $product->images->where('type', 'home')->first()): ?>
                                        <div class="preview-item show-one-img p-0" style="position: relative;">
                                            <img src="<?php echo e(asset('storage/' . $homeImage->image_path)); ?>">
                                            <input type="hidden" name="existing_home_image" value="<?php echo e($homeImage->id); ?>">
                                            <div class="cross remove-existing-image" data-id="<?php echo e($homeImage->id); ?>">
                                                <i class="fa-solid fa-xmark"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="upper-main-btn-last-comn d-flex btn-main-upload-edit">
                            <button type="submit" class="add-user">Update product</button>
                            <a href="<?php echo e(route('admin.products.index')); ?>" class="cancel-btn">Cancel</a>
                            <!-- <?php if($product->variations->isNotEmpty()): ?>
                                <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" class="add-user ms-2" style="background-color: #28a745;">
                                    <i class="fa-solid fa-edit"></i> Full Edit (with variations)
                                </a>
                            <?php endif; ?> -->
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 for related products
    $('#related-products').select2({
        maximumSelectionLength: 3,
        placeholder: "Select up to 3 SKUs",
        templateResult: formatOption,
        templateSelection: formatOption
    });

    function formatOption(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`
                <div style="display: flex; align-items: center;">
                    <img src="${imageUrl}" style="width:30px;height:30px;object-fit:cover;margin-right:10px;" />
                    <span>${text}</span>
                </div>
            `);
        }
        return text;
    }

    // Remove existing image - FIXED to work with all image types
    $(document).on('click', '.remove-existing-image', function(e) {
        e.preventDefault();
        const imageId = $(this).data('id');
        const previewContainer = $(this).closest('.upload-img-show').find('.d-flex.mt-2');
        
        $(this).closest('.preview-item').remove();
        
        // Add hidden input to track removed image
        $('<input>').attr({
            type: 'hidden',
            name: 'removed_images[]',
            value: imageId
        }).appendTo('form');
    });

    // Models functionality
    let modelCounter = <?php echo e(count($product->models) ?? 0); ?>;
    $('#add-model').click(function() {
        const newRow = `
        <div class="flex-main-avail-model w-100">
            <div class="model-row cat w-100">
                <input type="text" class="form-control mb-3 required" placeholder="enter title here" name="models[${modelCounter}][title]">
                <textarea class="form-control required" placeholder="Enter Description Here" style="height: 145px; resize:none;" name="models[${modelCounter}][description]"></textarea>
            </div>
            <a class="delete-outline-btn remove-model">Delete</a>
        </div>`;
        $('.models-container').append(newRow);
        modelCounter++;
    });

    $(document).on('click', '.remove-model', function() {
        $(this).closest('.flex-main-avail-model').remove();
    });

    // Other info functionality
    let infoCounter = <?php echo e(count($product->otherInfo) ?? 0); ?>;
    
    $('#add-info-btn').on('click', function() {
        let $clone = $('#other-info-template').clone().removeAttr('id').removeClass('d-none');
        $clone.find('[name]').each(function() {
            $(this).attr('name', $(this).attr('name').replace('__INDEX__', infoCounter));
        });
        $clone.find('.uplod-file-inpt').attr('id', `file-up-${infoCounter}`).val('');
        $clone.find('label.uplod-file').attr('for', `file-up-${infoCounter}`);
        
        // Add preview container for new other info
        $clone.find('.btn-category').append('<div class="preview-wrapper mt-2"></div>');
        
        $('#other-info-container').append($clone);
        infoCounter++;
    });

    $(document).on('click', '.remove-info', function() {
        $(this).closest('.other-info-block').remove();
    });

    // Image preview for other info images - ADDED
    // $(document).on('change', '.uplod-file-inpt', function(e) {
    //     const file = e.target.files[0];
    //     const previewContainer = $(this).closest('.btn-category').find('.preview-wrapper');
        
    //     if (file) {
    //         const reader = new FileReader();
    //         reader.onload = function(event) {
    //             previewContainer.html(`
    //                 <div class="d-flex align-items-center">
    //                     <img src="${event.target.result}" width="100" class="me-2 preview-image">
    //                     <a class="delete-outline-btn remove-other-info-preview" href="javascript:void(0)">Remove</a>
    //                 </div>
    //             `);
    //         }
    //         reader.readAsDataURL(file);
    //     }
    // });

     $(document).on('change', '.uplod-file-inpt', function () {
        let input = this;
        let wrapper = $(input).closest('.btn-category');
        wrapper.find('.preview-wrapper').remove(); // remove previous preview if exists

        if (input.files && input.files[0]) {
            let reader = new FileReader();
            reader.onload = function (e) {
                let previewWrapper = $('<div class="preview-wrapper" style="margin-top:10px;"></div>');
                let img = $(' <img class="preview-image">').attr('src', e.target.result);
                let btn = $('<button type="button" class="cross remove-preview"><i class="fa-solid fa-xmark"></i></button>');

                btn.on('click', function () {
                    $(input).val('');
                    previewWrapper.remove();
                });

                previewWrapper.append(img).append(btn);
                wrapper.append(previewWrapper);
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    // Remove other info image preview - ADDED
    $(document).on('click', '.remove-other-info-preview', function() {
        const container = $(this).closest('.btn-category');
        container.find('.uplod-file-inpt').val('');
        container.find('.preview-wrapper').empty();
    });

    // Image preview functionality for gallery images
    $('#upload-photo').change(function(e) {
        const files = e.target.files;
        const previewContainer = $('#image-previews');
        previewContainer.empty();
        for (let i = 0; i < files.length; i++) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-mul" data-index="${i}">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </div>`);
            }
            reader.readAsDataURL(files[i]);
        }
    });

    // Image preview functionality for main image
    $('#main-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#main-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}" >
                    <div class="cross remove-new-preview">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

    // Image preview functionality for info image
    $('#info-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#info-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}" >
                    <div class="cross remove-new-preview">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

    // Image preview functionality for home image
    $('#home-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#home-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}" >
                    <div class="cross remove-new-preview">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

    // Remove new image previews
    $(document).on('click', '.remove-new-preview', function() {
        const container = $(this).closest('.upload-img-show');
        const input = container.find('input[type="file"]');
        input.val('');
        $(this).closest('.preview-item').remove();
    });

    // Remove gallery preview images
    $(document).on('click', '.remove-preview-mul', function() {
        const index = $(this).data('index');
        const input = $('#upload-photo');
        const files = input[0].files;
        
        // Create new FileList without the removed file
        const dt = new DataTransfer();
        for (let i = 0; i < files.length; i++) {
            if (i !== index) {
                dt.items.add(files[i]);
            }
        }
        input[0].files = dt.files;
        
        // Remove the preview
        $(this).closest('.preview-item').remove();
        
        // Update indices for remaining previews
        $('#image-previews .remove-preview-mul').each(function(newIndex) {
            $(this).data('index', newIndex);
        });
    });
});
</script>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/product/quick-edit.blade.php ENDPATH**/ ?>